/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.dom;

import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dom.DOMPosition;
import org.eclipse.jst.pagedesigner.dom.DOMRefPosition;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.eclipse.jst.pagedesigner.validation.caret.IMovementMediator;
import org.eclipse.jst.pagedesigner.validation.caret.Target;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

public class CaretMoveIterator {
    private static final Logger _log = PDPlugin.getLogger(CaretMoveIterator.class);
    private final boolean INNER_DEBUG = false;
    private NodeIterator _nodeIterator;
    private IMovementMediator _validator;
    private IDOMPosition _currentPosition;
    private boolean _forward;

    public CaretMoveIterator(NodeIterator nodeIterator, IMovementMediator validator, IDOMPosition position, boolean forward) {
        this._nodeIterator = nodeIterator;
        this._validator = validator;
        this._currentPosition = position;
        this._forward = forward;
    }

    public NodeIterator getNodeIterator() {
        return this._nodeIterator;
    }

    public IDOMPosition getCurrentPosition() {
        return this._currentPosition;
    }

    public void setCurrentPosition(IDOMPosition position) {
        this._currentPosition = position;
    }

    private IDOMPosition moveOut(Node container) {
        IDOMPosition result = new DOMRefPosition(container, this._forward);
        String name = container.getNodeName();
        if (name != null && EditModelQuery.HTML_STYLE_NODES.contains(name.toLowerCase())) {
            result = this.moveToNextPosition(result, this._validator);
        }
        return result;
    }

    public IDOMPosition moveIn(Node node) {
        IDOMPosition result = null;
        if (this._validator.isEditable(new Target(node))) {
            if (EditModelQuery.isText(node)) {
                int index = this._forward ? 0 : ((Text)node).getData().length();
                result = new DOMPosition(node, index);
                IDOMPosition pos = this.getNextTextPosition(result);
                if (pos != null) {
                    result = pos;
                }
            } else if (node.hasChildNodes()) {
                int index = this._forward ? 0 : node.getChildNodes().getLength();
                result = new DOMPosition(node, index);
            } else {
                result = new DOMPosition(node, 0);
            }
        } else if (node.hasChildNodes()) {
            Node child = this._forward ? node.getFirstChild() : node.getLastChild();
            result = new DOMRefPosition(child, this._forward);
            while (child != null) {
                if (this._validator.allowsMoveIn(new Target(child))) {
                    result = this.moveIn(child);
                    break;
                }
                Node node2 = child = this._forward ? child.getNextSibling() : child.getPreviousSibling();
            }
        } else {
            result = new DOMPosition(node, 0);
        }
        return result;
    }

    private IDOMPosition getNextTextPosition(IDOMPosition position) {
        DOMPosition result = null;
        String value = position.getContainerNode().getNodeValue();
        int i = position.getOffset();
        if (this._forward) {
            if (i < value.length()) {
                if (HTMLUtil.isHTMLWhitespace(value.charAt(i))) {
                    while (i < value.length() && HTMLUtil.isHTMLWhitespace(value.charAt(i))) {
                        ++i;
                    }
                    result = new DOMPosition(position.getContainerNode(), i);
                } else if (i < value.length()) {
                    result = new DOMPosition(position.getContainerNode(), i + 1);
                }
            }
        } else if (i > 0) {
            if (HTMLUtil.isHTMLWhitespace(value.charAt(i - 1))) {
                while (i > 0 && HTMLUtil.isHTMLWhitespace(value.charAt(i - 1))) {
                    --i;
                }
                result = new DOMPosition(position.getContainerNode(), i);
            } else if (i > 0) {
                result = new DOMPosition(position.getContainerNode(), i - 1);
            }
        }
        return result;
    }

    private IDOMPosition moveToNextPosition(IDOMPosition position, IMovementMediator validator) {
        IDOMPosition currentPosition = null;
        if (validator.isValidPosition(position) && position.isText()) {
            currentPosition = this.getNextTextPosition(position);
        }
        if (currentPosition == null) {
            Node nextNode = EditModelQuery.getInstance().getSibling(position, this._forward);
            while (EditModelQuery.isText(nextNode) && ((Text)nextNode).getData().length() == 0) {
                nextNode = EditModelQuery.getInstance().getSibling(nextNode, this._forward);
            }
            if (nextNode != null) {
                if (validator.allowsMoveIn(new Target(nextNode))) {
                    currentPosition = this.moveIn(nextNode);
                    if (!this.canStopHere(nextNode) && EditModelQuery.getInstance().getSibling(currentPosition, this._forward) != null) {
                        currentPosition = this.moveToNextPosition(currentPosition, validator);
                    }
                } else {
                    currentPosition = new DOMRefPosition(nextNode, this._forward);
                }
            } else if (validator.allowsMoveOut(new Target(this.getNaviContainer(position)))) {
                currentPosition = this.moveOut(this.getNaviContainer(position));
            }
        }
        if ((currentPosition = EditHelper.ensureDOMPosition(currentPosition)) != null && !validator.isValidPosition(currentPosition)) {
            currentPosition = this.moveToNextPosition(currentPosition, validator);
        }
        return currentPosition;
    }

    private boolean canStopHere(Node node) {
        boolean result = false;
        if (EditModelQuery.isText(node)) {
            result = true;
        } else if (node != null && node.getNodeName() != null) {
            result |= node.getNodeName().equals("td");
            result |= EditModelQuery.isBlockNode(node);
        }
        return result;
    }

    public IDOMPosition moveToNextEditPosition(IDOMPosition currentPosition, boolean forward, IMovementMediator validator) {
        IDOMPosition result = null;
        result = (currentPosition = this.moveToNextPosition(currentPosition, validator)) != null ? currentPosition : this._currentPosition;
        return result;
    }

    private Node getNaviContainer(IDOMPosition position) {
        if (position.isText()) {
            return position.getContainerNode().getParentNode();
        }
        return position.getContainerNode();
    }
}

