/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.layout;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.layout.CSSFigure;
import org.eclipse.jst.pagedesigner.css2.layout.CSSLayout;
import org.eclipse.jst.pagedesigner.css2.layout.FlowBox;
import org.eclipse.jst.pagedesigner.css2.layout.FlowFigure;
import org.eclipse.jst.pagedesigner.css2.layout.LineBox;
import org.eclipse.jst.pagedesigner.css2.style.ITagEditInfo;
import org.eclipse.swt.graphics.Font;

public class CSSInlineFlowLayout
extends CSSLayout {
    List _fragments = new ArrayList();

    public CSSInlineFlowLayout(CSSFigure flow) {
        super(flow);
    }

    @Override
    public void preLayout() {
        super.preLayout();
        this._fragments.clear();
    }

    @Override
    protected void layoutChildren() {
        super.layoutChildren();
    }

    @Override
    public void addToCurrentLine(FlowBox block) {
        this.getCurrentLine().add(block);
    }

    private void createFirstLine() {
        this._currentLine = new LineBox();
        this.setupLine(this._currentLine, true);
        this._fragments.add(this._currentLine);
    }

    @Override
    protected void createNewLine() {
        this._currentLine = new LineBox();
        this.setupLine(this._currentLine, false);
        this._fragments.add(this._currentLine);
    }

    @Override
    protected void createNewLine(int topMargin) {
        this.createNewLine();
    }

    @Override
    protected void cleanup() {
        this._currentLine = null;
    }

    @Override
    protected void flush() {
        if (this._fragments.isEmpty()) {
            this.createFirstLine();
        } else if (this._fragments.size() == 1) {
            ICSSStyle style = this.getCSSStyle();
            int minWidth = 0;
            int minHeight = 0;
            ITagEditInfo info = (ITagEditInfo)style.getAdapter(ITagEditInfo.class);
            if (info != null) {
                minWidth = info.getMinWidth();
                minHeight = info.getMinHeight();
            }
            FlowBox box = (FlowBox)this._fragments.get(0);
            if (minWidth > box._width) {
                box._width = minWidth;
            }
            if (minHeight > box._height) {
                box._height = minHeight;
            }
        }
        if (this._currentLine != null) {
            this._currentLine.getMarginInsets().right = this.getCSSStyle().getMarginInsets().right;
            this.getFlowContext().addToCurrentLine(this._currentLine);
        }
    }

    @Override
    public void endLine() {
        if (this._currentLine == null) {
            this.getFlowContext().endLine();
            return;
        }
        if (this._currentLine.isOccupied()) {
            this.getFlowContext().addToCurrentLine(this._currentLine);
        } else if (this._fragments.size() == 1) {
            this._fragments.remove(0);
        }
        this.getFlowContext().endLine();
        this._currentLine = null;
    }

    @Override
    public int getCurrentY() {
        return this.getCurrentLine()._y;
    }

    @Override
    public boolean isCurrentLineOccupied() {
        if (this._currentLine == null) {
            return this.getFlowContext().isCurrentLineOccupied();
        }
        if (this._currentLine.getFragments().isEmpty()) {
            return this.getFlowContext().isCurrentLineOccupied();
        }
        return true;
    }

    protected void setupLine(LineBox line, boolean firstline) {
        LineBox parent = this.getFlowContext().getCurrentLine();
        line._x = 0;
        line._y = this.getFlowContext().getCurrentY();
        line.setRecommendedWidth(parent.getAvailableWidth());
        this.setLineVerticalAlign(line);
        this.setFontinfoForLine(line);
        if (firstline && this.getCSSStyle() != null) {
            ICSSStyle style = this.getCSSStyle();
            int minWidth = 0;
            int minHeight = 0;
            ITagEditInfo info = (ITagEditInfo)style.getAdapter(ITagEditInfo.class);
            if (info != null) {
                minWidth = info.getMinWidth();
                minHeight = info.getMinHeight();
            }
            if (minWidth > 0) {
                line.setWidth(minWidth);
            }
            int fontHeight = this.getCSSStyle().getCSSFont().getXHeight();
            if (minHeight > 0 && minHeight > fontHeight) {
                line.setHeight(minHeight);
            } else {
                line.setHeight(fontHeight);
            }
        }
    }

    private void setLineVerticalAlign(LineBox box) {
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            box.setVerticalAlignData(style.getStyleProperty("vertical-align"));
        }
    }

    private void setFontinfoForLine(LineBox line) {
        ICSSStyle style = this.getCSSStyle();
        if (style != null) {
            line.setFontMetrics(FigureUtilities.getFontMetrics((Font)style.getCSSFont().getSwtFont()));
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public List getFragmentsForRead() {
        return this._fragments;
    }

    @Override
    public void postValidate() {
        int right;
        int left;
        List list = this._fragments;
        int top = left = Integer.MAX_VALUE;
        int bottom = right = Integer.MIN_VALUE;
        int i = 0;
        while (i < list.size()) {
            FlowBox box = (FlowBox)list.get(i);
            left = Math.min(left, box._x);
            right = Math.max(right, box._x + box._width);
            top = Math.min(top, box._y);
            bottom = Math.max(bottom, box._y + box._height);
            ++i;
        }
        this.getCSSFigure().setBounds(new Rectangle(left, top, right - left, bottom - top));
        list = this.getCSSFigure().getChildren();
        i = 0;
        while (i < list.size()) {
            ((FlowFigure)((Object)list.get(i))).postValidate();
            ++i;
        }
    }

    @Override
    public int getContainerWidth() {
        return this.getFlowContext().getContainerWidth();
    }
}

