/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.commands;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.CommandResources;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.dom.DOMPositionHelper;
import org.eclipse.jst.pagedesigner.dom.EditHelper;
import org.eclipse.jst.pagedesigner.dom.EditValidateUtil;
import org.eclipse.jst.pagedesigner.parts.SubNodeEditPart;
import org.eclipse.jst.pagedesigner.validation.caret.ActionData;
import org.eclipse.jst.pagedesigner.validation.caret.InlineEditingNavigationMediator;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.DesignRefPosition;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Node;

public class DeleteNodeCommand
extends DesignerCommand {
    private static final String COMMAND_LABEL = CommandResources.getString("DeleteNodeCommand.Label.DeleteNode");
    private DesignRange _prevRange;

    public DeleteNodeCommand(IHTMLGraphicalViewer viewer) {
        super(COMMAND_LABEL, viewer);
    }

    @Override
    protected void preExecute() {
        this._prevRange = this._viewer.getRangeSelection();
        DesignPosition position = this.findObjectModePosition();
        this._prevRange = new DesignRange(position, position);
        super.preExecute();
    }

    private DesignPosition findObjectModePosition() {
        DesignPosition result = null;
        InlineEditingNavigationMediator validator = new InlineEditingNavigationMediator(new ActionData(4, null));
        DesignPosition position = this.getCurrentObjectPosition();
        if (position != null) {
            result = !validator.isValidPosition(position) ? null : position;
        }
        return result;
    }

    private DesignPosition getCurrentObjectPosition() {
        DesignRange result = null;
        if (this._viewer.isInRangeMode()) {
            result = this._viewer.getRangeSelection();
        } else {
            EditPart selection;
            List parts = this._viewer.getSelectedEditParts();
            if (parts.size() > 0 && (selection = (EditPart)parts.get(0)) instanceof SubNodeEditPart) {
                DesignPosition position = new DesignRefPosition(selection, false);
                position = DOMPositionHelper.toDesignPosition(EditHelper.ensureDOMPosition(DOMPositionHelper.toDOMPosition(position)));
                result = new DesignRange(position, position);
            }
        }
        return result != null && result.isValid() ? result.getEndPosition() : null;
    }

    @Override
    protected void doExecute() {
        List parts = this.getViewer().getSelectedEditParts();
        int i = 0;
        int n = parts.size();
        while (i < n) {
            EditPart part = (EditPart)parts.get(i);
            Object model = part.getModel();
            if (model instanceof Node) {
                EditValidateUtil.validNode((Node)model);
                Node parent = ((Node)model).getParentNode();
                model = parent.removeChild((Node)model);
            }
            ++i;
        }
    }

    @Override
    protected ISelection getAfterCommandDesignerSelection() {
        if (this._prevRange.isValid()) {
            return this._prevRange;
        }
        return null;
    }
}

