/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.jpql.spi;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.NamedQuery;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaManagedType;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaManagedTypeProvider;
import org.eclipse.jpt.jpa.core.jpql.spi.JpaQuery;
import org.eclipse.persistence.jpa.jpql.tools.spi.IEntity;
import org.eclipse.persistence.jpa.jpql.tools.spi.IManagedTypeVisitor;
import org.eclipse.persistence.jpa.jpql.tools.spi.IMappingBuilder;
import org.eclipse.persistence.jpa.jpql.tools.spi.IQuery;

public class JpaEntity
extends JpaManagedType
implements IEntity {
    private Map<String, IQuery> queries;

    public JpaEntity(JpaManagedTypeProvider provider, Entity entity, IMappingBuilder<AttributeMapping> mappingBuilder) {
        super(provider, entity, mappingBuilder);
    }

    public void accept(IManagedTypeVisitor visitor) {
        visitor.visit((IEntity)this);
    }

    protected IQuery buildQuery(JpaManagedTypeProvider provider, NamedQuery namedQuery) {
        return new JpaQuery(provider, namedQuery);
    }

    @Override
    public Entity getManagedType() {
        return (Entity)super.getManagedType();
    }

    public String getName() {
        return this.getManagedType().getName();
    }

    public IQuery getNamedQuery(String queryName) {
        this.initializeQueries();
        return this.queries.get(queryName);
    }

    protected void initializeQueries() {
        if (this.queries == null) {
            this.queries = new HashMap<String, IQuery>();
            this.initializeQueries(this.queries);
        }
    }

    protected void initializeQueries(Map<String, IQuery> queries) {
        JpaManagedTypeProvider provider = this.getProvider();
        for (NamedQuery namedQuery : this.getNamedQueries()) {
            queries.put(namedQuery.getName(), this.buildQuery(provider, namedQuery));
        }
    }

    protected ListIterable<? extends NamedQuery> getNamedQueries() {
        return this.getManagedType().getQueryContainer().getNamedQueries();
    }

    public String toString() {
        return this.getName();
    }
}

