/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ThreadSafe;
import org.eclipse.cdt.dsf.debug.service.ICachingService;
import org.eclipse.cdt.dsf.debug.service.ISourceLookup;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.debug.sourcelookup.DsfSourceLookupParticipant;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.IGDBSourceLookup;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;

@ThreadSafe
public class GdbSourceLookupParticipant
extends DsfSourceLookupParticipant {
    private DsfExecutor fExecutor;
    private String fSessionId;
    private DsfServicesTracker fServicesTracker;

    public GdbSourceLookupParticipant(DsfSession session) {
        super(session);
        this.fSessionId = session.getId();
        this.fExecutor = session.getExecutor();
        this.fServicesTracker = new DsfServicesTracker(GdbPlugin.getBundleContext(), this.fSessionId);
    }

    public void init(ISourceLookupDirector director) {
        super.init(director);
    }

    public void dispose() {
        this.fServicesTracker.dispose();
        super.dispose();
    }

    public void sourceContainersChanged(final ISourceLookupDirector director) {
        super.sourceContainersChanged(director);
        if (this.fExecutor.isInExecutorThread()) {
            this.sourceContainersChangedOnDispatchThread(director, new RequestMonitor((Executor)this.fExecutor, null));
        } else {
            this.fExecutor.execute((Runnable)new DsfRunnable(){

                public void run() {
                    GdbSourceLookupParticipant.this.sourceContainersChangedOnDispatchThread(director, new RequestMonitor((Executor)GdbSourceLookupParticipant.this.fExecutor, null));
                }
            });
        }
    }

    @ConfinedToDsfExecutor(value="fExecutor")
    protected void sourceContainersChangedOnDispatchThread(ISourceLookupDirector director, RequestMonitor rm) {
        IGDBSourceLookup lookup = (IGDBSourceLookup)this.fServicesTracker.getService(IGDBSourceLookup.class);
        if (lookup != null) {
            IStack stackService = (IStack)this.fServicesTracker.getService(IStack.class);
            if (stackService instanceof ICachingService) {
                ICachingService cachingStackService = (ICachingService)stackService;
                cachingStackService.flushCache(null);
            }
            ICommandControlService command = (ICommandControlService)this.fServicesTracker.getService(ICommandControlService.class);
            ISourceLookup.ISourceLookupDMContext context = (ISourceLookup.ISourceLookupDMContext)command.getContext();
            lookup.sourceContainersChanged(context, (DataRequestMonitor<Boolean>)new DataRequestMonitor((Executor)this.fExecutor, rm));
        } else {
            rm.done();
        }
    }
}

