/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.npm;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.wildwebdeveloper.debug.npm.Messages;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class NpmLaunchDelegate
implements ILaunchConfigurationDelegate {
    public static final String ID = "org.eclipse.wildwebdeveloper.launchConfiguration.NPMLaunch";
    public static final String ARGUMENTS = "runtimeArgs";
    private MessageConsole console = new MessageConsole("NPM output", null);

    public NpmLaunchDelegate() {
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{this.console});
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File packageJSONDirectory = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "No package.json directory path set").trim()));
        File packageJSON = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute("program", "No package.json path set").trim()));
        String argumentString = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute(ARGUMENTS, "No NPM argument set").trim());
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(NodeJSManager.prepareNPMProcessBuilder((String[])new String[0]).command());
        arguments.addAll(Arrays.asList(argumentString.split(" ")));
        monitor.beginTask(argumentString + " " + packageJSON.getAbsolutePath(), 2);
        monitor.worked(1);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(packageJSONDirectory.getName());
        try {
            ProcessBuilder pb = new ProcessBuilder(arguments).directory(packageJSONDirectory);
            Map envp = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
            if (envp != null && !envp.isEmpty()) {
                Map<String, String> env = pb.environment();
                envp.entrySet().forEach(e -> {
                    String value = (String)e.getValue();
                    try {
                        value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
                    }
                    catch (CoreException ex) {
                        IStatus errorStatus = Status.error((String)ex.getMessage(), (Throwable)ex);
                        ILog.get().log(errorStatus);
                    }
                    env.put((String)e.getKey(), value);
                });
            }
            Process npmProcess = pb.start();
            DebugPlugin.newProcess((ILaunch)launch, (Process)npmProcess, (String)argumentString);
            CompletableFuture.runAsync(() -> {
                try {
                    npmProcess.waitFor();
                }
                catch (InterruptedException e) {
                    IStatus errorStatus = Status.error((String)e.getMessage(), (Throwable)e);
                    ILog.get().log(errorStatus);
                    Display.getDefault().asyncExec(() -> {
                        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.NpmLaunchDelegate_npmError, (String)e.getMessage(), (IStatus)errorStatus);
                    });
                }
            }).whenComplete((ok, ko) -> {
                if (project != null) {
                    try {
                        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        IStatus errorStatus = Status.error((String)e.getMessage(), (Throwable)e);
                        ILog.get().log(errorStatus);
                        Display.getDefault().asyncExec(() -> {
                            int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.NpmLaunchDelegate_npmError, (String)e.getMessage(), (IStatus)errorStatus);
                        });
                    }
                }
                monitor.done();
            });
        }
        catch (IOException e2) {
            IStatus errorStatus = Status.error((String)e2.getMessage(), (Throwable)e2);
            ILog.get().log(errorStatus);
            Display.getDefault().asyncExec(() -> {
                int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.NpmLaunchDelegate_npmError, (String)e2.getMessage(), (IStatus)errorStatus);
            });
        }
    }
}

