/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;
import org.eclipse.wildwebdeveloper.debug.node.NodeRunDebugLaunchShortcut;
import org.eclipse.wildwebdeveloper.util.FileUtils;

public class RunProgramTab
extends AbstractLaunchConfigurationTab {
    private Text programPathText;
    private Text argumentsText;
    private Text workingDirectoryText;
    private final NodeRunDebugLaunchShortcut shortcut = new NodeRunDebugLaunchShortcut();

    public void createControl(Composite parent) {
        Composite resComposite = new Composite(parent, 0);
        resComposite.setLayout((Layout)new GridLayout(2, false));
        Label programLabel = new Label(resComposite, 0);
        programLabel.setText(Messages.RunProgramTab_program);
        GridData programLabelGD = new GridData(1, 128, false, false);
        programLabel.setLayoutData((Object)programLabelGD);
        Composite programComposite = new Composite(resComposite, 0);
        programComposite.setLayout((Layout)new GridLayout(1, false));
        programComposite.setLayoutData((Object)new GridData(4, -1, true, false));
        GridLayout programGL = (GridLayout)programComposite.getLayout();
        programGL.marginHeight = 0;
        programGL.marginWidth = 0;
        this.programPathText = new Text(programComposite, 2048);
        this.programPathText.setLayoutData((Object)new GridData(4, -1, true, false));
        ControlDecoration decoration = new ControlDecoration((Control)this.programPathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        decoration.setImage(fieldDecoration.getImage());
        this.programPathText.addModifyListener(event -> {
            this.setDirty(true);
            try {
                File file = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.programPathText.getText()));
                if (!file.isFile()) {
                    String errorMessage = Messages.RunProgramTab_error_unknownFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else if (!this.shortcut.canLaunch(file)) {
                    String errorMessage = Messages.RunProgramTab_error_notJSFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else if (!file.canRead()) {
                    String errorMessage = Messages.RunProgramTab_error_nonReadableFile;
                    this.setErrorMessage(errorMessage);
                    decoration.setDescriptionText(errorMessage);
                    decoration.show();
                } else {
                    this.setErrorMessage(null);
                    decoration.hide();
                }
            }
            catch (CoreException ex) {
                this.setErrorMessage(ex.getMessage());
                decoration.setDescriptionText(ex.getMessage());
                decoration.show();
            }
            this.updateLaunchConfigurationDialog();
        });
        Composite programButtons = new Composite(programComposite, 0);
        GridLayout programButtonsGL = new GridLayout(3, false);
        programButtonsGL.marginHeight = 0;
        programButtonsGL.marginWidth = 0;
        programButtons.setLayout((Layout)programButtonsGL);
        GridData programButtonsGD = new GridData(0x1000008, 0x1000000, true, false);
        programButtons.setLayoutData((Object)programButtonsGD);
        Button programWorkspaceButton = new Button(programButtons, 8);
        programWorkspaceButton.setText(Messages.AbstractRunHTMLDebugTab_browse_workspace);
        programWorkspaceButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            IResource resource;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(resComposite.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(Messages.RunProgramTab_program);
            dialog.setMessage(Messages.RunProgramTab_program);
            dialog.setValidator(selection -> {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.wildwebdeveloper", "");
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    if (!(f instanceof IFile)) {
                        return new Status(4, "org.eclipse.wildwebdeveloper", "Must select a file");
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.wildwebdeveloper", "");
            });
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                String arg = resource.getFullPath().toString();
                String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                this.programPathText.setText(fileLoc);
            }
        }));
        Button programFilesystemButton = new Button(programButtons, 8);
        programFilesystemButton.setText(Messages.AbstractRunHTMLDebugTab_browse);
        programFilesystemButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog filePathDialog = new FileDialog(resComposite.getShell());
            filePathDialog.setFilterPath(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
            String path = filePathDialog.open();
            if (path != null) {
                this.programPathText.setText(path);
            }
        }));
        Button programVariablesButton = new Button(programButtons, 8);
        programVariablesButton.setText(Messages.AbstractRunHTMLDebugTab_variables);
        programVariablesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            String expr;
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(resComposite.getShell());
            if (dialog.open() == 0 && (expr = dialog.getVariableExpression()) != null) {
                this.programPathText.insert(expr);
            }
        }));
        new Label(resComposite, 0).setText(Messages.RunProgramTab_argument);
        this.argumentsText = new Text(resComposite, 2048);
        this.argumentsText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.argumentsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Label workingLabel = new Label(resComposite, 0);
        workingLabel.setText(Messages.RunProgramTab_workingDirectory);
        GridData workingLabelGD = new GridData(1, 128, false, false);
        workingLabel.setLayoutData((Object)workingLabelGD);
        Composite workingComposite = new Composite(resComposite, 0);
        workingComposite.setLayout((Layout)new GridLayout(1, false));
        workingComposite.setLayoutData((Object)new GridData(4, -1, true, false));
        GridLayout workingGL = (GridLayout)workingComposite.getLayout();
        workingGL.marginHeight = 0;
        workingGL.marginWidth = 0;
        this.workingDirectoryText = new Text(workingComposite, 2048);
        this.workingDirectoryText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.workingDirectoryText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Composite workingButtons = new Composite(workingComposite, 0);
        GridLayout workingButtonsGL = new GridLayout(3, false);
        workingButtonsGL.marginHeight = 0;
        workingButtonsGL.marginWidth = 0;
        workingButtons.setLayout((Layout)workingButtonsGL);
        GridData workingButtonsGD = new GridData(0x1000008, 0x1000000, true, false);
        workingButtons.setLayoutData((Object)workingButtonsGD);
        Button workingDirWorkspaceButton = new Button(workingButtons, 8);
        workingDirWorkspaceButton.setText(Messages.AbstractRunHTMLDebugTab_browse_workspace);
        workingDirWorkspaceButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            IResource resource;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(resComposite.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
            dialog.setTitle(Messages.RunProgramTab_workingDirectory);
            dialog.setMessage(Messages.RunProgramTab_workingDirectory);
            dialog.setValidator(selection -> {
                if (selection.length == 0) {
                    return new Status(4, "org.eclipse.wildwebdeveloper", "");
                }
                Object[] objectArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    Object f = objectArray[n2];
                    if (!(f instanceof IProject) && !(f instanceof IFolder)) {
                        return new Status(4, "org.eclipse.wildwebdeveloper", "Must select a project or a folder");
                    }
                    ++n2;
                }
                return new Status(0, "org.eclipse.wildwebdeveloper", "");
            });
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setComparator((ViewerComparator)new ResourceComparator(1));
            if (dialog.open() == 0 && (resource = (IResource)dialog.getFirstResult()) != null) {
                String arg = resource.getFullPath().toString();
                String fileLoc = VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", arg);
                this.workingDirectoryText.setText(fileLoc);
            }
        }));
        Button workingDirFilesystemButton = new Button(workingButtons, 8);
        workingDirFilesystemButton.setText(Messages.AbstractRunHTMLDebugTab_browse);
        workingDirFilesystemButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog workingDirectoryDialog = new DirectoryDialog(resComposite.getShell());
            workingDirectoryDialog.setFilterPath(this.workingDirectoryText.getText());
            String path = workingDirectoryDialog.open();
            if (path != null) {
                this.workingDirectoryText.setText(path);
            }
        }));
        Button workingDirVariablesButton = new Button(workingButtons, 8);
        workingDirVariablesButton.setText(Messages.AbstractRunHTMLDebugTab_variables);
        workingDirVariablesButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            String expr;
            StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(resComposite.getShell());
            if (dialog.open() == 0 && (expr = dialog.getVariableExpression()) != null) {
                this.workingDirectoryText.insert(expr);
            }
        }));
        this.setControl((Control)resComposite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String defaultSelectedFile = SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedFile(this.shortcut::canLaunch));
            this.programPathText.setText(configuration.getAttribute("program", defaultSelectedFile));
            this.argumentsText.setText(configuration.getAttribute("args", ""));
            this.workingDirectoryText.setText(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedProject())));
        }
        catch (CoreException e) {
            ILog.get().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String programPath = this.programPathText.getText();
        configuration.setAttribute("program", programPath);
        configuration.setAttribute("args", this.argumentsText.getText());
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", this.workingDirectoryText.getText());
        configuration.setMappedResources((IResource[])ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(FileUtils.toUri(programPath)));
    }

    public String getName() {
        return Messages.RunProgramTab_title;
    }
}

