/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.unittest.internal.ui.history;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.unittest.internal.UnitTestPlugin;
import org.eclipse.unittest.internal.model.ITestRunSessionListener;
import org.eclipse.unittest.internal.model.TestRunSession;
import org.eclipse.unittest.internal.ui.history.HistoryItem;
import org.eclipse.unittest.model.ITestRunSession;

public class History
implements ITestRunSessionListener {
    private static final String HISTORY_DIR_NAME = "history";
    public static final History INSTANCE = new History();
    private boolean wasRead = false;
    private final List<HistoryItem> items = new ArrayList<HistoryItem>();

    private History() {
    }

    public File getDirectory() throws IllegalStateException {
        File historyDir = UnitTestPlugin.getDefault().getStateLocation().append(HISTORY_DIR_NAME).toFile();
        if (!historyDir.isDirectory()) {
            historyDir.mkdir();
        }
        return historyDir;
    }

    public List<HistoryItem> getHistory() {
        if (!this.wasRead) {
            Arrays.stream(this.getDirectory().listFiles()).map(HistoryItem::new).forEach(this.items::add);
            this.wasRead = true;
        }
        return Collections.unmodifiableList(this.items);
    }

    public void clear() {
        for (HistoryItem item : this.items) {
            try {
                item.removeSwapFile();
            }
            catch (IOException e) {
                UnitTestPlugin.log(e);
            }
        }
        this.items.clear();
    }

    @Override
    public void sessionAdded(ITestRunSession testRunSession) {
        this.items.add(new HistoryItem((TestRunSession)testRunSession));
    }

    @Override
    public void sessionRemoved(ITestRunSession testRunSession) {
        this.items.stream().filter(item -> item.getCurrentTestRunSession().filter(testRunSession::equals).isPresent()).forEach(toRemove -> {
            try {
                toRemove.removeSwapFile();
            }
            catch (IOException e) {
                UnitTestPlugin.log(e);
            }
        });
    }

    public void watch(TestRunSession testRunSession) {
        for (HistoryItem item : this.items) {
            if (testRunSession != null) {
                if (!item.getCurrentTestRunSession().filter(testRunSession::equals).isEmpty()) continue;
            }
            try {
                item.swapOut();
            }
            catch (CoreException e) {
                UnitTestPlugin.log(e);
            }
        }
    }

    public void remove(HistoryItem selected) {
        this.items.remove(selected);
        try {
            selected.removeSwapFile();
        }
        catch (IOException e) {
            UnitTestPlugin.log(e);
        }
    }

    public void add(HistoryItem historyItem) {
        this.items.add(historyItem);
    }
}

