/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.edit.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.graphical.edit.part.specific.BracketEdgeEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDEdgeNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.locator.EdgeLabelQuery;

public class SetLabelsOffsetOperation {
    private Map<Node, Point> labelsWithNewOffset;
    private PointList oldBendPointsList;
    private PointList newPointList;

    public void setNewPointList(PointList newPointList) {
        this.newPointList = new PointList(newPointList.size());
        int i = 0;
        while (i < newPointList.size()) {
            this.newPointList.addPoint(newPointList.getPoint(i));
            ++i;
        }
    }

    public void setLabelsToUpdate(ConnectionEditPart connectionEditPart, PointList originalPoints) {
        this.oldBendPointsList = originalPoints;
        this.setLabelsToUpdate(connectionEditPart);
    }

    public void setLabelsToUpdate(ConnectionEditPart connectionEditPart) {
        ArrayList<AbstractDEdgeNameEditPart> labelEditPartsToUpdate = new ArrayList<AbstractDEdgeNameEditPart>();
        List children = connectionEditPart.getChildren();
        for (Object child : children) {
            Object view;
            if (!(child instanceof AbstractDEdgeNameEditPart) || !((view = ((AbstractDEdgeNameEditPart)child).getModel()) instanceof Node)) continue;
            labelEditPartsToUpdate.add((AbstractDEdgeNameEditPart)child);
        }
        this.computeGMFLabelsOffset(labelEditPartsToUpdate, connectionEditPart);
    }

    private void computeGMFLabelsOffset(List<AbstractDEdgeNameEditPart> labelEditPartsToUpdate, ConnectionEditPart connectionEditPart) {
        this.labelsWithNewOffset = new HashMap<Node, Point>();
        for (AbstractDEdgeNameEditPart labelEditPartToUpdate : labelEditPartsToUpdate) {
            this.computeGMFLabelOffset(labelEditPartToUpdate, connectionEditPart);
        }
    }

    private void computeGMFLabelOffset(AbstractDEdgeNameEditPart labelEditPartToUpdate, ConnectionEditPart connectionEditPart) {
        Point newLabelOffset = null;
        Node labelNodeToUpdate = (Node)labelEditPartToUpdate.getModel();
        if (connectionEditPart.getModel() instanceof Edge) {
            PointList oldBendpoints = this.oldBendPointsList;
            if (oldBendpoints == null) {
                oldBendpoints = connectionEditPart.getConnectionFigure().getPoints();
            }
            boolean isEdgeWithObliqueRoutingStyle = new ConnectionEditPartQuery((org.eclipse.gef.ConnectionEditPart)connectionEditPart).isEdgeWithObliqueRoutingStyle();
            LayoutConstraint layoutConstraint = labelNodeToUpdate.getLayoutConstraint();
            if (layoutConstraint instanceof Bounds) {
                Bounds bounds = (Bounds)layoutConstraint;
                newLabelOffset = new EdgeLabelQuery(oldBendpoints, this.newPointList, isEdgeWithObliqueRoutingStyle, new Point(bounds.getX(), bounds.getY()), labelEditPartToUpdate.getFigure().getSize(), labelEditPartToUpdate.getKeyPoint(), connectionEditPart instanceof BracketEdgeEditPart).calculateGMFLabelOffset();
            }
        }
        if (newLabelOffset != null) {
            this.labelsWithNewOffset.put(labelNodeToUpdate, newLabelOffset);
        }
    }

    public void updateGMFLabelsOffset() {
        if (this.labelsWithNewOffset != null) {
            Set<Map.Entry<Node, Point>> entries = this.labelsWithNewOffset.entrySet();
            for (Map.Entry<Node, Point> entry : entries) {
                LayoutConstraint layoutConstraint = entry.getKey().getLayoutConstraint();
                if (!(layoutConstraint instanceof Bounds)) continue;
                Bounds bounds = (Bounds)layoutConstraint;
                bounds.setX(entry.getValue().x);
                bounds.setY(entry.getValue().y);
            }
        }
    }
}

