/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.ElementImpl;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.resource.AS2ID;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.UniqueList;

public abstract class LUSSIDs {
    protected static final int COLLECTION_IS_NULL_FREE_MULTIPLIER = 59;
    protected static final int COLLECTION_LOWER_BOUND_MULTIPLIER = 61;
    protected static final int COLLECTION_UPPER_BOUND_MULTIPLIER = 67;
    protected static final int CONTAINER_MULTIPLIER = 1021;
    protected static final int CONTAINMENT_FEATURE_NAME_MULTIPLER = 5;
    protected static final int LAMBDA_TYPE_CONTEXT_MULTIPLIER = 71;
    protected static final int LAMBDA_TYPE_PARAMETER_TYPE_MULTIPLIER = 73;
    protected static final int LAMBDA_TYPE_RETURN_TYPE_MULTIPLIER = 79;
    protected static final int MAP_KEYS_ARE_NULL_FREE_MULTIPLIER = 101;
    protected static final int MAP_VALUES_ARE_NULL_FREE_MULTIPLIER = 103;
    protected static final int OPERATION_PARAMETER_TYPE_MULTIPLIER = 83;
    protected static final int OPPOSITE_PROPERTY_NAME_MULTIPLIER = 7;
    protected static final int SIBLING_INDEX_MULTIPLIER = 1;
    protected static final int TEMPLATE_BINDING_MULTIPLIER = 89;
    protected static final int TEMPLATE_PARAMETER_INDEX_MULTIPLIER = 97;
    static char[] base64digits = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', ','};
    protected final @NonNull ASResource asResource;
    private Map<@NonNull Element, @NonNull Integer> identifiedElement2lussid = new HashMap<Element, Integer>();
    private Map<@NonNull Element, @NonNull Integer> internalElement2lussid = new HashMap<Element, Integer>();
    private Map<@NonNull Element, @NonNull Integer> normalizedElement2lussid = new HashMap<Element, Integer>();
    private @Nullable Map<@NonNull String, @NonNull List<@NonNull Element>> xmiid2collisions = null;
    private final boolean diagnoseXMIIDcollisions;
    private Map<@NonNull Integer, @NonNull Element> debugLUSSID2element = new HashMap<Integer, Element>();
    private @Nullable Map<@NonNull Integer, @NonNull List<@NonNull Element>> debugLUSSID2collisions = null;
    private boolean assignmentStarted = false;
    static int debugDepth = 0;

    protected LUSSIDs(@NonNull ASResource asResource, @NonNull Map<@NonNull Object, @Nullable Object> options) {
        this.asResource = asResource;
        this.debugLUSSID2element = options.get("DEBUG_LUSSID_COLLISIONS") == Boolean.TRUE ? new HashMap() : null;
        this.diagnoseXMIIDcollisions = options.get("DEBUG_XMIID_COLLISIONS") == Boolean.TRUE;
    }

    protected void assignErrors() {
        StringBuilder s = null;
        Map<@NonNull String, @NonNull List<@NonNull Element>> xmiid2collisions2 = this.xmiid2collisions;
        if (xmiid2collisions2 != null && this.diagnoseXMIIDcollisions) {
            s = new StringBuilder();
            for (String xmiid : xmiid2collisions2.keySet()) {
                if (s != null) {
                    s.append("\n\tambiguous xmi:id " + xmiid);
                }
                List<@NonNull Element> collisions = xmiid2collisions2.get(xmiid);
                assert (collisions != null);
                for (Element element : collisions) {
                    if (s == null) continue;
                    s.append("\n\t\t" + element);
                }
            }
        }
        if (this.debugLUSSID2collisions != null) {
            Map<Integer, List<Element>> debugLUSSID2collisions2;
            if (s == null) {
                s = new StringBuilder();
            }
            if ((debugLUSSID2collisions2 = this.debugLUSSID2collisions) != null) {
                for (Integer lussid : debugLUSSID2collisions2.keySet()) {
                    s.append("\n\tcollision at " + lussid);
                    List<@NonNull Element> collisions = debugLUSSID2collisions2.get(lussid);
                    assert (collisions != null);
                    for (Element element : collisions) {
                        s.append("\n\t\t" + element);
                    }
                }
            }
        }
        if (s != null) {
            String message = StringUtil.bind(PivotMessagesInternal.UnstableXMIid_ERROR_, s.toString());
            this.asResource.getErrors().add((Object)new UnstableXMIIDDiagnostics(message));
        }
    }

    protected int assignLUSSID(@NonNull AS2ID as2id, @NonNull Element element, boolean isReferenced, boolean normalizeTemplateParameters) {
        assert (this.asResource == element.eResource());
        int savedDepth = debugDepth;
        assert (debugDepth < 30);
        try {
            Map<Integer, Element> debugLUSSID2element2;
            ++debugDepth;
            Integer idObject = null;
            if (normalizeTemplateParameters) {
                idObject = this.normalizedElement2lussid.get(element);
                if (idObject != null) {
                    int n = idObject;
                    return n;
                }
            } else {
                idObject = this.identifiedElement2lussid.get(element);
                if (idObject != null) {
                    int n = idObject;
                    return n;
                }
                idObject = this.internalElement2lussid.get(element);
                if (idObject != null) {
                    if (isReferenced) {
                        this.identifiedElement2lussid.put(element, idObject);
                    }
                    int n = idObject;
                    return n;
                }
            }
            EObject eContainer = element.eContainer();
            int id = 0;
            if (eContainer instanceof Element) {
                id = 1021 * this.assignLUSSID(as2id, (Element)eContainer, false, normalizeTemplateParameters);
                EReference eContainmentFeature = element.eContainmentFeature();
                id += 5 * eContainmentFeature.getName().hashCode();
                if (eContainmentFeature.isMany()) {
                    Integer localId = null;
                    if (eContainmentFeature.isUnique() || !eContainmentFeature.isOrdered()) {
                        localId = this.computeLocalLUSSID(as2id, element, normalizeTemplateParameters);
                    }
                    if (localId != null) {
                        id += localId.intValue();
                    } else {
                        List eSiblings = (List)eContainer.eGet((EStructuralFeature)eContainmentFeature);
                        id += 1 * eSiblings.indexOf(element);
                    }
                }
            }
            idObject = id;
            assert (idObject != null);
            if (normalizeTemplateParameters) {
                this.normalizedElement2lussid.put(element, idObject);
            } else if (isReferenced) {
                this.identifiedElement2lussid.put(element, idObject);
            } else {
                this.internalElement2lussid.put(element, idObject);
            }
            if (!normalizeTemplateParameters && (debugLUSSID2element2 = this.debugLUSSID2element) != null) {
                Element oldElement = debugLUSSID2element2.get(idObject);
                if (oldElement != null) {
                    List<Element> collisions;
                    Map<@NonNull Integer, @NonNull List<@NonNull Element>> debugLUSSID2collisions2 = this.debugLUSSID2collisions;
                    if (debugLUSSID2collisions2 == null) {
                        this.debugLUSSID2collisions = debugLUSSID2collisions2 = new HashMap<Integer, List<Element>>();
                    }
                    if ((collisions = debugLUSSID2collisions2.get(idObject)) == null) {
                        collisions = new ArrayList<Element>();
                        debugLUSSID2collisions2.put(idObject, collisions);
                        collisions.add(oldElement);
                    }
                    collisions.add(element);
                } else {
                    debugLUSSID2element2.put(idObject, element);
                }
            }
            int n = id;
            return n;
        }
        finally {
            debugDepth = savedDepth;
        }
    }

    protected void assignLUSSIDs(@NonNull AS2ID as2id) {
        this.assignmentStarted = true;
        UniqueList<@NonNull ASResource> referencedASResources = null;
        for (EObject eObject : new TreeIterable((Resource)this.asResource)) {
            EClass eClass = eObject.eClass();
            assert (eClass != null);
            boolean isExternallyReferenceable = this.isExternallyReferenceable(eObject);
            if (isExternallyReferenceable) {
                this.assignLUSSID(as2id, (ElementImpl)eObject, true, false);
            }
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject eObject2 = (EObject)featureIterator.next();
                EReference eReference = (EReference)featureIterator.feature();
                if (eReference.isContainer() || eReference.isTransient() || eReference.isVolatile()) continue;
                Resource eResource = eObject2.eResource();
                if (eResource == this.asResource) {
                    Object eTargetOrTargets = eObject.eGet((EStructuralFeature)eReference);
                    if (eReference.isMany()) {
                        for (Object eTarget : (List)eTargetOrTargets) {
                            if (!(eTarget instanceof Element)) continue;
                            as2id.assignLUSSID((Element)eTarget, true, false);
                        }
                        continue;
                    }
                    if (!(eTargetOrTargets instanceof Element)) continue;
                    as2id.assignLUSSID((Element)eTargetOrTargets, true, false);
                    continue;
                }
                if (!(eResource instanceof ASResource) || ((ASResource)eResource).isOrphanage()) continue;
                if (referencedASResources == null) {
                    referencedASResources = new UniqueList<ASResource>();
                }
                referencedASResources.add((ASResource)eResource);
            }
        }
        if (referencedASResources != null) {
            for (ASResource referencedASResource : referencedASResources) {
                as2id.assignLUSSIDs(referencedASResource);
            }
        }
    }

    protected void assignXMIIDs(@NonNull AS2ID as2id) {
        Map<@NonNull String, @NonNull List<@NonNull Element>> xmiid2collisions2 = this.xmiid2collisions;
        for (Element element : this.identifiedElement2lussid.keySet()) {
            Integer lussid = this.identifiedElement2lussid.get(element);
            assert (lussid != null);
            String newXMIID = this.computeXMIID(lussid);
            String oldXMIID = this.asResource.getID(element);
            EObject oldElement = this.asResource.basicGetEObjectByID(newXMIID);
            if (oldElement instanceof Element && (oldElement != element || !oldXMIID.equals(newXMIID))) {
                List<Element> collisions;
                if (xmiid2collisions2 == null) {
                    this.xmiid2collisions = xmiid2collisions2 = new HashMap<String, List<Element>>();
                }
                if ((collisions = xmiid2collisions2.get(newXMIID)) == null) {
                    collisions = new ArrayList<Element>();
                    xmiid2collisions2.put(newXMIID, collisions);
                    collisions.add((Element)oldElement);
                }
                collisions.add(element);
                continue;
            }
            this.asResource.setID(element, newXMIID);
        }
        if (xmiid2collisions2 != null) {
            for (String xmiid : xmiid2collisions2.keySet()) {
                List<@NonNull Element> collisions = xmiid2collisions2.get(xmiid);
                assert (collisions != null);
                XMIIDDisambiguationComparator comparator = new XMIIDDisambiguationComparator();
                Collections.sort(collisions, comparator);
                int suffix = 0;
                for (Element element : collisions) {
                    this.asResource.setID(element, this.computeDisambiguatedXMIID(xmiid, suffix));
                    ++suffix;
                }
            }
        }
    }

    protected @NonNull String computeDisambiguatedXMIID(@NonNull String xmiid, int suffix) {
        StringBuilder s = new StringBuilder(xmiid);
        if (suffix == 1) {
            s.append(base64digits[0]);
        } else if (suffix > 1) {
            --suffix;
            while (suffix > 0) {
                s.append(base64digits[suffix & 0x3F]);
                suffix >>= 6;
            }
        }
        return s.toString();
    }

    protected abstract @Nullable Integer computeLocalLUSSID(@NonNull AS2ID var1, @NonNull EObject var2, boolean var3);

    protected @NonNull String computeXMIID(int lussid) {
        StringBuilder s = new StringBuilder();
        int i = 0;
        int hash = lussid;
        while (i++ < 5) {
            s.append(base64digits[hash & 0x3F]);
            hash >>= 6;
        }
        return s.toString();
    }

    public void dispose() {
        if (this.identifiedElement2lussid != null) {
            this.identifiedElement2lussid.clear();
        }
        if (this.internalElement2lussid != null) {
            this.internalElement2lussid.clear();
        }
        if (this.debugLUSSID2element != null) {
            this.debugLUSSID2element.clear();
        }
        if (this.debugLUSSID2collisions != null) {
            this.debugLUSSID2collisions.clear();
        }
        this.identifiedElement2lussid = null;
        this.internalElement2lussid = null;
        this.debugLUSSID2element = null;
        this.debugLUSSID2collisions = null;
        this.asResource.resetLUSSIDs();
    }

    public boolean isAssignmentStarted() {
        return this.assignmentStarted;
    }

    protected abstract boolean isExternallyReferenceable(@NonNull EObject var1);

    public @NonNull String toString() {
        return String.valueOf(this.asResource.getURI());
    }

    public static final class UnstableXMIIDDiagnostics
    implements Resource.Diagnostic {
        protected final @NonNull String message;

        public UnstableXMIIDDiagnostics(@NonNull String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String getLocation() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public int getColumn() {
            return 0;
        }

        public String toString() {
            return this.message;
        }
    }

    protected class XMIIDDisambiguationComparator
    implements Comparator<Element> {
        protected XMIIDDisambiguationComparator() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int compare(@NonNull Element o1, @NonNull Element o2) {
            if (o1 == o2) {
                return 0;
            }
            e1 = LUSSIDs.this.isExternallyReferenceable(o1);
            if (e1 != (e2 = LUSSIDs.this.isExternallyReferenceable(o2))) {
                return e1 != false ? -1 : 1;
            }
            d1 = this.computeDepth(o1);
            d2 = this.computeDepth(o2);
            child1 = null;
            child2 = null;
            parent1 = o1;
            parent2 = o2;
            while (d1 > d2) {
                if (!XMIIDDisambiguationComparator.$assertionsDisabled && parent1 == null) {
                    throw new AssertionError();
                }
                child1 = parent1;
                parent1 = parent1.eContainer();
                --d1;
            }
            while (d1 < d2) {
                child2 = parent2;
                parent2 = parent2.eContainer();
                --d2;
            }
            if (XMIIDDisambiguationComparator.$assertionsDisabled || d1 == d2) ** GOTO lbl32
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                child1 = parent1;
                parent1 = parent1.eContainer();
                --d1;
                child2 = parent2;
                parent2 = parent2.eContainer();
                --d2;
lbl32:
                // 2 sources

                ** while (parent1 != parent2)
            }
lbl33:
            // 1 sources

            if (child1 == null) {
                if (!XMIIDDisambiguationComparator.$assertionsDisabled && child2 == null) {
                    throw new AssertionError();
                }
                return -1;
            }
            if (child2 == null) {
                return 1;
            }
            f1 = child1.eContainmentFeature();
            if (f1 == (f2 = child2.eContainmentFeature())) {
                if (f1 == null) {
                    return 0;
                }
                s = (List)parent1.eGet((EStructuralFeature)f1);
                i1 = s.indexOf(child1);
                i2 = s.indexOf(child2);
                return i1 - i2;
            }
            return f1.getName().compareTo(f2.getName());
        }

        private int computeDepth(@NonNull EObject eObject) {
            int d = 0;
            EObject eContainer = eObject;
            while ((eContainer = eObject.eContainer()) != null) {
                ++d;
                eObject = eContainer;
            }
            return d;
        }
    }
}

