/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.versions.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.versions.core.Change;
import org.eclipse.mylyn.versions.core.ScmRepository;
import org.eclipse.mylyn.versions.core.ScmUser;
import org.eclipse.mylyn.versions.core.spi.ScmInfoAttributes;

public class ChangeSet
implements ScmInfoAttributes {
    private final List<Change> changes;
    private final Map<String, String> fAtrributes = new HashMap<String, String>();
    private final ScmUser author;
    private final Date date;
    private final String id;
    private String kind;
    private final String message;
    private ScmRepository repository;

    public ChangeSet(ScmUser author, Date date, String id, String fullMessage, ScmRepository repository, List<Change> changes) {
        this.author = author;
        this.date = date;
        this.id = id;
        this.message = fullMessage;
        this.repository = repository;
        this.changes = new ArrayList<Change>(changes);
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public String getKind() {
        return this.kind;
    }

    public ScmRepository getRepository() {
        return this.repository;
    }

    public ScmUser getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date != null ? new Date(this.date.getTime()) : null;
    }

    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    @Deprecated
    public void setKind(String kind) {
        this.kind = kind;
    }

    @Deprecated
    public void setRepository(ScmRepository repository) {
        this.repository = repository;
    }

    @Override
    public Map<String, String> getInfoAtrributes() {
        return this.fAtrributes;
    }
}

