/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.editors.palette.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IImageDescriptorProvider;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataSourceModelProvider;
import org.eclipse.jst.jsf.common.metadata.internal.TraitValueHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryFactory;
import org.eclipse.jst.jsf.common.metadata.query.internal.taglib.ITaglibDomainMetaDataQuery;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.Namespace;
import org.eclipse.jst.jsf.common.ui.JSFUICommonPlugin;
import org.eclipse.jst.jsf.core.internal.tld.CMUtil;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfo;
import org.eclipse.jst.jsf.tagdisplay.internal.paletteinfos.PaletteInfos;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentFactoryTLD;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDElementDeclaration;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.palette.IPaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolCreationAdapter;
import org.eclipse.jst.pagedesigner.editors.palette.TagToolPaletteEntry;
import org.eclipse.jst.pagedesigner.editors.palette.impl.PaletteItemManager;
import org.eclipse.jst.pagedesigner.editors.palette.impl.TaglibPaletteDrawer;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;

public class PaletteHelper {
    private static final Pattern removeHTMLTags = Pattern.compile("<[/?\\w\\s=\"\\.\\#]+>");
    private static final Pattern trimInteriorWhitespace = Pattern.compile("[ ]+");
    private static final Pattern removeNewLines = Pattern.compile("[\n]");
    private static final ImageDescriptor DEFAULT_SMALL_ICON = JSFUICommonPlugin.getDefault().getImageDescriptor("PD_Palette_Default.gif");
    private static final ImageDescriptor DEFAULT_LARGE_ICON = PDPlugin.getDefault().getImageDescriptor("palette/GENERIC/large/PD_Palette_Default.gif");
    private static final int DESCRIPTION_TRUNCATE_HARD_LENGTH = 250;

    PaletteHelper(PaletteItemManager manager) {
    }

    public TaglibPaletteDrawer configPaletteItemsByTLD(IPaletteItemManager manager, ITaglibRecord tldRec) {
        String tldURI = CMUtil.getURIFromTaglibRecord((ITaglibRecord)tldRec, (IProject)manager.getTagRegistryIdentifier().getProject());
        CMDocumentFactoryTLD factory = new CMDocumentFactoryTLD();
        TLDDocument doc = (TLDDocument)factory.createCMDocument(tldRec);
        return this.getOrCreateTaglibPaletteDrawer(manager, (CMDocument)doc, tldURI);
    }

    public TaglibPaletteDrawer getOrCreateTaglibPaletteDrawer(IPaletteItemManager manager, CMDocument doc, String tldURI) {
        TaglibPaletteDrawer category = this.findCategory(manager, tldURI);
        if (category != null) {
            return category;
        }
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(manager.getTagRegistryIdentifier().getProject());
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = query.findTagLibraryModel(tldURI);
        category = this.createTaglibPaletteDrawer(manager, doc, model, query);
        if (category != null) {
            this.loadTags(category, doc, model, query);
            this.sortTags(category.getChildren());
        }
        return category;
    }

    private void sortTags(List tags) {
        Collections.sort(tags, new Comparator(){

            public int compare(Object o1, Object o2) {
                String label1 = ((PaletteEntry)o1).getLabel();
                String label2 = ((PaletteEntry)o2).getLabel();
                if (label1 == null) {
                    if (label2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (label2 == null) {
                    return -1;
                }
                return label1.compareTo(label2);
            }
        });
    }

    private void loadTags(TaglibPaletteDrawer category, CMDocument doc, Model model, ITaglibDomainMetaDataQuery query) {
        if (model != null) {
            Trait trait = query.findTrait((Entity)model, "paletteInfos");
            if (trait != null) {
                PaletteInfos tags = (PaletteInfos)trait.getValue();
                for (PaletteInfo tag : tags.getInfos()) {
                    this.createTagEntry(category, tag, doc);
                }
            } else {
                for (Entity tagAsEntity : model.getChildEntities()) {
                    this.createTagEntry(category, tagAsEntity, doc, query);
                }
            }
        } else {
            this.loadFromCMDocument(category, doc);
        }
    }

    private TaglibPaletteDrawer createTaglibPaletteDrawer(IPaletteItemManager manager, CMDocument doc, Model model, ITaglibDomainMetaDataQuery query) {
        TaglibPaletteDrawer category = null;
        if (model != null) {
            boolean isHidden = this.getBooleanTagTraitValue(query, (Entity)model, "hidden", false);
            if (isHidden) {
                return null;
            }
            String label = this.getStringTagTraitValue(query, (Entity)model, "display-label", model.getId());
            label = label.equals("") ? model.getId() : label;
            category = manager.createTaglibPaletteDrawer(model.getId(), label);
            String desc = this.getStringTagTraitValue(query, (Entity)model, "description", model.getId());
            category.setDescription(this.formatDescription(desc));
            ImageDescriptor largeIconImage = this.getImageDescriptorFromTagTraitValueAsString(query, (Entity)model, "small-icon", null);
            if (largeIconImage != null) {
                category.setLargeIcon(largeIconImage);
            }
            String prefix = this.getStringTagTraitValue(query, (Entity)model, "default-prefix", null);
            category.setDefaultPrefix(prefix);
            boolean isVisible = !this.getBooleanTagTraitValue(query, (Entity)model, "expert", false);
            category.setVisible(isVisible);
            category.setInitialState(1);
        }
        return category;
    }

    private TaglibPaletteDrawer findCategory(IPaletteItemManager manager, String tldURI) {
        TaglibPaletteDrawer lib2 = null;
        for (TaglibPaletteDrawer lib2 : manager.getAllCategories()) {
            if (!tldURI.equals(lib2.getURI())) continue;
            return lib2;
        }
        return null;
    }

    private void loadFromCMDocument(TaglibPaletteDrawer category, CMDocument cmdoc) {
        CMNamedNodeMap nodeMap = cmdoc.getElements();
        int i = 0;
        int size = nodeMap.getLength();
        while (i < size) {
            TagToolPaletteEntry item;
            CMElementDeclaration eledecl = (CMElementDeclaration)nodeMap.item(i);
            String tagName = eledecl.getElementName();
            if (tagName.equalsIgnoreCase("input")) {
                StringBuffer name = new StringBuffer(category.getURI());
                name.append(":").append(tagName).append(":").append(tagName);
                item = category.getTagPaletteEntryById(name.toString());
            } else {
                item = category.getTagPaletteEntryByTagName(tagName);
            }
            if (item == null) {
                this.createTagEntry(category, eledecl);
            }
            ++i;
        }
    }

    private void createTagEntry(TaglibPaletteDrawer category, PaletteInfo info, CMDocument doc) {
        Boolean hidden = info.getHidden();
        if (hidden != null && hidden.booleanValue()) {
            return;
        }
        IMetaDataSourceModelProvider sourceProvider = ((Trait)info.eContainer().eContainer()).getSourceModelProvider();
        String tagName = info.getTag();
        String id = info.getId();
        String label = info.getDisplayLabel();
        String desc = this.formatDescription(info.getDescription());
        ImageDescriptor smallIcon = this.getImageDescriptorFromString(sourceProvider, info.getSmallIcon(), DEFAULT_SMALL_ICON);
        ImageDescriptor largeIcon = this.getImageDescriptorFromString(sourceProvider, info.getLargeIcon(), DEFAULT_LARGE_ICON);
        Boolean expert = info.getExpert();
        this.internalCreateTagEntry(doc, category, id, tagName, label, desc, smallIcon, largeIcon, expert != null && expert != false);
    }

    private void createTagEntry(TaglibPaletteDrawer category, PaletteInfo info, Namespace ns) {
        Boolean hidden = info.getHidden();
        if (hidden != null && hidden.booleanValue()) {
            return;
        }
        IMetaDataSourceModelProvider sourceProvider = ((Trait)info.eContainer().eContainer()).getSourceModelProvider();
        String tagName = info.getTag();
        String id = info.getId();
        String label = info.getDisplayLabel();
        String desc = this.formatDescription(info.getDescription());
        ImageDescriptor smallIcon = this.getImageDescriptorFromString(sourceProvider, info.getSmallIcon(), DEFAULT_SMALL_ICON);
        ImageDescriptor largeIcon = this.getImageDescriptorFromString(sourceProvider, info.getLargeIcon(), DEFAULT_LARGE_ICON);
        Boolean expert = info.getExpert();
        this.internalCreateTagEntry(ns, category, id, tagName, label, desc, smallIcon, largeIcon, expert != null && expert != false);
    }

    private void createTagEntry(TaglibPaletteDrawer category, Entity entity, CMDocument doc, ITaglibDomainMetaDataQuery query) {
        boolean hidden = this.getBooleanTagTraitValue(query, entity, "hidden", false);
        if (hidden) {
            return;
        }
        String tagName = entity.getId();
        String label = this.getStringTagTraitValue(query, entity, "display-label", tagName);
        String desc = this.formatDescription(this.getStringTagTraitValue(query, entity, "description", tagName));
        ImageDescriptor smallIcon = this.getImageDescriptorFromTagTraitValueAsString(query, entity, "small-icon", DEFAULT_SMALL_ICON);
        ImageDescriptor largeIcon = this.getImageDescriptorFromTagTraitValueAsString(query, entity, "large-icon", DEFAULT_LARGE_ICON);
        boolean expert = this.getBooleanTagTraitValue(query, entity, "expert", false);
        this.internalCreateTagEntry(doc, category, tagName, tagName, label, desc, smallIcon, largeIcon, expert);
    }

    private void createTagEntry(TaglibPaletteDrawer category, Entity entity, Namespace ns, ITaglibDomainMetaDataQuery query) {
        boolean hidden = this.getBooleanTagTraitValue(query, entity, "hidden", false);
        if (hidden) {
            return;
        }
        String tagName = entity.getId();
        String label = this.getStringTagTraitValue(query, entity, "display-label", tagName);
        String desc = this.formatDescription(this.getStringTagTraitValue(query, entity, "description", tagName));
        ImageDescriptor smallIcon = this.getImageDescriptorFromTagTraitValueAsString(query, entity, "small-icon", DEFAULT_SMALL_ICON);
        ImageDescriptor largeIcon = this.getImageDescriptorFromTagTraitValueAsString(query, entity, "large-icon", DEFAULT_LARGE_ICON);
        boolean expert = this.getBooleanTagTraitValue(query, entity, "expert", false);
        this.internalCreateTagEntry(ns, category, tagName, tagName, label, desc, smallIcon, largeIcon, expert);
    }

    private TagToolPaletteEntry internalCreateTagEntry(TaglibPaletteDrawer category, String id, String tagName, String label, String desc, ImageDescriptor smallIcon, ImageDescriptor largeIcon, boolean expert) {
        TagToolCreationAdapter data = new TagToolCreationAdapter(category.getURI(), tagName, category.getDefaultPrefix(), id);
        TagToolPaletteEntry item = new TagToolPaletteEntry(data, label, desc, smallIcon, largeIcon);
        item.setId(id);
        item.setVisible(!expert);
        category.add((PaletteEntry)item);
        item.setParent((PaletteContainer)category);
        return item;
    }

    private TagToolPaletteEntry internalCreateTagEntry(CMDocument doc, TaglibPaletteDrawer category, String id, String tagName, String label, String desc, ImageDescriptor smallIcon, ImageDescriptor largeIcon, boolean expert) {
        if (this.verifyPresentInContentModel(doc, tagName)) {
            return this.internalCreateTagEntry(category, id, tagName, label, desc, smallIcon, largeIcon, expert);
        }
        return null;
    }

    private TagToolPaletteEntry internalCreateTagEntry(Namespace ns, TaglibPaletteDrawer category, String id, String tagName, String label, String desc, ImageDescriptor smallIcon, ImageDescriptor largeIcon, boolean expert) {
        if (this.verifyPresentInContentModel(ns, tagName)) {
            return this.internalCreateTagEntry(category, id, tagName, label, desc, smallIcon, largeIcon, expert);
        }
        return null;
    }

    private boolean verifyPresentInContentModel(CMDocument doc, String tagName) {
        return doc.getElements().getNamedItem(tagName) != null;
    }

    private boolean verifyPresentInContentModel(Namespace ns, String tagName) {
        return ns.getViewElement(tagName) != null;
    }

    private boolean getBooleanTagTraitValue(ITaglibDomainMetaDataQuery query, Entity entity, String key, boolean defaultValue) {
        Trait trait = query.findTrait(entity, key);
        if (trait != null) {
            return TraitValueHelper.getValueAsBoolean((Trait)trait);
        }
        return defaultValue;
    }

    private String getStringTagTraitValue(ITaglibDomainMetaDataQuery query, Entity entity, String key, String defaultValue) {
        String val;
        Trait trait = query.findTrait(entity, key);
        if (trait != null && (val = TraitValueHelper.getValueAsString((Trait)trait)) != null) {
            return val;
        }
        return defaultValue;
    }

    private ImageDescriptor getImageDescriptorFromTagTraitValueAsString(ITaglibDomainMetaDataQuery query, Entity entity, String key, ImageDescriptor defaultValue) {
        Trait t = query.findTrait(entity, key);
        if (t != null) {
            String imgDesc = TraitValueHelper.getValueAsString((Trait)t);
            return this.getImageDescriptorFromString(t.getSourceModelProvider(), imgDesc, defaultValue);
        }
        return defaultValue;
    }

    private ImageDescriptor getImageDescriptorFromString(IMetaDataSourceModelProvider sourceModelProvider, String imgDesc, ImageDescriptor defaultValue) {
        IImageDescriptorProvider imageProvider;
        ImageDescriptor image = defaultValue;
        if (imgDesc != null && (imageProvider = (IImageDescriptorProvider)sourceModelProvider.getAdapter(IImageDescriptorProvider.class)) != null) {
            image = imageProvider.getImageDescriptor(imgDesc);
        }
        return image;
    }

    private void createTagEntry(TaglibPaletteDrawer category, CMElementDeclaration eledecl) {
        String tagName = eledecl.getElementName();
        String label = null;
        String desc = null;
        if (eledecl instanceof TLDElementDeclaration) {
            TLDElementDeclaration tag = (TLDElementDeclaration)eledecl;
            label = tag.getDisplayName();
            desc = tag.getDescription();
        }
        if (label == null || label.equals("")) {
            label = tagName;
        }
        desc = desc == null ? "" : this.formatDescription(desc);
        TagToolPaletteEntry item = this.internalCreateTagEntry(category, tagName, tagName, label, desc, this.getDefaultSmallIcon(), this.getDefaultLargeIcon(), false);
        item.setToolProperty("CMElementDeclaration", eledecl);
    }

    private ImageDescriptor getDefaultLargeIcon() {
        return DEFAULT_LARGE_ICON;
    }

    private ImageDescriptor getDefaultSmallIcon() {
        return DEFAULT_SMALL_ICON;
    }

    private String formatDescription(String desc) {
        String aDesc = this.filterConvertString(desc);
        if (aDesc != null) {
            if (aDesc.length() > 250) {
                StringBuffer result = new StringBuffer(aDesc.substring(0, 250));
                result.append("...");
                return result.toString();
            }
            return aDesc;
        }
        return "";
    }

    private String filterConvertString(String text) {
        if (text == null) {
            return "";
        }
        String result = removeHTMLTags.matcher(text).replaceAll("");
        result = removeNewLines.matcher(result).replaceAll(" ");
        result = trimInteriorWhitespace.matcher(result).replaceAll(" ");
        return result;
    }

    public TaglibPaletteDrawer configPaletteItemsByNamespace(PaletteItemManager manager, Namespace ns) {
        return this.getOrCreateTaglibPaletteDrawer(manager, ns);
    }

    public TaglibPaletteDrawer getOrCreateTaglibPaletteDrawer(IPaletteItemManager manager, Namespace ns) {
        TaglibPaletteDrawer category = this.findCategory(manager, ns.getNSUri());
        if (category != null) {
            return category;
        }
        IProject project = manager.getTagRegistryIdentifier().getProject();
        IMetaDataDomainContext context = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(project);
        ITaglibDomainMetaDataQuery query = (ITaglibDomainMetaDataQuery)MetaDataQueryFactory.getInstance().createQuery(context);
        Model model = query.findTagLibraryModel(ns.getNSUri());
        category = this.createTaglibPaletteDrawer(manager, ns, model, query);
        if (category != null) {
            this.loadTags(category, ns, model, query);
            this.sortTags(category.getChildren());
        }
        return category;
    }

    private TaglibPaletteDrawer createTaglibPaletteDrawer(IPaletteItemManager manager, Namespace ns, Model model, ITaglibDomainMetaDataQuery query) {
        TaglibPaletteDrawer category = null;
        if (model != null) {
            boolean isHidden = this.getBooleanTagTraitValue(query, (Entity)model, "hidden", false);
            if (isHidden) {
                return null;
            }
            String label = this.getStringTagTraitValue(query, (Entity)model, "display-label", model.getId());
            label = label.equals("") ? model.getId() : label;
            category = manager.createTaglibPaletteDrawer(model.getId(), label);
            String desc = this.getStringTagTraitValue(query, (Entity)model, "description", model.getId());
            category.setDescription(this.formatDescription(desc));
            ImageDescriptor largeIconImage = this.getImageDescriptorFromTagTraitValueAsString(query, (Entity)model, "small-icon", null);
            if (largeIconImage != null) {
                category.setLargeIcon(largeIconImage);
            }
            String prefix = this.getStringTagTraitValue(query, (Entity)model, "default-prefix", null);
            category.setDefaultPrefix(prefix);
            boolean isVisible = !this.getBooleanTagTraitValue(query, (Entity)model, "expert", false);
            category.setVisible(isVisible);
            category.setInitialState(1);
        }
        return category;
    }

    private void loadTags(TaglibPaletteDrawer category, Namespace ns, Model model, ITaglibDomainMetaDataQuery query) {
        if (model != null) {
            Trait trait = query.findTrait((Entity)model, "paletteInfos");
            if (trait != null) {
                PaletteInfos tags = (PaletteInfos)trait.getValue();
                for (PaletteInfo tag : tags.getInfos()) {
                    this.createTagEntry(category, tag, ns);
                }
            } else {
                for (Entity tagAsEntity : model.getChildEntities()) {
                    this.createTagEntry(category, tagAsEntity, ns, query);
                }
            }
        } else {
            this.loadFromNamespace(category, ns);
        }
    }

    private void loadFromNamespace(TaglibPaletteDrawer category, Namespace ns) {
        for (Object velem : ns.getViewElements()) {
            ITagElement tag = (ITagElement)velem;
            TagToolPaletteEntry item = category.getTagPaletteEntryByTagName(tag.getName());
            if (item != null) continue;
            this.createTagEntry(category, tag);
        }
    }

    private void createTagEntry(TaglibPaletteDrawer category, ITagElement tag) {
        String tagName;
        String label = tagName = tag.getName();
        String desc = "";
        this.internalCreateTagEntry(category, tagName, tagName, label, desc, this.getDefaultSmallIcon(), this.getDefaultLargeIcon(), false);
    }
}

