/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.utils.HTMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TableUtil {
    static final String TOP = "top";
    static final String BOTTOM = "bottom";
    static final String LEFT = "left";
    static final String RIGHT = "right";

    public static boolean matchFrame(String edge, String frame) {
        if ("above".equalsIgnoreCase(frame)) {
            return TOP.equalsIgnoreCase(edge);
        }
        if ("below".equalsIgnoreCase(frame)) {
            return BOTTOM.equalsIgnoreCase(edge);
        }
        if ("hsides".equalsIgnoreCase(frame)) {
            return TOP.equalsIgnoreCase(edge) || BOTTOM.equalsIgnoreCase(edge);
        }
        if ("vsides".equalsIgnoreCase(frame)) {
            return LEFT.equalsIgnoreCase(edge) || RIGHT.equalsIgnoreCase(edge);
        }
        if ("lhs".equalsIgnoreCase(frame)) {
            return LEFT.equalsIgnoreCase(edge);
        }
        if ("rhs".equalsIgnoreCase(frame)) {
            return RIGHT.equalsIgnoreCase(edge);
        }
        return "box".equalsIgnoreCase(frame) || "border".equalsIgnoreCase(frame);
    }

    public static boolean matchRules(String edge, String rules) {
        if ("rows".equalsIgnoreCase(rules)) {
            return TOP.equalsIgnoreCase(edge) || BOTTOM.equalsIgnoreCase(edge);
        }
        if ("cols".equalsIgnoreCase(rules)) {
            return LEFT.equalsIgnoreCase(edge) || RIGHT.equalsIgnoreCase(edge);
        }
        return "all".equalsIgnoreCase(rules);
    }

    public static boolean isEmptyCell(Element element) {
        String text;
        Node child;
        NodeList children = element.getChildNodes();
        if (children.getLength() == 0) {
            return true;
        }
        return children.getLength() == 1 && (child = children.item(0)) instanceof Text && HTMLUtil.isHTMLWhitespaceString(text = child.getNodeValue());
    }
}

