/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.commands.DesignerCommand;
import org.eclipse.jst.pagedesigner.jsf.core.dom.JSFDOMUtil;
import org.eclipse.jst.pagedesigner.jsf.ui.commands.jsfhtml.CommandResources;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DataTableDeleteColumnCommand
extends DesignerCommand {
    private Element _dataTable;
    private int _index;

    public DataTableDeleteColumnCommand(IHTMLGraphicalViewer viewer, Element dataTable, int columnIndex) {
        super(CommandResources.getString("DataTableDeleteColumnCommand.Label.DeleteColumn"), viewer);
        this._dataTable = dataTable;
        this._index = columnIndex;
    }

    public boolean canExecute() {
        if (this._index < 0) {
            return false;
        }
        return super.canExecute();
    }

    protected void doExecute() {
        NodeList children = this._dataTable.getChildNodes();
        int index = 0;
        int i = 0;
        int size = children.getLength();
        while (i < size) {
            Node node = children.item(i);
            if (JSFDOMUtil.isHColumn(node) && index++ == this._index) {
                this._dataTable.removeChild(node);
                return;
            }
            ++i;
        }
    }

    protected ISelection getAfterCommandDesignerSelection() {
        return this.toDesignSelection(this._dataTable);
    }
}

