/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.ui.internal.utils;

import java.io.File;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.jsf.common.ui.internal.utils.WebrootUtil;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class PathUtil {
    private static final String FORWARD_SLASH = "/";
    private static final String RELATIVE_PATH_SIGNAL = "../";

    public static String adjustPath(String path) {
        int i = 0;
        while ((i = ((String)path).indexOf(RELATIVE_PATH_SIGNAL)) > 0) {
            String part1 = ((String)path).substring(0, i - 1);
            String part2 = ((String)path).substring(i + RELATIVE_PATH_SIGNAL.length() - 1);
            int j = part1.lastIndexOf(FORWARD_SLASH);
            if (j == -1) {
                return "";
            }
            part1 = part1.substring(0, j);
            path = part1 + part2;
        }
        return path;
    }

    public static String appendTrailingURLSlash(String input) {
        if (!((String)input).endsWith(FORWARD_SLASH)) {
            input = (String)input + FORWARD_SLASH;
        }
        return input;
    }

    public static String convertToRelativePath(String input, String base) {
        StringTokenizer inputTokenizer = new StringTokenizer(input, FORWARD_SLASH);
        StringTokenizer baseTokenizer = new StringTokenizer(base, FORWARD_SLASH);
        String token1 = "";
        String token2 = "";
        while (inputTokenizer.hasMoreTokens() && baseTokenizer.hasMoreTokens() && (token1 = baseTokenizer.nextToken()).equals(token2 = inputTokenizer.nextToken())) {
        }
        Object output = "";
        while (baseTokenizer.hasMoreTokens()) {
            baseTokenizer.nextToken();
            output = (String)output + RELATIVE_PATH_SIGNAL;
        }
        output = (String)output + token2;
        while (inputTokenizer.hasMoreTokens()) {
            output = (String)output + FORWARD_SLASH + inputTokenizer.nextToken();
        }
        return output;
    }

    public static String convertToWebPath(String projectName, String path) {
        Object name = "";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        String webrootName = WebrootUtil.getWebContentContainer(project).getName();
        name = path.indexOf(webrootName) != -1 ? projectName + FORWARD_SLASH + webrootName : projectName;
        int index = path.indexOf(projectName);
        return path.substring(index + ((String)name).length());
    }

    public static String convertToAbsolutePath(String uri, IFile curFile) {
        IPath path;
        IContainer con;
        if (uri == null || uri.trim().equals("")) {
            return uri;
        }
        String webroot = "";
        IFile jsp = curFile;
        try {
            if (jsp == null) {
                jsp = ((IFileEditorInput)PathUtil.getActivePage().getActiveEditor().getEditorInput()).getFile();
            }
            if (jsp != null) {
                String webrootName = WebrootUtil.getWebContentContainer(jsp.getProject()).getName();
                webroot = jsp.getProject().getFolder(webrootName).getLocation().toString();
            }
        }
        catch (NullPointerException nullPointerException) {
            return uri;
        }
        if (uri.startsWith(FORWARD_SLASH)) {
            return webroot + uri;
        }
        if (jsp != null && (con = jsp.getParent()) != null && (path = con.getLocation()) != null) {
            File file;
            Object aPath = path.toString() + File.separator + uri;
            aPath = ((String)aPath).replace('/', File.separatorChar);
            if (((String)(aPath = ((String)aPath).replace('\\', File.separatorChar))).endsWith(File.separator)) {
                aPath = (String)aPath + FORWARD_SLASH;
            }
            if ((file = new File((String)aPath)).exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            return uri;
        }
        return uri;
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    private static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PathUtil.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getActivePage();
    }

    /*
     * Unable to fully structure code
     */
    public static IPath getPathOnClasspath(IJavaProject javaProject, Object parent) {
        result = null;
        if (javaProject == null || parent == null) {
            return new Path("");
        }
        entries = javaProject.readRawClasspath();
        classPath = null;
        if (parent instanceof IResource) {
            if (javaProject != null && !javaProject.isOnClasspath((IResource)parent)) {
                return new Path("");
            }
            if (parent instanceof IFile) {
                elementPath = ((IFile)parent).getFullPath();
                if (((IFile)parent).getFileExtension().equalsIgnoreCase("properties")) {
                    block14: {
                        machings = 0;
                        try {
                            i = 0;
                            while (i < entries.length) {
                                n = entries[i].getPath().matchingFirstSegments(elementPath);
                                if (n > machings) {
                                    machings = n;
                                    classPath = elementPath.removeFirstSegments(machings).removeLastSegments(1);
                                }
                                ++i;
                            }
                            if (classPath != null) break block14;
                            return null;
                        }
                        catch (Exception v0) {
                            return null;
                        }
                    }
                    if (classPath.segmentCount() > 0) {
                        element = javaProject.findElement(classPath);
                        if (element == null || (path = element.getPath()) == null) ** GOTO lbl41
                        path1 = path.removeFirstSegments(machings);
                        fileName = ((IFile)parent).getName();
                        if (fileName == null) ** GOTO lbl41
                        result = path1.append(fileName);
                    }
                    result = ((IFile)parent).getFullPath().removeFirstSegments(machings);
                }
            }
        } else if (parent instanceof IJarEntryResource && (elementPath = ((IJarEntryResource)parent).getFullPath()).getFileExtension().equalsIgnoreCase("properties")) {
            result = elementPath;
        }
lbl41:
        // 8 sources

        if (result != null) {
            return result;
        }
        return new Path("");
    }

    private PathUtil() {
    }
}

