/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.transport.httpclient;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.HttpResponseException;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientService;
import org.eclipse.epp.internal.mpc.core.transport.httpclient.HttpClientTransport;

public abstract class RequestTemplate<T> {
    public String getUserAgent() {
        return HttpClientTransport.USER_AGENT;
    }

    public T execute(HttpClientService client, URI uri) throws ClientProtocolException, IOException {
        ClassicHttpRequest request = this.createRequest(uri);
        request = this.configureRequest(client, request);
        try (ClassicHttpResponse response = client.execute(request);){
            T t = this.handleResponse(response);
            return t;
        }
    }

    protected abstract ClassicHttpRequest createRequest(URI var1);

    protected ClassicHttpRequest configureRequest(HttpClientService client, ClassicHttpRequest request) {
        request.setHeader("User-Agent", (Object)this.getUserAgent());
        return client.configureRequest(request);
    }

    protected T handleResponse(ClassicHttpResponse response) throws ClientProtocolException, IOException {
        HttpEntity entity = null;
        try {
            entity = response.getEntity();
            this.handleResponseStatus(response.getCode(), response.getReasonPhrase());
            T t = this.handleResponseEntity(entity);
            return t;
        }
        finally {
            RequestTemplate.closeResponse(response, entity);
        }
    }

    protected T handleResponseEntity(HttpEntity entity) throws IOException {
        if (entity == null) {
            return this.handleEmptyResponse();
        }
        Charset charset = null;
        ContentType contentType = ContentType.parse((CharSequence)entity.getContentType());
        if (contentType != null) {
            charset = contentType.getCharset();
        }
        return this.handleResponseStream(entity.getContent(), charset);
    }

    protected abstract T handleResponseStream(InputStream var1, Charset var2) throws IOException;

    protected T handleEmptyResponse() {
        return null;
    }

    protected void handleResponseStatus(int statusCode, String reasonPhrase) throws IllegalStateException, IOException {
        if (statusCode >= 300) {
            if (statusCode == 404) {
                throw new FileNotFoundException(reasonPhrase);
            }
            throw new HttpResponseException(statusCode, reasonPhrase);
        }
    }

    private static void closeResponse(ClassicHttpResponse response, HttpEntity entity) throws IOException {
        if (entity != null) {
            EntityUtils.consumeQuietly((HttpEntity)entity);
        }
        response.close();
    }
}

