/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.databinding.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.IEMFListProperty;
import org.eclipse.emf.databinding.internal.EMFListProperty;
import org.eclipse.emf.databinding.internal.EMFPropertyListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EMFListValueProperty
extends SimpleValueProperty {
    private final EStructuralFeature eStructuralFeature;
    private final IEMFListProperty.ListElementAccess elementAccess;
    private final IListProperty delegate;

    public EMFListValueProperty(IListProperty delegate, EStructuralFeature eStructuralFeature, IEMFListProperty.ListElementAccess<?> elementAccess) {
        this.delegate = delegate;
        this.eStructuralFeature = eStructuralFeature;
        this.elementAccess = elementAccess;
    }

    public Object getValueType() {
        return this.eStructuralFeature;
    }

    protected Object doGetValue(Object source) {
        List<?> list = this.listFromDelegate(source);
        int idx = this.elementAccess.getReadValueIndex(list);
        if (idx != -1) {
            return list.get(idx);
        }
        return null;
    }

    private List<?> listFromDelegate(Object source) {
        List<?> list = Collections.EMPTY_LIST;
        if (source != null) {
            if (this.delegate instanceof EMFListProperty) {
                list = ((EMFListProperty)this.delegate).doGetList(source);
            } else {
                IObservableList observable = this.delegate.observe(source);
                try {
                    list = new ArrayList((Collection<?>)observable);
                }
                finally {
                    observable.dispose();
                }
            }
        }
        return list;
    }

    protected void doSetValue(Object source, Object value) {
        IObservableList list = this.delegate.observe(source);
        try {
            IEMFListProperty.ListElementAccess.WriteData data = this.elementAccess.getWriteValueData(list);
            if (data != null) {
                this.doSetListValue((EObject)source, (List<Object>)list, data, value);
            }
        }
        finally {
            list.dispose();
        }
    }

    protected void doSetListValue(EObject source, List<Object> targetList, IEMFListProperty.ListElementAccess.WriteData data, Object value) {
        if (data.insert) {
            if (data.index == -1) {
                targetList.add(value);
            } else {
                targetList.add(data.index, value);
            }
        } else {
            targetList.set(data.index, value);
        }
    }

    public INativePropertyListener adaptListener(final ISimplePropertyListener listener) {
        return new EMFPropertyListener(){

            @Override
            public void notifyChanged(Notification msg) {
                if (msg.getFeature() == this.getFeature() && !msg.isTouch()) {
                    Object newValue = EMFListValueProperty.this.doGetValue(msg.getNotifier());
                    this.getListener().handleEvent(new SimplePropertyEvent(SimplePropertyEvent.CHANGE, msg.getNotifier(), this.getOwner(), (IDiff)Diffs.createValueDiff(null, (Object)newValue)));
                }
            }

            @Override
            protected IProperty getOwner() {
                return EMFListValueProperty.this;
            }

            @Override
            protected ISimplePropertyListener getListener() {
                return listener;
            }

            @Override
            protected EStructuralFeature getFeature() {
                return EMFListValueProperty.this.eStructuralFeature;
            }
        };
    }
}

