/*******************************************************************************
 * Copyright (c) 2009, 2017 xored software, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     xored software, Inc. - initial API and Implementation (Alex Panchenko)
 *******************************************************************************/
package org.eclipse.dltk.ui.text.templates;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.templates.IScriptTemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;

public class SourceModuleTemplateContext extends FileTemplateContext implements
		IScriptTemplateContext {

	/**
	 * @param contextType
	 * @param lineDelimiter
	 */
	public SourceModuleTemplateContext(TemplateContextType contextType,
			String lineDelimiter) {
		super(contextType, lineDelimiter);
	}

	private ISourceModule module;

	public void setSourceModuleVariables(ISourceModule module) {
		this.module = module;
		final IResource resource = module.getResource();
		if (resource instanceof IFile) {
			setResourceVariables((IFile) resource);
		}
	}

	@Override
	public ISourceModule getSourceModule() {
		return module;
	}

}
