/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.help;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class HelpUtil {
    public static String HELP_KEY = "org.eclipse.ui.help";
    public static String CONTEXT_PROVIDER_KEY = "org.eclipse.datatools.help.context.provider";
    private static HelpListener _helpListener = null;
    private static boolean _debug = Platform.inDebugMode();
    private static HashMap _properties = new HashMap();

    private HelpUtil() {
    }

    private static Point computePopUpLocation(Display display) {
        Point point = display.getCursorLocation();
        return new Point(point.x + 15, point.y);
    }

    private static HelpListener getHelpListener() {
        if (_helpListener == null) {
            _helpListener = new HelpUtilHelpListener();
        }
        return _helpListener;
    }

    public static void setHelp(Control control, String contextId) {
        if (contextId == null) {
            return;
        }
        if (control != null) {
            control.removeHelpListener(HelpUtil.getHelpListener());
            control.addHelpListener(HelpUtil.getHelpListener());
        }
        control.setData(HELP_KEY, (Object)contextId);
    }

    public static String getHelpKey(Object target) {
        if (target instanceof Control) {
            Control control = (Control)target;
            while (control != null) {
                Object contextId = control.getData(HELP_KEY);
                if (contextId != null && contextId instanceof String) {
                    HelpUtil.debugMessage("--getHelpKey returns " + (String)contextId);
                    return (String)contextId;
                }
                control = control.getParent();
            }
        }
        return null;
    }

    public static String getContextId(String helpKey, String helpPluginID) {
        return HelpUtil.getHelpString(helpKey, helpPluginID, "contextIds");
    }

    public static String getSearchExpression(String helpKey, String helpPluginID) {
        return HelpUtil.getHelpString(helpKey, helpPluginID, "searchExpressions");
    }

    private static String getHelpString(String helpKey, String helpPluginID, String bundleType) {
        if (helpKey == null) {
            return null;
        }
        Properties[] properties = (Properties[])_properties.get(String.valueOf(helpPluginID) + ';' + bundleType);
        try {
            int i;
            if (properties == null) {
                URLConnection[] propertiesFiles = HelpUtil.getPropertiesFiles(helpPluginID, bundleType);
                properties = new Properties[propertiesFiles.length];
                i = 0;
                while (i < propertiesFiles.length) {
                    URLConnection connection = propertiesFiles[i];
                    InputStream is = connection.getInputStream();
                    properties[i] = new Properties();
                    properties[i].load(is);
                    ++i;
                }
                _properties.put(String.valueOf(helpPluginID) + ';' + bundleType, properties);
            }
            String bundleString = null;
            i = 0;
            while (bundleString == null && i < properties.length) {
                bundleString = properties[i].getProperty(helpKey);
                ++i;
            }
            if (bundleString != null && bundleString.length() > 0 && bundleString.indexOf(".") == -1) {
                bundleString = String.valueOf(helpPluginID) + "." + bundleString;
            }
            if (bundleString != null && bundleString.trim().length() == 0) {
                bundleString = null;
            }
            HelpUtil.debugMessage("--getHelpString (helpkey = " + helpKey + ", helpPluginId = " + helpPluginID + " returned " + bundleString);
            return bundleString;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static URLConnection[] getPropertiesFiles(String pluginIDToMatch, String bundleType) {
        IExtensionPoint exp = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.datatools.help", "helpKeyProperties");
        IExtension[] exts = exp.getExtensions();
        ArrayList<URLConnection> propertiesFiles = new ArrayList<URLConnection>();
        int index = 0;
        int count = exts.length;
        while (index < count) {
            for (IConfigurationElement elem : Arrays.asList(exts[index].getConfigurationElements())) {
                String pluginID;
                if (!elem.getName().equals(bundleType) || !(pluginID = elem.getAttribute("plugin")).equals(pluginIDToMatch)) continue;
                String propertiesFile = elem.getAttribute("file");
                try {
                    HelpUtil.debugMessage("---Getting Property Files---");
                    String helpPluginID = exts[index].getNamespaceIdentifier();
                    HelpUtil.debugMessage("helpPluginID = " + helpPluginID);
                    Bundle helpPluginBundle = Platform.getBundle((String)helpPluginID);
                    HelpUtil.debugMessage("helpPluginBundle = " + helpPluginBundle.getLocation());
                    if (helpPluginBundle == null) continue;
                    URL propertiesFileURL = helpPluginBundle.getResource(propertiesFile);
                    HelpUtil.debugMessage("propertiesFileURL = " + propertiesFileURL);
                    if (propertiesFileURL == null) {
                        HelpUtil.debugMessage("didn't find resource = " + propertiesFile);
                        continue;
                    }
                    HelpUtil.debugMessage("found resource: " + propertiesFile);
                    try {
                        propertiesFileURL = FileLocator.resolve((URL)propertiesFileURL);
                        URLConnection connection = propertiesFileURL.openConnection();
                        propertiesFiles.add(connection);
                    }
                    catch (NullPointerException npe) {
                        HelpUtil.debugMessage("Failed to get property file: " + propertiesFile);
                        npe.printStackTrace();
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            ++index;
        }
        return propertiesFiles.toArray(new URLConnection[propertiesFiles.size()]);
    }

    private static void debugMessage(String message) {
        if (_debug) {
            System.out.println("HelpUtil <Debug>: " + message);
        }
    }

    private static class HelpUtilHelpListener
    implements HelpListener {
        private HelpUtilHelpListener() {
        }

        public void helpRequested(HelpEvent event) {
            if (event.widget != null && !event.widget.isDisposed()) {
                Widget widget = event.widget;
                IContextProvider provider = null;
                while (widget != null && provider == null) {
                    if (widget instanceof IAdaptable) {
                        provider = (IContextProvider)((IAdaptable)widget).getAdapter(IContextProvider.class);
                    } else if (widget instanceof IContextProvider) {
                        provider = (IContextProvider)widget;
                    } else if (widget.getData(CONTEXT_PROVIDER_KEY) != null && widget.getData(CONTEXT_PROVIDER_KEY) instanceof IContextProvider) {
                        provider = (IContextProvider)widget.getData(CONTEXT_PROVIDER_KEY);
                    }
                    if (!(widget instanceof Control)) break;
                    widget = ((Control)widget).getParent();
                }
                if (provider == null || (provider.getContextChangeMask() & 1) != 0) {
                    String id = HelpUtil.getHelpKey(event.widget);
                    HelpUtil.debugMessage("Requested help for id = " + id);
                    IContext context = null;
                    if (id != null) {
                        context = HelpSystem.getContext((String)id);
                        HelpUtil.debugMessage("Retrieved context (" + context + ") for id = " + id);
                    }
                    if (context != null) {
                        Point point = HelpUtil.computePopUpLocation(event.widget.getDisplay());
                        PlatformUI.getWorkbench().getHelpSystem().displayContext(context, point.x, point.y);
                    }
                }
            }
        }
    }
}

