/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.ui.util.AbstractResourceActionHandler;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.RebuildConfigurationsDialog;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;

public class RebuildConfigurationsHandler
extends AbstractResourceActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        List<IProject> projects = RebuildConfigurationsHandler.getSelectedCdtProjects(RebuildConfigurationsHandler.getSelection((ExecutionEvent)event));
        if (!projects.isEmpty()) {
            RebuildConfigurationsDialog dialog = new RebuildConfigurationsDialog(projects.toArray(new IProject[projects.size()]));
            dialog.open();
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        super.setEnabled(evaluationContext);
        this.setBaseEnabled(!RebuildConfigurationsHandler.getSelectedCdtProjects(this.getSelection()).isEmpty());
    }

    public static List<IProject> getSelectedCdtProjects(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IProject> projects = new ArrayList<IProject>();
        Object[] objectArray = selection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            IProject project = null;
            if (element instanceof IProject) {
                project = (IProject)element;
            } else if (element instanceof ICProject) {
                project = ((ICProject)element).getProject();
            }
            if (project != null && CoreModel.getDefault().isNewStyleProject(project)) {
                projects.add(project);
            }
            ++n2;
        }
        return projects;
    }
}

