/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.core.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.php.composer.api.collection.Psr;
import org.eclipse.php.composer.api.json.ParseException;
import org.eclipse.php.composer.core.ComposerPlugin;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.core.model.InstalledPackage;
import org.eclipse.php.composer.core.model.PackageManager;
import org.osgi.service.prefs.BackingStoreException;

public class ModelAccess {
    private PackageManager packageManager = null;
    private static ModelAccess instance = null;
    private Map<String, Psr> psr0Map = new HashMap<String, Psr>();

    private ModelAccess() {
        try {
            this.initNamespaceMap();
        }
        catch (Exception e) {
            ComposerPlugin.logException(e);
        }
    }

    protected void initNamespaceMap() throws ParseException {
        IEclipsePreferences instancePreferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.php.composer.core");
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            String prefKey = "namespacemap#" + project.getName();
            String json = instancePreferences.get(prefKey, "{}");
            this.psr0Map.put(project.getName(), new Psr(json));
            Logger.debug("loading namespacemap from preferences for project " + project.getName() + " " + json);
            ++n2;
        }
    }

    public static ModelAccess getInstance() {
        if (instance == null) {
            instance = new ModelAccess();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageManager getPackageManager() {
        if (ModelAccess.getInstance().packageManager == null) {
            PackageManager manager = new PackageManager();
            ModelAccess modelAccess = instance;
            synchronized (modelAccess) {
                if (ModelAccess.instance.packageManager == null) {
                    ModelAccess.instance.packageManager = manager;
                }
            }
        }
        return ModelAccess.instance.packageManager;
    }

    public void updatePsr0(Psr psr0, IScriptProject scriptProject) {
        String json = psr0.toJson().replace("\\", "\\\\");
        IEclipsePreferences instancePreferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.php.composer.core");
        this.psr0Map.put(scriptProject.getProject().getName(), psr0);
        instancePreferences.put("namespacemap#" + scriptProject.getProject().getName(), json);
        Logger.debug("updating namespacemap for project " + scriptProject.getProject().getName());
        try {
            instancePreferences.flush();
        }
        catch (BackingStoreException e) {
            Logger.logException(e);
        }
    }

    public Psr getNamespaceMappings(IProject project) {
        if (this.psr0Map.containsKey(project.getName())) {
            return this.psr0Map.get(project.getName());
        }
        return null;
    }

    public IResource getComposer(InstalledPackage installed, IScriptProject project) {
        return null;
    }
}

