/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.examples.tutorial.features;

import org.eclipse.emf.ecore.EReference;
import org.eclipse.graphiti.examples.tutorial.StyleUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;

public class TutorialAddEReferenceFeature
extends AbstractAddFeature {
    public TutorialAddEReferenceFeature(IFeatureProvider fp) {
        super(fp);
    }

    public PictogramElement add(IAddContext context) {
        IAddConnectionContext addConContext = (IAddConnectionContext)context;
        EReference addedEReference = (EReference)context.getNewObject();
        IPeCreateService peCreateService = Graphiti.getPeCreateService();
        FreeFormConnection connection = peCreateService.createFreeFormConnection(this.getDiagram());
        connection.setStart(addConContext.getSourceAnchor());
        connection.setEnd(addConContext.getTargetAnchor());
        IGaService gaService = Graphiti.getGaService();
        Polyline polyline = gaService.createPlainPolyline((GraphicsAlgorithmContainer)connection);
        polyline.setStyle(StyleUtil.getStyleForEClass(this.getDiagram()));
        this.link((PictogramElement)connection, addedEReference);
        ConnectionDecorator textDecorator = peCreateService.createConnectionDecorator((Connection)connection, true, 0.5, true);
        Text text = gaService.createPlainText((GraphicsAlgorithmContainer)textDecorator);
        text.setStyle(StyleUtil.getStyleForTextDecorator(this.getDiagram()));
        gaService.setLocation((GraphicsAlgorithm)text, 10, 0);
        EReference eReference = (EReference)context.getNewObject();
        text.setValue(eReference.getName());
        ConnectionDecorator cd = peCreateService.createConnectionDecorator((Connection)connection, false, 1.0, true);
        this.createArrow((GraphicsAlgorithmContainer)cd);
        return connection;
    }

    public boolean canAdd(IAddContext context) {
        return context instanceof IAddConnectionContext && context.getNewObject() instanceof EReference;
    }

    private Polyline createArrow(GraphicsAlgorithmContainer gaContainer) {
        int[] nArray = new int[6];
        nArray[0] = -15;
        nArray[1] = 10;
        nArray[4] = -15;
        nArray[5] = -10;
        Polyline polyline = Graphiti.getGaCreateService().createPlainPolyline(gaContainer, nArray);
        polyline.setStyle(StyleUtil.getStyleForEClass(this.getDiagram()));
        return polyline;
    }
}

