/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;

public class ServerIdentifier {
    private DatabaseVendorDefinitionId _dbIdentifier;
    private String _host;
    private String _port;
    private String _url;
    private String _protocol;

    public ServerIdentifier(String host, String port, String url, DatabaseVendorDefinitionId dbIdentifier) {
        Assert.isTrue((url != null && url.matches(".*:.*") ? 1 : 0) != 0);
        ArrayList result = this.parseUrl(url);
        this._host = host != null ? host.toLowerCase() : null;
        this._port = port;
        if (result != null) {
            if (host == null || port == null) {
                this._host = (String)result.get(1);
                this._port = (String)result.get(2);
            }
            this._protocol = (String)result.get(0);
        } else {
            this._protocol = "";
        }
        this._host = this._host == null ? "" : this._host;
        this._port = this._port == null ? "" : this._port;
        this._url = url;
        this._dbIdentifier = dbIdentifier;
    }

    public String getHost() {
        return this._host;
    }

    public String getPort() {
        return this._port;
    }

    public String getUrl() {
        return this._url;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerIdentifier) {
            ServerIdentifier si = (ServerIdentifier)obj;
            String host1 = this._host;
            String host2 = si._host;
            String port1 = this._port;
            String port2 = si._port;
            String protocol1 = this._protocol;
            String protocol2 = si._protocol;
            try {
                InetAddress addr1 = InetAddress.getByName(host1);
                InetAddress addr2 = InetAddress.getByName(host2);
                if (addr1.isLoopbackAddress()) {
                    addr1 = InetAddress.getLocalHost();
                }
                if (addr2.isLoopbackAddress()) {
                    addr2 = InetAddress.getLocalHost();
                }
                host1 = addr1.getHostAddress();
                host2 = addr2.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {}
            return protocol1.equals(protocol2) && host1.equals(host2) && port1.trim().equals(port2.trim());
        }
        return false;
    }

    public int hashCode() {
        try {
            InetAddress addr1 = InetAddress.getByName(this._host);
            if (addr1.isLoopbackAddress()) {
                addr1 = InetAddress.getLocalHost();
            }
            String host1 = addr1.getHostAddress();
            return host1.hashCode();
        }
        catch (UnknownHostException unknownHostException) {
            return this._host.hashCode();
        }
    }

    public DatabaseVendorDefinitionId getDatabaseVendorDefinitionId() {
        return this._dbIdentifier;
    }

    public ArrayList parseUrl(String url1) {
        Assert.isTrue((url1 != null && url1.matches(".*:.*") ? 1 : 0) != 0);
        try {
            ArrayList<String> result = new ArrayList<String>();
            if (url1.indexOf("?") > 0) {
                url1 = url1.substring(0, url1.indexOf("?"));
            }
            int end = url1.length();
            if (url1.indexOf(47) > 0) {
                end = url1.lastIndexOf(47);
            }
            String port1 = "";
            try {
                int lastColon = url1.lastIndexOf(58) + 1;
                if (lastColon < end) {
                    port1 = url1.substring(lastColon, end);
                }
                Integer.parseInt(port1);
                url1 = url1.substring(0, url1.lastIndexOf(58));
            }
            catch (NumberFormatException numberFormatException) {
                port1 = "";
            }
            String host1 = url1.substring(url1.lastIndexOf(58) + 1);
            if (host1.startsWith("//")) {
                host1 = host1.substring(2);
            }
            String protocol1 = url1.substring(0, url1.lastIndexOf(58));
            result.add(protocol1);
            result.add(host1);
            result.add(port1);
            return result;
        }
        catch (Exception e) {
            EditorCorePlugin.getDefault().log(e);
            return null;
        }
    }
}

