/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.php.internal.server.core.Logger;
import org.eclipse.php.internal.server.core.Server;

public class ServerHelper {
    protected Map<String, String> map;
    private transient ListenerList<PropertyChangeListener> propertyListeners = new ListenerList();
    private Server server;

    public ServerHelper(Server server) {
        this.map = new HashMap<String, String>();
        this.server = server;
    }

    public void setAttribute(String attributeName, String value) {
        String current = this.getAttribute(attributeName, null);
        if (current != null && current.equals(value)) {
            return;
        }
        if (value == null) {
            this.map.remove(attributeName);
        } else {
            this.map.put(attributeName, value);
        }
        this.firePropertyChangeEvent(attributeName, current, value);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.add((Object)listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyListeners.remove((Object)listener);
    }

    public void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this.server, propertyName, oldValue, newValue);
        Object[] objectArray = this.propertyListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            try {
                PropertyChangeListener propertyListener = (PropertyChangeListener)listener;
                propertyListener.propertyChange(event);
            }
            catch (Exception e) {
                Logger.logException("Error firing property change event", e);
            }
            ++n2;
        }
    }

    public String getAttribute(String attributeName, String defaultValue) {
        try {
            String obj = this.map.get(attributeName);
            if (obj == null) {
                return defaultValue;
            }
            return obj;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public void removeAttribute(String attributeName) {
        this.map.remove(attributeName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.server == null ? 0 : this.server.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerHelper other = (ServerHelper)obj;
        return !(this.server == null ? other.server != null : !this.server.equals(other.server));
    }
}

