/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.composition.ui.strategies;

import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.modisco.java.ASTNode;
import org.eclipse.modisco.java.CompilationUnit;
import org.eclipse.modisco.java.composition.javaapplication.queries.GetASTNodeSourceRegion;
import org.eclipse.modisco.java.composition.ui.Activator;
import org.eclipse.modisco.java.emf.JavaPackage;
import org.eclipse.modisco.kdm.source.extension.ASTNodeSourceRegion;
import org.eclipse.modisco.kdm.source.extension.impl.ASTNodeSourceRegionImpl;
import org.eclipse.modisco.kdm.source.extension.ui.interfaces.SourceStrategy;

public class StrategySourceJava
implements SourceStrategy {
    private static final String METAMODEL_URI = JavaPackage.eINSTANCE.getNsURI();
    private static final String DEBUG_ID = "org.eclipse.modisco.java.composition.ui/debug/StrategySourceJava/debug";
    static final boolean DEBUG = Activator.getDefault().isDebugging() && new Boolean(Platform.getDebugOption((String)"org.eclipse.modisco.java.composition.ui/debug/StrategySourceJava/debug")) != false;

    public ASTNodeSourceRegion getASTNodeSourceRegion(EObject eObject) {
        if (DEBUG) {
            System.out.println("StrategySourceJava.getASTNodeSourceRegion()");
        }
        if (eObject instanceof CompilationUnit) {
            CompilationUnit cu = (CompilationUnit)eObject;
            if (DEBUG) {
                System.out.println("Found a Compilation Unit: " + String.valueOf(cu));
            }
            ASTNodeSourceRegionImpl astNodeSourceRegion = new ASTNodeSourceRegionImpl(){};
            astNodeSourceRegion.setPath(cu.getOriginalFilePath());
            astNodeSourceRegion.setStartPosition(new Integer(0));
            astNodeSourceRegion.setEndPosition(new Integer(0));
            return astNodeSourceRegion;
        }
        if (eObject instanceof ASTNode) {
            GetASTNodeSourceRegion query = new GetASTNodeSourceRegion();
            ASTNode astNode = (ASTNode)eObject;
            try {
                return query.evaluate(astNode, null);
            }
            catch (ModelQueryExecutionException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        }
        return null;
    }

    public boolean isApplicableTo(Notifier target) {
        if (target instanceof EObject) {
            return ((EObject)target).eClass().getEPackage().getNsURI().equalsIgnoreCase(METAMODEL_URI);
        }
        return false;
    }
}

