/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.db;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.server.db.IDBStore;
import org.eclipse.emf.cdo.server.db.IDBStoreAccessor;
import org.eclipse.emf.cdo.server.db.IModelEvolutionSupport;
import org.eclipse.emf.cdo.server.db.mapping.IMappingStrategy;
import org.eclipse.emf.cdo.server.internal.db.DBStore;
import org.eclipse.emf.cdo.server.internal.db.DBStoreTables;
import org.eclipse.emf.cdo.server.internal.db.MetaDataManager;
import org.eclipse.emf.cdo.server.internal.db.ModelEvolutionContext;
import org.eclipse.emf.cdo.server.internal.db.bundle.OM;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.db.DBUtil;
import org.eclipse.net4j.db.IDBConnection;
import org.eclipse.net4j.db.IDBRowHandler;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.factory.AnnotationFactory;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;

public class ModelEvolutionSupport
extends Lifecycle
implements IModelEvolutionSupport {
    public static final String FACTORY_TYPE = "default";
    private IDBStore store;
    private IModelEvolutionSupport.Model.Loader modelLoader;
    private ModelEvolutionMode mode;

    @Override
    public IDBStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IDBStore store) {
        this.checkInactive();
        this.store = store;
    }

    public IModelEvolutionSupport.Model.Loader getModelLoader() {
        return this.modelLoader;
    }

    @AnnotationFactory.InjectElement(name="modelLoader", productGroup="org.eclipse.emf.cdo.server.db.modelLoaders")
    public void setModelLoader(IModelEvolutionSupport.Model.Loader modelLoader) {
        this.checkInactive();
        this.modelLoader = modelLoader;
    }

    public ModelEvolutionMode getMode() {
        return this.mode;
    }

    @AnnotationFactory.InjectAttribute(name="mode")
    public void setMode(ModelEvolutionMode mode) {
        this.checkInactive();
        this.mode = mode;
    }

    @Override
    public void evolveModels() throws SQLException {
        this.checkActive();
        if (this.mode == ModelEvolutionMode.DISABLED) {
            OM.LOG.info("Model evolution is disabled for repository " + this.store.getRepository().getName());
            return;
        }
        List<IModelEvolutionSupport.Model> models = this.modelLoader.loadModels(this.store);
        List<IModelEvolutionSupport.Model> changedModels = models.stream().filter(IModelEvolutionSupport.Model::isChanged).collect(Collectors.toList());
        if (changedModels.isEmpty()) {
            OM.LOG.info("No model evolution needed for repository " + this.store.getRepository().getName());
            return;
        }
        if (this.mode == ModelEvolutionMode.PREVENT) {
            throw new IllegalStateException("Model evolution needed for repository " + this.store.getRepository().getName() + ", but model evolution mode is set to PREVENT");
        }
        IMappingStrategy.ModelEvolution mappingStrategy = (IMappingStrategy.ModelEvolution)ObjectUtil.tryCast((Object)this.store.getMappingStrategy(), IMappingStrategy.ModelEvolution.class, () -> new IMappingStrategy.ModelEvolution.ModelEvolutionNotSupportedException());
        ModelEvolutionContext context = this.createModelEvolutionContext(this.store, models, changedModels);
        context.log("Starting model evolution for repository " + this.store.getRepository().getName());
        boolean triggerCrashRecovery = this.doEvolveModels(context, mappingStrategy);
        context.log("Restarting store to pick up evolved models (crash recovery: " + triggerCrashRecovery + ")");
        this.store.triggerRestart(triggerCrashRecovery);
    }

    protected boolean doEvolveModels(IModelEvolutionSupport.Context context, IMappingStrategy.ModelEvolution mappingStrategy) throws SQLException {
        IDBStoreAccessor accessor = this.store.getWriter(null);
        StoreThreadLocal.setAccessor((IStoreAccessor)accessor);
        try {
            boolean triggerCrashRecovery = this.delegateToMappingStrategy(context, accessor, mappingStrategy);
            triggerCrashRecovery |= this.updateSystemTables(context, accessor);
            context.log("Model evolution completed with " + context.getTotalUpdateCount() + " row updates");
            boolean bl = triggerCrashRecovery |= this.commitChanges(context, accessor);
            return bl;
        }
        finally {
            StoreThreadLocal.release();
        }
    }

    protected boolean delegateToMappingStrategy(IModelEvolutionSupport.Context context, IDBStoreAccessor accessor, IMappingStrategy.ModelEvolution mappingStrategy) throws SQLException {
        return mappingStrategy.evolveModels(context, accessor);
    }

    protected boolean updateSystemTables(IModelEvolutionSupport.Context context, IDBStoreAccessor accessor) throws SQLException {
        IDBConnection connection = accessor.getDBConnection();
        DBStore store = (DBStore)accessor.getStore();
        MetaDataManager metaDataManager = (MetaDataManager)store.getMetaDataManager();
        DBStoreTables.PackageUnitsTable packageUnits = store.tables().packageUnits();
        DBStoreTables.PackageInfosTable packageInfos = store.tables().packageInfos();
        Throwable throwable = null;
        Object var9_10 = null;
        try (Statement statement = connection.createStatement();){
            for (IModelEvolutionSupport.Model model : context.getChangedModels()) {
                String unitID = model.getID();
                statement.execute("DELETE from " + (Object)((Object)packageUnits) + " WHERE " + packageUnits.id() + "='" + unitID + "'");
                statement.execute("DELETE from " + (Object)((Object)packageInfos) + " WHERE " + packageInfos.unit() + "='" + unitID + "'");
                EPackage registeredPackage = model.getRegisteredPackage();
                byte[] packageBytes = MetaDataManager.getEPackageBytes(registeredPackage, EPackage.Registry.INSTANCE);
                metaDataManager.writePackageUnit(connection, unitID, model.getOriginalType().ordinal(), context.getTimeStamp(), packageBytes, null);
                EPackage[] ePackageArray = EMFUtil.getAllPackages((EPackage)registeredPackage);
                int n = ePackageArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EPackage ePackage = ePackageArray[n2];
                    metaDataManager.writePackageInfo(connection, ePackage.getNsURI(), EMFUtil.getParentURI((EPackage)ePackage), unitID, null);
                    ++n2;
                }
            }
            EMFUtil.TreeMapping<EObject> elementMappings = context.getElementMappings();
            Set registeredURIs = elementMappings.getToObjectsByURI().keySet();
            elementMappings.getFromObjectsByURI().forEach((uri, modelElement) -> {
                if (modelElement instanceof EModelElement && !registeredURIs.contains(uri)) {
                    metaDataManager.deleteMetaIDMapping(statement, (EModelElement)modelElement);
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return false;
    }

    protected boolean commitChanges(IModelEvolutionSupport.Context context, IDBStoreAccessor accessor) throws SQLException {
        context.log("Committing model evolution changes to the database");
        accessor.getConnection().commit();
        return false;
    }

    protected ModelEvolutionContext createModelEvolutionContext(IDBStore store, List<IModelEvolutionSupport.Model> models, List<IModelEvolutionSupport.Model> changedModels) {
        return new ModelEvolutionContext(this, models, changedModels);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        CheckUtil.checkState((Object)this.store, (String)"store");
        if (this.modelLoader == null) {
            this.modelLoader = new DefaultModelLoader();
        }
        if (this.mode == null) {
            this.mode = ModelEvolutionMode.EVOLVE;
        }
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.modelLoader);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.modelLoader);
        super.doDeactivate();
    }

    public static final class DefaultModelLoader
    implements IModelEvolutionSupport.Model.Loader {
        @Override
        public List<IModelEvolutionSupport.Model> loadModels(IDBStore store) throws SQLException {
            ArrayList<IModelEvolutionSupport.Model> models = new ArrayList<IModelEvolutionSupport.Model>();
            EPackage.Registry packageRegistry = this.getPackageRegistry();
            ResourceSet resourceSet = EMFUtil.newEcoreResourceSet((EPackage.Registry)packageRegistry);
            IDBRowHandler modelRowHandler = (row, values) -> {
                String id = (String)values[0];
                CDOPackageUnit.Type originalType = CDOPackageUnit.Type.values()[DBUtil.asInt((Object)values[1])];
                long timeStamp = DBUtil.asLong((Object)values[2]);
                byte[] packageData = (byte[])values[3];
                EPackage storedPackage = MetaDataManager.createEPackage(id, packageData, resourceSet);
                EPackage registeredPackage = packageRegistry.getEPackage(id);
                IModelEvolutionSupport.Model model = new IModelEvolutionSupport.Model(id, originalType, timeStamp, storedPackage, registeredPackage);
                models.add(model);
                return true;
            };
            Throwable throwable = null;
            Object var7_8 = null;
            try (Connection connection = store.getConnection();){
                DBStoreTables.PackageUnitsTable packageUnitsTable = ((DBStore)store).tables().packageUnits();
                DBUtil.select((Connection)connection, (IDBRowHandler)modelRowHandler, (String)"", (IDBField[])new IDBField[]{packageUnitsTable.id(), packageUnitsTable.originalType(), packageUnitsTable.timeStamp(), packageUnitsTable.packageData()});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return models;
        }

        protected EPackage.Registry getPackageRegistry() {
            return EPackage.Registry.INSTANCE;
        }
    }

    public static enum ModelEvolutionMode {
        DISABLED,
        PREVENT,
        EVOLVE;


        public static ModelEvolutionMode parse(String str) {
            if (str != null) {
                ModelEvolutionMode[] modelEvolutionModeArray = ModelEvolutionMode.values();
                int n = modelEvolutionModeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelEvolutionMode mode = modelEvolutionModeArray[n2];
                    if (mode.name().equalsIgnoreCase(str)) {
                        return mode;
                    }
                    ++n2;
                }
            }
            return null;
        }
    }
}

