/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.datatools.enablement.sybase.asa.ISybaseASADdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ddl.SybaseASADdlBuilder;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseColumn;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.SQLDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.expressions.ValueExpression;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.TypedElement;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class SybaseASAColumnDeltaDdlGenProvider
extends AbstractDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
ISybaseASADdlConstants {
    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
        super.analyze(element, changeMap, modificationRecords);
        List records = (List)modificationRecords.get(element);
        if (records == null) {
            return;
        }
        boolean flag1 = false;
        boolean flag2 = false;
        int i = records.size() - 1;
        while (i >= 0) {
            SybaseDeltaDdlGeneration.FeatureChangeRecord record = (SybaseDeltaDdlGeneration.FeatureChangeRecord)records.get(i);
            EStructuralFeature f = record.feature;
            if (f == SQLSchemaPackage.eINSTANCE.getTypedElement_ContainedType() || f == SQLSchemaPackage.eINSTANCE.getTypedElement_ReferencedType() || f == SQLTablesPackage.eINSTANCE.getColumn_Nullable()) {
                if (flag1) {
                    records.remove(i);
                }
                flag1 = true;
            }
            if (!(f != SQLTablesPackage.eINSTANCE.getColumn_GenerateExpression() && f != SQLTablesPackage.eINSTANCE.getColumn_DefaultValue() || record.newValue != null && !record.newValue.equals(""))) {
                if (flag2) {
                    records.remove(i);
                }
                flag2 = true;
            }
            --i;
        }
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema, boolean quotedIdentifier) {
        SQLDataType containedType = typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
                return def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                if (referencedType.getSchema() != schema) {
                    return this.getName(referencedType, quotedIdentifier, false);
                }
                if (quotedIdentifier) {
                    return this.getDoubleQuotedString(referencedType.getName());
                }
                return referencedType.getName();
            }
        }
        return null;
    }

    protected void getModificationResult(SQLObject e, EStructuralFeature f, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        SybaseASADdlBuilder builder = SybaseASADdlBuilder.getInstance();
        SybaseASABaseColumn column = (SybaseASABaseColumn)e;
        Table table = column.getTable();
        StringBuffer sb = new StringBuffer(256);
        sb.append("ALTER").append(" ").append("TABLE").append(" ");
        sb.append(builder.getName((ENamedElement)table, quoteIdentifiers, qualifyNames)).append(" ");
        if (f == EcorePackage.eINSTANCE.getENamedElement_Name()) {
            String oldName = (String)oldValue;
            String newName = (String)newValue;
            sb.append("RENAME").append(" ").append(quoteIdentifiers ? this.getDoubleQuotedString(oldName) : oldName).append(" ").append("TO").append(" ").append(quoteIdentifiers ? this.getDoubleQuotedString(newName) : newName);
            script.addAlterTableRenameColumnStatements(sb.toString());
        } else if (f == SQLSchemaPackage.eINSTANCE.getTypedElement_ContainedType() || f == SQLSchemaPackage.eINSTANCE.getTypedElement_ReferencedType()) {
            sb.append("MODIFY").append(" ").append(builder.getName((ENamedElement)column, quoteIdentifiers, false)).append(" ").append(this.getDataTypeString((TypedElement)column, column.getTable().getSchema(), quoteIdentifiers)).append(" ").append(column.isNullable() ? "" : "NOT ").append("NULL");
            script.addAlterTableModifyColumnTypeStatements(sb.toString());
        } else if (f == SQLTablesPackage.eINSTANCE.getColumn_Nullable()) {
            sb.append("MODIFY").append(" ").append(builder.getName((ENamedElement)column, quoteIdentifiers, false)).append(" ").append(column.isNullable() ? "" : "NOT ").append("NULL");
            script.addAlterTableColumnStatements(sb.toString());
        }
        if (f == SQLTablesPackage.eINSTANCE.getColumn_DefaultValue()) {
            sb = new StringBuffer("");
            if (column.isIsComputedColumn()) {
                sb.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)table, quoteIdentifiers, qualifyNames)).append(" ").append("ALTER").append(" ").append(builder.getName((ENamedElement)e, quoteIdentifiers, false)).append(" ");
                sb.append("SET").append(" ").append("COMPUTE").append(" ").append("(").append(newValue).append(")");
            } else {
                StringBuffer dropComp = new StringBuffer("");
                dropComp.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)table, quoteIdentifiers, qualifyNames)).append(" ").append("ALTER").append(" ").append(builder.getName((ENamedElement)e, quoteIdentifiers, false)).append(" ").append("DROP").append(" ").append("COMPUTE");
                script.addAlterTableColumnStatements(dropComp.toString());
                sb.append("ALTER").append(" ").append("TABLE").append(" ").append(builder.getName((ENamedElement)table, quoteIdentifiers, qualifyNames)).append(" ").append("MODIFY").append(" ").append(builder.getName((ENamedElement)e, quoteIdentifiers, false)).append(" ");
                if (newValue != null) {
                    sb.append("DEFAULT").append(" ").append(newValue);
                } else {
                    sb.append("DEFAULT").append(" ").append("NULL");
                }
            }
            script.addAlterTableColumnStatements(sb.toString());
        } else if (f == SQLTablesPackage.eINSTANCE.getColumn_GenerateExpression()) {
            sb = new StringBuffer("");
            sb.append("ALTER").append(" ").append(builder.getName((ENamedElement)e, quoteIdentifiers, qualifyNames)).append(" ");
            ValueExpression ve = (ValueExpression)newValue;
            if (ve != null && ve.getSQL() != null && !ve.getSQL().equals("")) {
                sb.append("SET").append(" ").append("COMPUTE").append(" ").append("(").append(ve.getSQL()).append(")");
            } else {
                sb.append("DROP").append(" ").append("COMPUTE");
            }
            script.addAlterTableColumnStatements(sb.toString());
        } else if (f == SQLSchemaPackage.eINSTANCE.getSQLObject_Description()) {
            sb = new StringBuffer("");
            sb.append(SybaseASADdlBuilder.getInstance().createComment(e, quoteIdentifiers, true, true));
            script.addAlterOtherStatements(sb.toString());
        }
    }

    protected void addCreateStatement(SybaseDdlScript script, String statement) {
        script.addAlterTableColumnStatements(statement);
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
        script.addAlterTableDropColumnStatements(statement);
    }
}

