/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.dnd;

import org.eclipse.cdt.make.core.IMakeCommonBuildInfo;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.internal.ui.dnd.AbstractSelectionDragAdapter;
import org.eclipse.cdt.make.internal.ui.dnd.MakeTargetDndUtil;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;

public class TextTransferDragSourceListener
extends AbstractSelectionDragAdapter {
    public TextTransferDragSourceListener(ISelectionProvider provider) {
        super(provider);
    }

    public Transfer getTransfer() {
        return TextTransfer.getInstance();
    }

    @Override
    protected boolean isDragable(ISelection selection) {
        return MakeTargetDndUtil.isDragable(selection);
    }

    @Override
    protected void dragInit(ISelection selection) {
    }

    @Override
    protected Object prepareDataForTransfer(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            return TextTransferDragSourceListener.convertSelectedMakeTargetsToText((IStructuredSelection)selection);
        }
        return null;
    }

    @Override
    protected void dragDone() {
    }

    public static String convertSelectedMakeTargetsToText(IStructuredSelection selection) {
        Object targetsText = "";
        for (Object selectionItem : selection.toList()) {
            Object buildTarget;
            if (!(selectionItem instanceof IMakeTarget)) continue;
            IMakeTarget makeTarget = (IMakeTarget)selectionItem;
            String buildCommand = makeTarget.isDefaultBuildCmd() ? MakeTargetDndUtil.getProjectBuildCommand(makeTarget.getProject()) : makeTarget.getBuildAttribute(IMakeCommonBuildInfo.BUILD_COMMAND, "make");
            Object buildCommandArguments = makeTarget.getBuildAttribute(IMakeCommonBuildInfo.BUILD_ARGUMENTS, "").trim();
            if (((String)buildCommandArguments).length() > 0) {
                buildCommandArguments = " " + (String)buildCommandArguments;
            }
            if (((String)(buildTarget = makeTarget.getBuildAttribute(IMakeTarget.BUILD_TARGET, "").trim())).length() > 0) {
                buildTarget = " " + (String)buildTarget;
            }
            targetsText = (String)targetsText + buildCommand + (String)buildCommandArguments + (String)buildTarget + System.getProperty("line.separator");
        }
        return targetsText;
    }
}

