/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.internal.checkers.ui.quickfix.QuickFixMessages;
import org.eclipse.cdt.codan.ui.AbstractCodanCMarkerResolution;
import org.eclipse.cdt.internal.errorparsers.Fixit;
import org.eclipse.cdt.internal.errorparsers.FixitManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public class QuickFixForFixit
extends AbstractCodanCMarkerResolution {
    public String getLabel() {
        return QuickFixMessages.QuickFixForFixit_apply_fixit;
    }

    public void apply(IMarker marker, IDocument document) {
        int lineNum = marker.getAttribute("lineNumber", -1);
        try {
            if (lineNum >= 0) {
                Fixit f = FixitManager.getInstance().findFixit(marker);
                int lineOffset = document.getLineOffset(f.getLineNumber() - 1);
                int columnOffset = f.getColumnNumber() - 1;
                try {
                    document.replace(lineOffset + columnOffset, f.getLength(), f.getChange());
                }
                catch (BadLocationException e) {
                    return;
                }
            }
            FixitManager.getInstance().deleteMarker(marker);
            marker.delete();
        }
        catch (CoreException | BadLocationException e) {
            CheckersUiActivator.log(e);
        }
    }

    public boolean isApplicable(IMarker marker) {
        return FixitManager.getInstance().hasFixit(marker);
    }
}

