/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.test.junit5.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.platform.commons.support.AnnotationSupport;
import org.osgi.test.common.inject.FieldInjector;
import org.osgi.test.common.inject.TargetType;

public abstract class InjectingExtension<INJECTION extends Annotation>
implements BeforeEachCallback,
BeforeAllCallback,
ParameterResolver,
AfterAllCallback,
AfterEachCallback {
    private final Class<INJECTION> annotation;
    private final List<Class<?>> targetTypes;

    protected InjectingExtension(Class<INJECTION> annotation, Class<?> ... targetTypes) {
        this.annotation = Objects.requireNonNull(annotation);
        this.targetTypes = Arrays.asList(targetTypes);
    }

    protected Class<INJECTION> annotation() {
        return this.annotation;
    }

    protected List<Class<?>> targetTypes() {
        return this.targetTypes;
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        List fields = FieldInjector.findAnnotatedFields((Class)extensionContext.getRequiredTestClass(), this.annotation(), m -> Modifier.isStatic(m.getModifiers()));
        fields.stream().filter(field -> this.supportsField((Field)field, extensionContext)).forEach(field -> FieldInjector.setField((Field)field, null, (Object)this.resolveField((Field)field, extensionContext)));
        if (this.isLifecyclePerClass(extensionContext)) {
            this.injectNonStaticFields(extensionContext, extensionContext.getRequiredTestInstance());
        }
        this.injectNonStaticFields(extensionContext);
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        if (!this.isLifecyclePerClass(extensionContext)) {
            this.injectNonStaticFields(extensionContext, extensionContext.getRequiredTestInstance());
        }
        this.injectNonStaticFields(extensionContext);
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
    }

    protected int disallowedFieldModifiers() {
        return 18;
    }

    protected boolean supportsField(Field field, ExtensionContext extensionContext) {
        if (!AnnotationSupport.isAnnotated((AnnotatedElement)field, this.annotation())) {
            return false;
        }
        if ((field.getModifiers() & this.disallowedFieldModifiers()) != 0) {
            throw new ExtensionConfigurationException(String.format("Field %s must not be %s for annotation @%s.", field.getName(), Modifier.toString(field.getModifiers() & this.disallowedFieldModifiers()), this.annotation().getSimpleName()));
        }
        TargetType targetType = TargetType.of((Field)field);
        try {
            return this.supportsType(targetType, extensionContext);
        }
        catch (ParameterResolutionException pre) {
            ExtensionConfigurationException ece = new ExtensionConfigurationException(pre.getMessage(), pre.getCause());
            ece.setStackTrace(pre.getStackTrace());
            throw ece;
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (!parameterContext.isAnnotated(this.annotation())) {
            return false;
        }
        TargetType targetType = TargetType.of((Parameter)parameterContext.getParameter());
        return this.supportsType(targetType, extensionContext);
    }

    protected boolean supportsType(TargetType targetType, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (!this.targetTypes().isEmpty()) {
            Class type = targetType.getType();
            if (this.targetTypes().stream().noneMatch(type::isAssignableFrom)) {
                throw new ParameterResolutionException(String.format("Element %s has an unsupported type %s for annotation @%s. Supported types are: %s.", targetType.getName(), type.getName(), this.annotation().getSimpleName(), this.targetTypes().stream().map(Class::getName).collect(Collectors.joining())));
            }
        }
        return true;
    }

    protected Object resolveField(Field field, ExtensionContext extensionContext) {
        Annotation injection = (Annotation)AnnotationSupport.findAnnotation((AnnotatedElement)field, this.annotation()).get();
        TargetType targetType = TargetType.of((Field)field);
        try {
            return this.resolveValue(targetType, injection, extensionContext);
        }
        catch (ParameterResolutionException pre) {
            ExtensionConfigurationException ece = new ExtensionConfigurationException(pre.getMessage(), pre.getCause());
            ece.setStackTrace(pre.getStackTrace());
            throw ece;
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Annotation injection = (Annotation)parameterContext.findAnnotation(this.annotation()).get();
        TargetType targetType = TargetType.of((Parameter)parameterContext.getParameter());
        return this.resolveValue(targetType, injection, extensionContext);
    }

    protected abstract Object resolveValue(TargetType var1, INJECTION var2, ExtensionContext var3) throws ParameterResolutionException;

    private void injectNonStaticFields(ExtensionContext extensionContext) {
        if (!extensionContext.getTestInstances().isPresent()) {
            return;
        }
        TestInstances instances = extensionContext.getRequiredTestInstances();
        Object innerMost = instances.getInnermostInstance();
        for (Object instance : instances.getAllInstances()) {
            Class<?> testClass;
            boolean perInstance;
            if (innerMost == instance || !(perInstance = !this.isLifecyclePerClass(testClass = instance.getClass()))) continue;
            this.injectNonStaticFields(extensionContext, instance);
        }
    }

    private void injectNonStaticFields(ExtensionContext extensionContext, Object instance) {
        Class<?> testClass = instance.getClass();
        List fields = FieldInjector.findAnnotatedNonStaticFields(testClass, this.annotation());
        fields.stream().filter(field -> this.supportsField((Field)field, extensionContext)).forEach(field -> FieldInjector.setField((Field)field, (Object)instance, (Object)this.resolveField((Field)field, extensionContext)));
    }

    protected boolean isLifecyclePerClass(ExtensionContext context) {
        return context.getTestInstanceLifecycle().filter(arg_0 -> TestInstance.Lifecycle.PER_CLASS.equals(arg_0)).isPresent();
    }

    protected boolean isLifecyclePerClass(Class<?> testClass) {
        return AnnotationSupport.findAnnotation(testClass, TestInstance.class).map(TestInstance::value).filter(arg_0 -> TestInstance.Lifecycle.PER_CLASS.equals(arg_0)).isPresent();
    }
}

