/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.controls.Separator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableDialog;
import org.eclipse.wb.internal.swing.MigLayout.Activator;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigDimensionInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.ModelMessages;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.AlignmentDescription;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.DimensionResizeComposite;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.DimensionSpecificationComposite;
import org.eclipse.wb.internal.swing.MigLayout.model.ui.DimensionUnitValueField;
import org.eclipse.wb.swing.SwingImages;

abstract class DimensionEditDialog<T extends MigDimensionInfo, A extends Enum<?>>
extends ResizableDialog {
    private final MigLayoutInfo m_layout;
    private final List<T> m_dimensions;
    private final boolean m_horizontal;
    private final String m_dimensionName;
    private final List<AlignmentDescription<A>> m_alignments;
    private T m_dimension;
    private String m_dimensionString;
    private int m_currentIndex;
    private Text m_indexText;
    private Button m_prevButton;
    private Button m_nextButton;
    private DimensionSpecificationComposite m_specificationComposite;
    private List<Button> m_alignmentButtons;
    private DimensionUnitValueField m_minField;
    private DimensionUnitValueField m_prefField;
    private DimensionUnitValueField m_maxField;
    private DimensionResizeComposite m_growComposite;
    private DimensionResizeComposite m_shrinkComposite;
    private static final int APPLY_ID = 1025;

    public DimensionEditDialog(Shell parentShell, MigLayoutInfo layout, List<T> dimensions, T dimension, String dimensionName, List<AlignmentDescription<A>> alignments) {
        super(parentShell, (AbstractUIPlugin)Activator.getDefault());
        this.setShellStyle(67680);
        this.m_layout = layout;
        this.m_dimensions = dimensions;
        this.m_horizontal = dimension instanceof MigColumnInfo;
        this.m_dimensionName = dimensionName;
        this.m_alignments = alignments;
        this.setEditDimension(dimension);
    }

    public void create() {
        super.create();
        this.showDimension();
        this.m_specificationComposite.setFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.createHeaderComposite(container);
        this.createAlignmentComposite(container);
        this.createSizeComposite(container);
        this.createResizeComposites(container);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MessageFormat.format(ModelMessages.DimensionEditDialog_title, this.m_dimensionName));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.m_layout != null) {
            this.createButton(parent, 1025, ModelMessages.DimensionEditDialog_applyButton, false);
        }
    }

    protected void buttonPressed(int buttonId) {
        try {
            if (buttonId == 0 || buttonId == 1025) {
                this.applyChanges();
                this.m_dimensionString = ((MigDimensionInfo)this.m_dimension).getString(false);
            }
            if (buttonId == 1) {
                ((MigDimensionInfo)this.m_dimension).setString(this.m_dimensionString);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.buttonPressed(buttonId);
    }

    private void updateButtons(boolean valid) {
        this.getButton(0).setEnabled(valid);
        this.getButton(1025).setEnabled(valid);
    }

    private void applyChanges() throws Exception {
        ExecutionUtils.run((ObjectInfo)this.m_layout, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                DimensionEditDialog.this.m_layout.writeDimensions();
            }
        });
    }

    private void setEditDimension(T dimension) {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx((MigDimensionInfo)dimension){
            private final /* synthetic */ MigDimensionInfo val$dimension;
            {
                this.val$dimension = migDimensionInfo;
            }

            public void run() throws Exception {
                if (DimensionEditDialog.this.m_dimension != null) {
                    DimensionEditDialog.this.applyChanges();
                }
                DimensionEditDialog.this.m_dimension = this.val$dimension;
                DimensionEditDialog.this.m_dimensionString = ((MigDimensionInfo)DimensionEditDialog.this.m_dimension).getString(false);
                DimensionEditDialog.this.m_currentIndex = DimensionEditDialog.this.m_dimensions.indexOf(DimensionEditDialog.this.m_dimension);
            }
        });
    }

    protected abstract A getAlignment(T var1);

    protected abstract void setAlignment(T var1, A var2);

    private void createHeaderComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).grabH().fill();
        GridLayoutFactory.create((Composite)composite).noMargins().columns(4);
        LocalResourceManager resourceManager = JFaceResources.managerFor((Control)composite);
        new Label(composite, 0).setText(MessageFormat.format(ModelMessages.DimensionEditDialog_index, this.m_dimensionName));
        this.m_indexText = new Text(composite, 2056);
        GridDataFactory.create((Control)this.m_indexText).grabH().fillH().indentHC(3);
        this.m_prevButton = new Button(composite, 0);
        this.m_prevButton.setToolTipText(MessageFormat.format(ModelMessages.DimensionEditDialog_previousButton, this.m_dimensionName));
        ImageDescriptor descriptor = this.m_horizontal ? SwingImages.NAVIGATION_LEFT : SwingImages.NAVIGATION_UP;
        this.m_prevButton.setImage((Image)resourceManager.create((DeviceResourceDescriptor)descriptor));
        this.m_prevButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionEditDialog.this.setEditDimension((MigDimensionInfo)DimensionEditDialog.this.m_dimensions.get(DimensionEditDialog.this.m_currentIndex - 1));
                DimensionEditDialog.this.showDimension();
            }
        });
        this.m_nextButton = new Button(composite, 0);
        this.m_nextButton.setToolTipText(MessageFormat.format(ModelMessages.DimensionEditDialog_nextButton, this.m_dimensionName));
        descriptor = this.m_horizontal ? SwingImages.NAVIGATION_RIGHT : SwingImages.NAVIGATION_DOWN;
        this.m_nextButton.setImage((Image)resourceManager.create((DeviceResourceDescriptor)descriptor));
        this.m_nextButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                DimensionEditDialog.this.setEditDimension((MigDimensionInfo)DimensionEditDialog.this.m_dimensions.get(DimensionEditDialog.this.m_currentIndex + 1));
                DimensionEditDialog.this.showDimension();
            }
        });
        new Label(composite, 0).setText(ModelMessages.DimensionEditDialog_specification);
        this.m_specificationComposite = new DimensionSpecificationComposite(composite);
        GridDataFactory.create((Control)this.m_specificationComposite).spanH(3).grabH().fillH().indentHC(3);
        this.m_specificationComposite.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                DimensionEditDialog.this.updateButtons(e.doit);
                DimensionEditDialog.this.showDimension();
            }
        });
    }

    private void createAlignmentComposite(Composite parent) {
        DimensionEditDialog.createSeparator(parent, ModelMessages.DimensionEditDialog_defaultAlignment);
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).grabH().fill().indentHC(2);
        GridLayoutFactory.create((Composite)composite).noMargins().columns(4);
        this.m_alignmentButtons = new ArrayList<Button>();
        for (final AlignmentDescription<A> description : this.m_alignments) {
            Button button = new Button(composite, 16);
            button.setText(description.getTitle());
            this.m_alignmentButtons.add(button);
            button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DimensionEditDialog.this.setAlignment(DimensionEditDialog.this.m_dimension, description.getAlignment());
                    DimensionEditDialog.this.showDimension();
                }
            });
        }
    }

    private void createSizeComposite(Composite parent) {
        DimensionEditDialog.createSeparator(parent, ModelMessages.DimensionEditDialog_size);
        Composite composite = new Composite(parent, 0);
        GridDataFactory.create((Control)composite).grabH().fill().indentHC(2);
        GridLayoutFactory.create((Composite)composite).noMargins().columns(2);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                DimensionEditDialog.this.updateButtons(e.doit);
                DimensionEditDialog.this.showDimension();
            }
        };
        this.m_minField = new DimensionUnitValueField(composite, ModelMessages.DimensionEditDialog_minimumSize, "minimumSize", listener);
        this.m_prefField = new DimensionUnitValueField(composite, ModelMessages.DimensionEditDialog_preferredSize, "preferredSize", listener);
        this.m_maxField = new DimensionUnitValueField(composite, ModelMessages.DimensionEditDialog_maximumSize, "maximumSize", listener);
    }

    private void createResizeComposites(Composite parent) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                DimensionEditDialog.this.showDimension();
            }
        };
        DimensionEditDialog.createSeparator(parent, ModelMessages.DimensionEditDialog_growTitle);
        this.m_growComposite = new DimensionResizeComposite(parent, 0, "no grow", "grow", 0, 100, "grow", listener);
        GridDataFactory.create((Control)this.m_growComposite).grabH().fill().indentHC(2);
        DimensionEditDialog.createSeparator(parent, ModelMessages.DimensionEditDialog_shrinkTitle);
        this.m_shrinkComposite = new DimensionResizeComposite(parent, 0, "default shrink", "shrink", 100, 100, "shrink", listener);
        GridDataFactory.create((Control)this.m_shrinkComposite).grabH().fill().indentHC(2);
    }

    private void showDimension() {
        this.m_indexText.setText(Integer.toString(this.m_currentIndex));
        this.m_prevButton.setEnabled(this.m_currentIndex != 0);
        this.m_nextButton.setEnabled(this.m_currentIndex < this.m_dimensions.size() - 1);
        this.m_specificationComposite.fromDimension((MigDimensionInfo)this.m_dimension);
        A alignment = this.getAlignment(this.m_dimension);
        int i = 0;
        while (i < this.m_alignments.size()) {
            AlignmentDescription<A> description = this.m_alignments.get(i);
            Button button = this.m_alignmentButtons.get(i);
            button.setSelection(alignment == description.getAlignment());
            ++i;
        }
        this.m_minField.fromDimension((MigDimensionInfo)this.m_dimension);
        this.m_prefField.fromDimension((MigDimensionInfo)this.m_dimension);
        this.m_maxField.fromDimension((MigDimensionInfo)this.m_dimension);
        this.m_growComposite.fromDimension((MigDimensionInfo)this.m_dimension);
        this.m_shrinkComposite.fromDimension((MigDimensionInfo)this.m_dimension);
    }

    private static void createSeparator(Composite parent, String text) {
        Separator separator = new Separator(parent, 0);
        GridDataFactory.create((Control)separator).grabH().fillH();
        separator.setText(text);
        separator.setForeground(separator.getDisplay().getSystemColor(26));
    }
}

