/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.cdt.launching;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.cdt.debug.internal.core.DebugStringVariableSubstitutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.Query;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.dsf.gdb.service.IGDBBackend;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIBackend;
import org.eclipse.cdt.dsf.mi.service.command.commands.MIGDBExit;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.te.core.utils.text.StringUtil;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.runtime.utils.Host;
import org.eclipse.tcf.te.tcf.core.streams.StreamsDataReceiver;
import org.eclipse.tcf.te.tcf.launch.cdt.activator.Activator;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IGdbserverLaunchHandlerDelegate;
import org.eclipse.tcf.te.tcf.launch.cdt.interfaces.IRemoteTEConfigurationConstants;
import org.eclipse.tcf.te.tcf.launch.cdt.launching.TEGdbLaunch;
import org.eclipse.tcf.te.tcf.launch.cdt.nls.Messages;
import org.eclipse.tcf.te.tcf.launch.cdt.preferences.IPreferenceKeys;
import org.eclipse.tcf.te.tcf.launch.cdt.utils.TEHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.launcher.ProcessLauncher;

public abstract class TEGdbAbstractLaunchDelegate
extends GdbLaunchDelegate {
    private String fCurrentGdbServerPort;

    public TEGdbAbstractLaunchDelegate() {
    }

    public TEGdbAbstractLaunchDelegate(boolean requireCProject) {
        super(requireCProject);
    }

    protected GdbLaunch createGdbLaunch(ILaunchConfiguration configuration, String mode, ISourceLocator locator) throws CoreException {
        return new TEGdbLaunch(configuration, mode, locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (!(launch instanceof GdbLaunch)) {
            return;
        }
        Activator.getDefault().initializeTE();
        IPeer peer = TEHelper.getCurrentConnection(config).getPeer();
        boolean isAttachLaunch = "org.eclipse.cdt.launch.attachLaunchType".equals(config.getType().getIdentifier());
        IPath exePath = this.checkBinaryDetails(config);
        String remoteExePath = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PATH, null);
        String remotePID = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PID, null);
        if (!isAttachLaunch && exePath == null) {
            this.abort(Messages.TEGdbAbstractLaunchDelegate_no_program, null, 104);
        }
        if (!isAttachLaunch && remoteExePath == null) {
            this.abort(Messages.TEGdbAbstractLaunchDelegate_no_remote_path, null, 104);
        }
        if (isAttachLaunch && remotePID == null) {
            this.abort(Messages.TEGdbAbstractLaunchDelegate_no_pid, null, 107);
        }
        if (!isAttachLaunch && exePath != null && remoteExePath != null) {
            monitor.setTaskName(Messages.TEGdbAbstractLaunchDelegate_downloading);
            boolean skipDownload = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_SKIP_DOWNLOAD_TO_TARGET, false);
            if (!skipDownload) {
                try {
                    TEHelper.remoteFileTransfer(peer, exePath.toString(), remoteExePath, new SubProgressMonitor(monitor, 80));
                }
                catch (IOException e) {
                    this.abort(NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_filetransferFailed, (Object)e.getLocalizedMessage()), e, 104);
                }
            }
        }
        final AtomicReference<String> gdbserverPortNumber = new AtomicReference<String>(config.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT, TEHelper.getStringPreferenceValue(isAttachLaunch ? IPreferenceKeys.PREF_GDBSERVER_PORT_ATTACH : IPreferenceKeys.PREF_GDBSERVER_PORT)));
        final AtomicReference<String> gdbserverPortNumberMappedTo = new AtomicReference<String>(config.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT_MAPPED_TO, TEHelper.getStringPreferenceValue(isAttachLaunch ? IPreferenceKeys.PREF_GDBSERVER_PORT_ATTACH_MAPPED_TO : IPreferenceKeys.PREF_GDBSERVER_PORT_MAPPED_TO)));
        String gdbserverCommand = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_COMMAND, TEHelper.getStringPreferenceValue(isAttachLaunch ? IPreferenceKeys.PREF_GDBSERVER_COMMAND_ATTACH : IPreferenceKeys.PREF_GDBSERVER_COMMAND));
        final List gdbserverPortNumberAlternatives = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT_ALTERNATIVES, TEHelper.getListPreferenceValue(isAttachLaunch ? IPreferenceKeys.PREF_GDBSERVER_PORT_ATTACH_ALTERNATIVES : IPreferenceKeys.PREF_GDBSERVER_PORT_ALTERNATIVES));
        final List gdbserverPortNumberMappedToAlternatives = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT_MAPPED_TO_ALTERNATIVES, TEHelper.getListPreferenceValue(isAttachLaunch ? IPreferenceKeys.PREF_GDBSERVER_PORT_ATTACH_MAPPED_TO_ALTERNATIVES : IPreferenceKeys.PREF_GDBSERVER_PORT_MAPPED_TO_ALTERNATIVES));
        String gdbinitFile = config.getAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT_NEW", null);
        String origGdbserverPortNumber = gdbserverPortNumber.get();
        String origGdbserverPortNumberMappedTo = gdbserverPortNumberMappedTo.get();
        final AtomicReference<Object> origGdbserverOutput = new AtomicReference<Object>(null);
        ProcessLauncher launcher = null;
        final AtomicBoolean gdbserverLaunchRetry = new AtomicBoolean(false);
        final AtomicInteger indexAlternatives = new AtomicInteger(0);
        do {
            this.fCurrentGdbServerPort = gdbserverPortNumber.get();
            gdbserverLaunchRetry.set(false);
            final AtomicBoolean gdbServerStarted = new AtomicBoolean(false);
            final AtomicBoolean gdbServerReady = new AtomicBoolean(false);
            final AtomicBoolean gdbServerExited = new AtomicBoolean(false);
            final StringBuilder gdbServerOutput = new StringBuilder();
            final Object lock = new Object();
            String commandArguments = "";
            Map commandEnv = null;
            if (isAttachLaunch) {
                commandArguments = "--once --multi :" + gdbserverPortNumber.get();
                monitor.setTaskName(Messages.TEGdbAbstractLaunchDelegate_attaching_program);
            } else {
                commandArguments = "--once :" + gdbserverPortNumber.get() + " " + TEHelper.spaceEscapify(remoteExePath);
                String arguments = this.getProgramArguments(config);
                commandEnv = config.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                if (arguments != null && !arguments.equals("")) {
                    commandArguments = String.valueOf(commandArguments) + " " + arguments.replaceAll("\\r", " ").replaceAll("\\n", " ");
                }
                monitor.setTaskName(Messages.TEGdbAbstractLaunchDelegate_starting_program);
            }
            GdbLaunch l = (GdbLaunch)launch;
            Callback callback = new Callback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void internalDone(Object caller, IStatus status) {
                    if (!status.isOK()) {
                        gdbServerOutput.append(status.getMessage());
                        gdbServerExited.set(true);
                        Object object = lock;
                        synchronized (object) {
                            lock.notifyAll();
                        }
                    } else {
                        gdbServerStarted.set(true);
                    }
                    super.internalDone(caller, status);
                }
            };
            StreamsDataReceiver.Listener listener = new StreamsDataReceiver.Listener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void dataReceived(String data) {
                    gdbServerOutput.append(data);
                    if (data.contains("Listening on port")) {
                        gdbServerReady.set(true);
                        Object object = lock;
                        synchronized (object) {
                            lock.notifyAll();
                        }
                    }
                    if (data.contains("GDBserver exiting") || data.contains("Exiting")) {
                        if (gdbServerOutput.toString().contains("Address already in use.") && gdbserverPortNumberAlternatives != null && !gdbserverPortNumberAlternatives.isEmpty()) {
                            String newPort = null;
                            String newPortMappedTo = null;
                            do {
                                newPort = (String)gdbserverPortNumberAlternatives.get(indexAlternatives.get());
                                if (((String)gdbserverPortNumber.get()).equals(newPort)) {
                                    newPort = null;
                                } else {
                                    newPortMappedTo = gdbserverPortNumberMappedToAlternatives != null && !gdbserverPortNumberMappedToAlternatives.isEmpty() ? (String)gdbserverPortNumberMappedToAlternatives.get(indexAlternatives.get()) : null;
                                }
                                indexAlternatives.getAndIncrement();
                            } while (newPort == null && indexAlternatives.get() < gdbserverPortNumberAlternatives.size());
                            if (newPort != null) {
                                if (origGdbserverOutput.get() == null) {
                                    origGdbserverOutput.set(gdbServerOutput.toString());
                                }
                                gdbserverLaunchRetry.set(true);
                                gdbserverPortNumber.set(newPort);
                                gdbserverPortNumberMappedTo.set(newPortMappedTo);
                            }
                        }
                        gdbServerExited.set(true);
                        Object object = lock;
                        synchronized (object) {
                            lock.notifyAll();
                        }
                    }
                }
            };
            String peerName = null;
            if (remotePID != null) {
                peerName = String.valueOf(peer.getName()) + ", PID " + remotePID;
            }
            String gdbserverLaunchCommand = String.valueOf(gdbserverCommand) + ' ' + commandArguments;
            boolean launchAsRemoteUser = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_LAUNCH_REMOTE_USER, false);
            String userId = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_USER_ID, null);
            String prelaunchCmd = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_PRERUN_COMMANDS, "");
            if (!isAttachLaunch && (prelaunchCmd != null && prelaunchCmd.trim().length() > 0 || launchAsRemoteUser && userId != null && userId.trim().length() > 0)) {
                IPath remotePrerunScriptPath;
                block63: {
                    IPath prerunScriptLocation;
                    String prerunScriptName;
                    block61: {
                        if (prelaunchCmd == null) {
                            prelaunchCmd = "";
                        }
                        SimpleDateFormat formatter = new SimpleDateFormat("HH-mm-ss-S", Locale.US);
                        String prerunScriptNamePreffix = formatter.format(Calendar.getInstance().getTime().getTime());
                        prerunScriptName = String.valueOf(prerunScriptNamePreffix) + "_" + exePath.toFile().getName() + ".sh";
                        IPath rootLocation = Activator.getDefault().getStateLocation().append("prerun_temp_scripts");
                        if (!rootLocation.toFile().exists()) {
                            rootLocation.toFile().mkdirs();
                        }
                        if ((prerunScriptLocation = rootLocation.append(prerunScriptName)).toFile().exists()) {
                            prerunScriptLocation.toFile().delete();
                        }
                        BufferedWriter writer = null;
                        try {
                            try {
                                writer = new BufferedWriter(new FileWriter(prerunScriptLocation.toFile()));
                                writer.write(NLS.bind((String)TEHelper.getPrerunTemplateContent(peer), (Object)prelaunchCmd.replaceAll("\\r", ""), (Object)gdbserverLaunchCommand.replaceAll("\\r", "")));
                            }
                            catch (Exception e) {
                                this.abort(NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_prerunScriptCreationFailed, (Object)prerunScriptLocation, (Object)e.getLocalizedMessage()), e, 104);
                                if (writer != null) {
                                    try {
                                        writer.close();
                                    }
                                    catch (IOException iOException) {}
                                }
                                break block61;
                            }
                        }
                        catch (Throwable throwable) {
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            throw throwable;
                        }
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                    prerunScriptLocation.toFile().setExecutable(true, false);
                    remotePrerunScriptPath = new Path("/tmp").append(prerunScriptName);
                    try {
                        try {
                            TEHelper.remoteFileTransfer(peer, prerunScriptLocation.toString(), remotePrerunScriptPath.toString(), new SubProgressMonitor(monitor, 80));
                        }
                        catch (IOException e) {
                            this.abort(NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_prerunScriptTransferFailed, (Object)remotePrerunScriptPath.toString(), (Object)e.getLocalizedMessage()), e, 104);
                            prerunScriptLocation.toFile().delete();
                            break block63;
                        }
                    }
                    catch (Throwable throwable) {
                        prerunScriptLocation.toFile().delete();
                        throw throwable;
                    }
                    prerunScriptLocation.toFile().delete();
                }
                String arguments = null;
                if (launchAsRemoteUser && userId != null && userId.trim().length() > 0) {
                    arguments = "-u__ " + userId;
                }
                launcher = TEHelper.launchCmdWithEnv(peer, peerName, remotePrerunScriptPath.toString(), arguments, (Map<String, String>)commandEnv, listener, new SubProgressMonitor(monitor, 3), (ICallback)callback);
            } else {
                String[] argv = StringUtil.tokenize((String)gdbserverLaunchCommand, (int)0, (boolean)false);
                launcher = TEHelper.launchCmdWithEnv(peer, peerName, argv[0], argv, (Map<String, String>)commandEnv, listener, new SubProgressMonitor(monitor, 3), (ICallback)callback);
            }
            while (!gdbServerReady.get() && !gdbServerExited.get()) {
                Object object;
                if (monitor.isCanceled()) {
                    this.shutdownSession(l, Messages.TEGdbAbstractLaunchDelegate_canceledMsg, launcher);
                }
                if (gdbServerStarted.get() && launcher.getChannel() == null) {
                    object = lock;
                    synchronized (object) {
                        try {
                            lock.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!gdbserverLaunchRetry.get()) {
                        this.shutdownSession(l, origGdbserverOutput.get() != null ? (String)origGdbserverOutput.get() : gdbServerOutput.toString(), launcher);
                    }
                }
                object = lock;
                synchronized (object) {
                    try {
                        lock.wait(300L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (gdbserverLaunchRetry.get() || !gdbServerExited.get()) continue;
            this.shutdownSession(l, origGdbserverOutput.get() != null ? (String)origGdbserverOutput.get() : gdbServerOutput.toString(), launcher);
        } while (gdbserverLaunchRetry.get());
        if (launch instanceof TEGdbLaunch) {
            ((TEGdbLaunch)launch).setLauncher(launcher);
        }
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        if (!origGdbserverPortNumber.equals(gdbserverPortNumber.get())) {
            wc.setAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT, gdbserverPortNumber.get());
        }
        if (origGdbserverPortNumberMappedTo != null && !origGdbserverPortNumberMappedTo.equals(gdbserverPortNumberMappedTo.get())) {
            wc.setAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_PORT_MAPPED_TO, gdbserverPortNumberMappedTo.get());
        }
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", (String)TEHelper.getCurrentConnection(config).getPeer().getAttributes().get("Host"));
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumberMappedTo.get() == null || "".equals(gdbserverPortNumberMappedTo.get()) ? gdbserverPortNumber.get() : gdbserverPortNumberMappedTo.get());
        if (gdbinitFile != null) {
            String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
            String expanded = new DebugStringVariableSubstitutor(projectName).performStringSubstitution(gdbinitFile);
            File f = new File(expanded);
            wc.setAttribute("org.eclipse.cdt.dsf.gdb.GDB_INIT", f.canRead() && f.isFile() ? f.getAbsolutePath() : null);
        }
        wc.doSave();
        try {
            try {
                super.launch(config, mode, launch, monitor);
            }
            catch (CoreException ex) {
                if (launcher != null) {
                    launcher.terminate();
                }
                throw ex;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void launchDebugSession(ILaunchConfiguration config, ILaunch l, IProgressMonitor monitor) throws CoreException {
        super.launchDebugSession(config, l, monitor);
        this.addWindowsBatchJobTerminator(l);
        boolean isAttachLaunch = "org.eclipse.cdt.launch.attachLaunchType".equals(config.getType().getIdentifier());
        if (!isAttachLaunch) {
            return;
        }
        boolean ok = false;
        try {
            try {
                if (!(l instanceof GdbLaunch)) {
                    throw new DebugException((IStatus)new Status(4, Activator.getUniqueIdentifier(), "Unexpected launch: " + l.getClass().getName()));
                }
                final IPath exePath = this.checkBinaryDetails(config);
                if (exePath == null) {
                    throw new DebugException((IStatus)new Status(4, Activator.getUniqueIdentifier(), "No executable specified"));
                }
                final GdbLaunch launch = (GdbLaunch)l;
                DsfExecutor executor = launch.getDsfExecutor();
                final String pid = config.getAttribute(IRemoteTEConfigurationConstants.ATTR_REMOTE_PID, "0");
                Query<IDMContext> query = new Query<IDMContext>(){

                    protected void execute(DataRequestMonitor<IDMContext> rm) {
                        DsfServicesTracker tracker = new DsfServicesTracker(Activator.getDefault().getBundle().getBundleContext(), launch.getSession().getId());
                        try {
                            IGDBProcesses gdbProcesses = (IGDBProcesses)tracker.getService(IGDBProcesses.class);
                            IGDBControl commandControl = (IGDBControl)tracker.getService(IGDBControl.class);
                            gdbProcesses.attachDebuggerToProcess(gdbProcesses.createProcessContext(commandControl.getContext(), pid), exePath.toString(), rm);
                        }
                        finally {
                            tracker.dispose();
                        }
                    }
                };
                executor.execute((Runnable)query);
                if (query.get() != null) {
                    ok = true;
                }
            }
            catch (InterruptedException exePath) {
                if (!ok) {
                    this.cleanupLaunchLocal(l);
                }
            }
            catch (ExecutionException e) {
                throw new DebugException((IStatus)new Status(4, Activator.getUniqueIdentifier(), "Cannot attach to process", (Throwable)e));
            }
        }
        finally {
            if (!ok) {
                this.cleanupLaunchLocal(l);
            }
        }
    }

    @Deprecated
    protected void cleanupLaunchLocal(ILaunch launch) throws DebugException {
        if (launch instanceof GdbLaunch) {
            final GdbLaunch gdbLaunch = (GdbLaunch)launch;
            Query<Object> launchShutdownQuery = new Query<Object>(){

                protected void execute(DataRequestMonitor<Object> rm) {
                    gdbLaunch.shutdownSession(rm);
                }
            };
            gdbLaunch.getSession().getExecutor().execute((Runnable)launchShutdownQuery);
            try {
                launchShutdownQuery.get();
            }
            catch (InterruptedException e) {
                throw new DebugException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 5013, "InterruptedException while shutting down debugger launch " + launch, (Throwable)e));
            }
            catch (ExecutionException e) {
                throw new DebugException((IStatus)new Status(4, Activator.getUniqueIdentifier(), 5012, "Error in shutting down debugger launch " + launch, (Throwable)e));
            }
        }
    }

    private void addWindowsBatchJobTerminator(ILaunch launch) {
        if (Host.isWindowsHost() && launch instanceof GdbLaunch) {
            final DsfSession s = ((GdbLaunch)launch).getSession();
            s.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    DsfServicesTracker tracker = new DsfServicesTracker(Activator.getDefault().getBundle().getBundleContext(), s.getId());
                    try {
                        final IGDBBackend backend = (IGDBBackend)tracker.getService(IGDBBackend.class);
                        final IGDBControl commandControl = (IGDBControl)tracker.getService(IGDBControl.class);
                        commandControl.addCommandListener(new ICommandListener(){

                            public void commandSent(ICommandToken token) {
                            }

                            public void commandRemoved(ICommandToken token) {
                            }

                            public void commandQueued(ICommandToken token) {
                            }

                            public void commandDone(ICommandToken token, ICommandResult result) {
                                if (token.getCommand() instanceof MIGDBExit) {
                                    s.getExecutor().schedule((Callable)new Callable<Object>(){

                                        @Override
                                        public Object call() throws Exception {
                                            if (commandControl.isActive() && backend.getState() != IMIBackend.State.TERMINATED) {
                                                backend.destroy();
                                            }
                                            return null;
                                        }
                                    }, 500L, TimeUnit.MILLISECONDS);
                                }
                            }
                        });
                    }
                    finally {
                        tracker.dispose();
                    }
                }
            });
        }
    }

    protected void shutdownSession(final GdbLaunch launch, String details, final ProcessLauncher launcher) throws CoreException {
        Assert.isNotNull((Object)launch);
        try {
            launch.getSession().getExecutor().submit((Runnable)new DsfRunnable(){

                public void run() {
                    if (launch.getDsfExecutor() != null) {
                        launch.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
                    }
                    if (launcher != null) {
                        launcher.terminate();
                    }
                }
            }).get(1000L, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        String details2 = this.normalizeDetails(launch, details);
        String msg = Messages.TEGdbAbstractLaunchDelegate_gdbserverFailedToStartErrorMessage;
        if (details2 != null && details2.length() > 0) {
            msg = NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_gdbserverFailedToStartErrorWithDetails, (Object)details2);
        }
        this.abort(msg, null, 106);
    }

    protected String normalizeDetails(GdbLaunch launch, String details) throws CoreException {
        Assert.isNotNull((Object)launch);
        ILaunchConfiguration lc = launch.getLaunchConfiguration();
        boolean isAttachLaunch = "org.eclipse.cdt.launch.attachLaunchType".equals(lc.getType().getIdentifier());
        String d = details;
        if (d != null && !"".equals(d)) {
            IPeerNode peerNode = TEHelper.getCurrentConnection(lc);
            Assert.isNotNull((Object)peerNode);
            IGdbserverLaunchHandlerDelegate delegate = (IGdbserverLaunchHandlerDelegate)ServiceUtils.getDelegateServiceDelegate((Object)peerNode, (Object)peerNode, IGdbserverLaunchHandlerDelegate.class);
            if (delegate != null) {
                d = delegate.normalizeGdbserverLaunchFailureDetailsMessage(launch, details);
            } else if (d.contains("Address already in use.")) {
                String host = lc.getAttribute("org.eclipse.cdt.dsf.gdb.HOST", null);
                String port = this.fCurrentGdbServerPort;
                String address = String.valueOf(host) + (port != null ? ":" + port : "");
                d = NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_error_addressInUse, (Object)address);
            } else if (d.contains("No such file or directory")) {
                String gdbserverCommand = lc.getAttribute(IRemoteTEConfigurationConstants.ATTR_GDBSERVER_COMMAND, TEHelper.getStringPreferenceValue(isAttachLaunch ? IPreferenceKeys.PREF_GDBSERVER_COMMAND_ATTACH : IPreferenceKeys.PREF_GDBSERVER_COMMAND));
                d = NLS.bind((String)Messages.TEGdbAbstractLaunchDelegate_error_nosuchfileordirectory, (Object)gdbserverCommand);
            }
        }
        return d;
    }

    protected String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", null);
        if (args != null) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    protected String getPluginID() {
        return Activator.getUniqueIdentifier();
    }
}

