/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import org.eclipse.swt.tools.internal.JNIClass;
import org.eclipse.swt.tools.internal.JNIGenerator;
import org.eclipse.swt.tools.internal.JNIMethod;

public class StatsGenerator
extends JNIGenerator {
    boolean header;

    public StatsGenerator(boolean header) {
        this.header = header;
    }

    @Override
    public void generateCopyright() {
        this.outputln(this.fixDelimiter(this.getMetaData().getCopyright()));
    }

    @Override
    public void generateIncludes() {
        if (!this.header) {
            this.outputln("#include \"swt.h\"");
            this.output("#include \"");
            this.output(this.getOutputName());
            this.outputln("_stats.h\"");
            this.outputln();
        }
    }

    @Override
    public void generate(JNIClass clazz) {
        if (this.header) {
            this.generateHeaderFile(clazz);
        }
    }

    @Override
    public String getExtension() {
        return this.header ? ".h" : super.getExtension();
    }

    @Override
    public String getSuffix() {
        return "_stats";
    }

    void generateHeaderFile(JNIClass clazz) {
        this.generateNATIVEMacros(clazz);
        JNIMethod[] methods = clazz.getDeclaredMethods();
        StatsGenerator.sort(methods);
        this.generateFunctionEnum(methods);
    }

    void generateNATIVEMacros(JNIClass clazz) {
        String className = clazz.getSimpleName();
        this.output("#ifndef ");
        this.output(className);
        this.outputln("_NATIVE_ENTER");
        this.output("#define ");
        this.output(className);
        this.outputln("_NATIVE_ENTER(env, that, func) ");
        this.outputln("#endif");
        this.output("#ifndef ");
        this.output(className);
        this.outputln("_NATIVE_EXIT");
        this.output("#define ");
        this.output(className);
        this.outputln("_NATIVE_EXIT(env, that, func) ");
        this.outputln("#endif");
        this.outputln();
    }

    void generateStatsNatives(String className) {
        this.outputln("#define STATS_NATIVE(func) Java_org_eclipse_swt_tools_internal_NativeStats_##func");
        this.outputln();
        this.output("JNIEXPORT jint JNICALL STATS_NATIVE(");
        this.output(StatsGenerator.toC(className + "_GetFunctionCount"));
        this.outputln(")");
        this.outputln("\t(JNIEnv *env, jclass that)");
        this.outputln("{");
        this.output("\treturn ");
        this.output(className);
        this.outputln("_nativeFunctionCount;");
        this.outputln("}");
        this.outputln();
        this.output("JNIEXPORT jstring JNICALL STATS_NATIVE(");
        this.output(StatsGenerator.toC(className + "_GetFunctionName"));
        this.outputln(")");
        this.outputln("\t(JNIEnv *env, jclass that, jint index)");
        this.outputln("{");
        this.output("\treturn ");
        boolean isCPP = this.getCPP();
        if (isCPP) {
            this.output("env->NewStringUTF(");
        } else {
            this.output("(*env)->NewStringUTF(env, ");
        }
        this.output(className);
        this.outputln("_nativeFunctionNames[index]);");
        this.outputln("}");
        this.outputln();
        this.output("JNIEXPORT jint JNICALL STATS_NATIVE(");
        this.output(StatsGenerator.toC(className + "_GetFunctionCallCount"));
        this.outputln(")");
        this.outputln("\t(JNIEnv *env, jclass that, jint index)");
        this.outputln("{");
        this.output("\treturn ");
        this.output(className);
        this.outputln("_nativeFunctionCallCount[index];");
        this.outputln("}");
    }

    void generateFunctionEnum(JNIMethod[] methods) {
        if (methods.length == 0) {
            return;
        }
        this.outputln("typedef enum {");
        JNIMethod[] jNIMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            JNIMethod method = jNIMethodArray[n2];
            if ((method.getModifiers() & 0x100) != 0) {
                String function = StatsGenerator.getFunctionName(method);
                this.output("\t");
                this.output(function);
                this.outputln("_FUNC,");
                if (this.progress != null) {
                    this.progress.step();
                }
            }
            ++n2;
        }
        JNIClass clazz = methods[0].getDeclaringClass();
        this.output("} ");
        this.output(clazz.getSimpleName());
        this.outputln("_FUNCS;");
    }
}

