/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.text.correction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.text.correction.PHPCorrectionProcessor;
import org.eclipse.php.internal.ui.text.correction.QuickAssistLightBulbUpdater;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPCorrectionAssistant
extends QuickAssistAssistant {
    private ITextViewer fViewer;
    private ITextEditor fEditor;
    private Position fPosition;
    private Annotation[] fCurrentAnnotations;
    private QuickAssistLightBulbUpdater fLightBulbUpdater;
    private boolean fIsCompletionActive;
    private boolean fIsProblemLocationAvailable;

    public PHPCorrectionAssistant() {
        this.enableColoredLabels(PlatformUI.getPreferenceStore().getBoolean("USE_COLORED_LABELS"));
        this.setInformationControlCreator(this.getInformationControlCreator());
        this.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
                PHPCorrectionAssistant.this.fIsCompletionActive = false;
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                PHPCorrectionAssistant.this.fIsCompletionActive = true;
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    public IEditorPart getEditor() {
        return this.fEditor;
    }

    private IInformationControlCreator getInformationControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, DLTKUIPlugin.getAdditionalInfoAffordanceString());
            }
        };
    }

    public void install(ISourceViewer sourceViewer) {
        super.install(sourceViewer);
        this.fViewer = sourceViewer;
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            this.fEditor = ((PHPStructuredTextViewer)sourceViewer).getTextEditor();
        }
        this.fLightBulbUpdater = new QuickAssistLightBulbUpdater(this.fEditor, (ITextViewer)sourceViewer);
        this.fLightBulbUpdater.install();
    }

    public void uninstall() {
        if (this.fLightBulbUpdater != null) {
            this.fLightBulbUpdater.uninstall();
            this.fLightBulbUpdater = null;
        }
        super.uninstall();
    }

    public String showPossibleQuickAssists() {
        boolean isReinvoked = false;
        this.fIsProblemLocationAvailable = false;
        if (this.fIsCompletionActive && this.isUpdatedOffset()) {
            isReinvoked = true;
            this.restorePosition();
            this.hide();
            this.fIsProblemLocationAvailable = true;
        }
        this.fPosition = null;
        this.fCurrentAnnotations = null;
        if (this.fViewer == null || this.fViewer.getDocument() == null) {
            return super.showPossibleQuickAssists();
        }
        ArrayList<Annotation> resultingAnnotations = new ArrayList<Annotation>(20);
        try {
            Point selectedRange = this.fViewer.getSelectedRange();
            int currOffset = selectedRange.x;
            int currLength = selectedRange.y;
            boolean goToClosest = currLength == 0 && !isReinvoked;
            int newOffset = PHPCorrectionAssistant.collectQuickFixableAnnotations(this.fEditor, currOffset, goToClosest, resultingAnnotations);
            if (newOffset != currOffset) {
                this.storePosition(currOffset, currLength);
                this.fViewer.setSelectedRange(newOffset, 0);
                this.fViewer.revealRange(newOffset, 0);
                this.fIsProblemLocationAvailable = true;
                if (this.fIsCompletionActive) {
                    this.hide();
                }
            }
        }
        catch (BadLocationException e) {
            PHPUiPlugin.log(e);
        }
        this.fCurrentAnnotations = resultingAnnotations.toArray(new Annotation[resultingAnnotations.size()]);
        return super.showPossibleQuickAssists();
    }

    private static IRegion getRegionOfInterest(ITextEditor editor, int invocationLocation) throws BadLocationException {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            return null;
        }
        IDocument document = documentProvider.getDocument((Object)editor.getEditorInput());
        if (document == null) {
            return null;
        }
        return document.getLineInformationOfOffset(invocationLocation);
    }

    /*
     * Unable to fully structure code
     */
    public static int collectQuickFixableAnnotations(ITextEditor editor, int invocationLocation, boolean goToClosest, List<Annotation> resultingAnnotations) throws BadLocationException {
        model = DLTKUIPlugin.getDocumentProvider().getAnnotationModel((Object)editor.getEditorInput());
        if (model == null) {
            return invocationLocation;
        }
        PHPCorrectionAssistant.ensureUpdatedAnnotations(editor);
        iter = model.getAnnotationIterator();
        if (!goToClosest) ** GOTO lbl39
        lineInfo = PHPCorrectionAssistant.getRegionOfInterest(editor, invocationLocation);
        if (lineInfo == null) {
            return invocationLocation;
        }
        rangeStart = lineInfo.getOffset();
        rangeEnd = rangeStart + lineInfo.getLength();
        allAnnotations = new ArrayList<Annotation>();
        allPositions = new ArrayList<Position>();
        bestOffset = 0x7FFFFFFF;
        while (iter.hasNext()) {
            annot = (Annotation)iter.next();
            if (!PHPCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !PHPCorrectionAssistant.isInside(pos.offset, rangeStart, rangeEnd)) continue;
            allAnnotations.add(annot);
            allPositions.add(pos);
            bestOffset = PHPCorrectionAssistant.processAnnotation(annot, pos, invocationLocation, bestOffset);
        }
        if (bestOffset == 0x7FFFFFFF) {
            return invocationLocation;
        }
        i = 0;
        while (i < allPositions.size()) {
            pos = (Position)allPositions.get(i);
            if (PHPCorrectionAssistant.isInside(bestOffset, pos.offset, pos.offset + pos.length)) {
                resultingAnnotations.add((Annotation)allAnnotations.get(i));
            }
            ++i;
        }
        return bestOffset;
lbl-1000:
        // 1 sources

        {
            annot = (Annotation)iter.next();
            if (!PHPCorrectionProcessor.isQuickFixableType(annot) || (pos = model.getPosition(annot)) == null || !PHPCorrectionAssistant.isInside(invocationLocation, pos.offset, pos.offset + pos.length)) continue;
            resultingAnnotations.add(annot);
lbl39:
            // 3 sources

            ** while (iter.hasNext())
        }
lbl40:
        // 1 sources

        return invocationLocation;
    }

    private static void ensureUpdatedAnnotations(ITextEditor editor) {
        Object inputElement = editor.getEditorInput().getAdapter(IModelElement.class);
        if (inputElement instanceof ISourceModule) {
            try {
                SharedASTProvider.getAST((ISourceModule)inputElement, SharedASTProvider.WAIT_ACTIVE_ONLY, null);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
            catch (IOException e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    private static int processAnnotation(Annotation annot, Position pos, int invocationLocation, int bestOffset) {
        int newClosestPosition;
        int posBegin = pos.offset;
        int posEnd = posBegin + pos.length;
        if (PHPCorrectionAssistant.isInside(invocationLocation, posBegin, posEnd)) {
            return invocationLocation;
        }
        if (bestOffset != invocationLocation && (newClosestPosition = PHPCorrectionAssistant.computeBestOffset(posBegin, invocationLocation, bestOffset)) != -1 && newClosestPosition != bestOffset && PHPCorrectionProcessor.hasCorrections(annot)) {
            return newClosestPosition;
        }
        return bestOffset;
    }

    private static boolean isInside(int offset, int start, int end) {
        return offset == start || offset == end || offset > start && offset < end;
    }

    private static int computeBestOffset(int newOffset, int invocationLocation, int bestOffset) {
        if (newOffset <= invocationLocation) {
            if (bestOffset > invocationLocation) {
                return newOffset;
            }
            if (bestOffset <= newOffset) {
                return newOffset;
            }
            return -1;
        }
        if (newOffset <= bestOffset) {
            return newOffset;
        }
        return -1;
    }

    protected void possibleCompletionsClosed() {
        super.possibleCompletionsClosed();
        this.restorePosition();
    }

    private void storePosition(int currOffset, int currLength) {
        this.fPosition = new Position(currOffset, currLength);
    }

    private void restorePosition() {
        if (this.fPosition != null && !this.fPosition.isDeleted() && this.fViewer.getDocument() != null) {
            this.fViewer.setSelectedRange(this.fPosition.offset, this.fPosition.length);
            this.fViewer.revealRange(this.fPosition.offset, this.fPosition.length);
        }
        this.fPosition = null;
    }

    public boolean isUpdatedOffset() {
        return this.fPosition != null;
    }

    public boolean isProblemLocationAvailable() {
        return this.fIsProblemLocationAvailable;
    }

    public Annotation[] getAnnotationsAtOffset() {
        return this.fCurrentAnnotations;
    }
}

