/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.xtext.base.serializer;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.xtext.base.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.xtext.base.serializer.SerializationSegment;
import org.eclipse.xtext.util.Strings;

public class SubstringStep {
    private static final @NonNull String KEY_EXACT = "e-";
    private @Nullable Integer hashCode = null;
    protected final @NonNull String string;
    protected final @NonNull SerializationSegment @NonNull [] serializationSegments;

    public static void toStepString(@NonNull DiagnosticStringBuilder s, @NonNull List<@NonNull SubstringStep> substringSteps) {
        SubstringStep.toStepString(s, substringSteps, 0);
    }

    private static int toStepString(@NonNull DiagnosticStringBuilder s, @NonNull List<@NonNull SubstringStep> substringSteps, int index) {
        SubstringStep step = substringSteps.get(index++);
        step.toStepString(s);
        s.append(")");
        return index;
    }

    public SubstringStep(@NonNull String string, @NonNull SerializationSegment @NonNull [] serializationSegments) {
        this.string = string;
        this.serializationSegments = serializationSegments;
    }

    protected @Nullable Integer basicGetHashCode() {
        return this.hashCode;
    }

    protected int computeHashCode() {
        return this.getClass().hashCode() + 5 * this.string.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubstringStep)) {
            return false;
        }
        return this.equalTo((SubstringStep)obj);
    }

    protected boolean equalTo(@NonNull SubstringStep that) {
        return this.string.equals(that.string);
    }

    public @NonNull String getGlobalSortKey() {
        StringBuilder s = new StringBuilder();
        s.append(KEY_EXACT);
        s.append(this.string);
        return s.toString();
    }

    public final int hashCode() {
        Integer hashCode2 = this.hashCode;
        if (hashCode2 == null) {
            this.hashCode = hashCode2 = Integer.valueOf(this.computeHashCode());
        }
        return hashCode2;
    }

    public @NonNull SerializationSegment @NonNull [] getSerializationSegments() {
        return this.serializationSegments;
    }

    public @NonNull String getString() {
        return this.string;
    }

    public void toRuleString(@NonNull DiagnosticStringBuilder s) {
        @NonNull String javaString = Strings.convertToJavaString((String)this.string);
        s.append("'");
        s.append(javaString);
        s.append("'");
    }

    public void toStepString(@NonNull DiagnosticStringBuilder s) {
        @NonNull String javaString = Strings.convertToJavaString((String)this.string);
        s.append("'");
        s.append(javaString);
        s.append("' ||");
        SerializationSegment[] serializationSegmentArray = this.serializationSegments;
        int n = this.serializationSegments.length;
        int n2 = 0;
        while (n2 < n) {
            @NonNull SerializationSegment serializationSegment = serializationSegmentArray[n2];
            s.append(" ");
            s.append(serializationSegment.toString());
            ++n2;
        }
    }

    public @NonNull String toString() {
        DiagnosticStringBuilder s = new DiagnosticStringBuilder();
        this.toString(s, 0);
        return s.toString();
    }

    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        this.toRuleString(s);
    }
}

