/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.activity.ui;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.commons.activity.ui.UserActivityListener;
import org.eclipse.mylyn.commons.activity.ui.spi.AbstractUserActivityMonitor;
import org.eclipse.mylyn.commons.core.ExtensionPointReader;
import org.eclipse.mylyn.internal.commons.activity.ui.ActivityUiPlugin;
import org.eclipse.mylyn.internal.commons.activity.ui.DefaultUserActivityMonitor;
import org.eclipse.mylyn.internal.commons.activity.ui.UserActivityManager;

public class ActivityUi {
    private static final IPropertyChangeListener PROPERTY_LISTENER = event -> {
        if (event.getProperty().equals("org.eclipse.mylyn.activity.ui.timeout") || event.getProperty().equals("org.eclipse.mylyn..activity.ui.timeout.enabled") || event.getProperty().equals("org.eclipse.mylyn.activity.ui.tracking.enabled")) {
            ActivityUi.updateUserActivityMonitor();
        }
    };
    private static UserActivityManager userActivityManager;

    public static void addUserAttentionListener(UserActivityListener listener) {
        ActivityUi.getUserActivityMonitor().addAttentionListener(listener);
    }

    public static void removeUserAttentionListener(UserActivityListener listener) {
        ActivityUi.getUserActivityMonitor().removeAttentionListener(listener);
    }

    private static IPreferenceStore getPreferenceStore() {
        return ActivityUiPlugin.getDefault().getPreferenceStore();
    }

    static synchronized UserActivityManager getUserActivityMonitor() {
        if (userActivityManager == null) {
            ArrayList<AbstractUserActivityMonitor> items = new ArrayList<AbstractUserActivityMonitor>();
            items.add(new DefaultUserActivityMonitor());
            ExtensionPointReader reader = new ExtensionPointReader("org.eclipes.mylyn.commons.activity.ui", "userActivityMonitors", "osActivityTimer", AbstractUserActivityMonitor.class);
            reader.read();
            items.addAll(reader.getItems());
            Collections.sort(items, (o1, o2) -> o2.getPriority() - o1.getPriority());
            ActivityUi.getPreferenceStore().addPropertyChangeListener(PROPERTY_LISTENER);
            userActivityManager = new UserActivityManager(items);
            ActivityUi.updateUserActivityMonitor();
            userActivityManager.start();
        }
        return userActivityManager;
    }

    static synchronized void updateUserActivityMonitor() {
        if (userActivityManager == null) {
            return;
        }
        if (ActivityUi.getPreferenceStore().getBoolean("org.eclipse.mylyn..activity.ui.timeout.enabled")) {
            userActivityManager.setInactivityTimeout(ActivityUi.getPreferenceStore().getInt("org.eclipse.mylyn.activity.ui.timeout"));
        } else {
            userActivityManager.setInactivityTimeout(0);
        }
    }

    public static boolean isActivityTrackingEnabled() {
        return ActivityUi.getPreferenceStore().getBoolean("org.eclipse.mylyn.activity.ui.tracking.enabled");
    }

    public static synchronized boolean isTrackingOsTime() {
        if (userActivityManager == null) {
            return false;
        }
        return userActivityManager.isTrackingOsTime();
    }
}

