/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.trace.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.m2m.atl.emftvm.trace.SourceElement;
import org.eclipse.m2m.atl.emftvm.trace.TargetElement;
import org.eclipse.m2m.atl.emftvm.trace.TraceFactory;
import org.eclipse.m2m.atl.emftvm.trace.TraceLink;
import org.eclipse.m2m.atl.emftvm.trace.TracePackage;
import org.eclipse.m2m.atl.emftvm.trace.TracedRule;

public class TraceLinkImpl
extends EObjectImpl
implements TraceLink {
    protected EList<SourceElement> sourceElements;
    protected EList<TargetElement> targetElements;
    protected static final boolean OVERRIDDEN_EDEFAULT = false;
    protected boolean overridden = false;
    protected final Map<String, SourceElement> sourceElementsByName = new HashMap<String, SourceElement>();
    protected final Map<String, TargetElement> targetElementsByName = new HashMap<String, TargetElement>();

    protected TraceLinkImpl() {
    }

    protected EClass eStaticClass() {
        return TracePackage.Literals.TRACE_LINK;
    }

    @Override
    public TracedRule getRule() {
        if (this.eContainerFeatureID() != 2) {
            return null;
        }
        return (TracedRule)this.eInternalContainer();
    }

    public NotificationChain basicSetRule(TracedRule newRule, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newRule, 2, msgs);
        return msgs;
    }

    @Override
    public void setRule(TracedRule newRule) {
        if (newRule != this.eInternalContainer() || this.eContainerFeatureID() != 2 && newRule != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newRule)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newRule != null) {
                msgs = ((InternalEObject)newRule).eInverseAdd((InternalEObject)this, 1, TracedRule.class, msgs);
            }
            if ((msgs = this.basicSetRule(newRule, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newRule, (Object)newRule));
        }
    }

    @Override
    public boolean isOverridden() {
        return this.overridden;
    }

    @Override
    public void setOverridden(boolean newOverridden) {
        boolean oldOverridden = this.overridden;
        this.overridden = newOverridden;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldOverridden, this.overridden));
        }
    }

    @Override
    public SourceElement getSourceElement(String name, boolean create) {
        if (this.sourceElementsByName.containsKey(name)) {
            return this.sourceElementsByName.get(name);
        }
        if (create) {
            SourceElement se = TraceFactory.eINSTANCE.createSourceElement();
            se.setName(name);
            this.getSourceElements().add((Object)se);
            return se;
        }
        return null;
    }

    @Override
    public EList<SourceElement> getSourceElements() {
        if (this.sourceElements == null) {
            this.sourceElements = new EObjectContainmentWithInverseEList(SourceElement.class, (InternalEObject)this, 0, 3);
        }
        return this.sourceElements;
    }

    @Override
    public EList<TargetElement> getTargetElements() {
        if (this.targetElements == null) {
            this.targetElements = new EObjectContainmentWithInverseEList(TargetElement.class, (InternalEObject)this, 1, 3);
        }
        return this.targetElements;
    }

    @Override
    public TargetElement getTargetElement(String name) {
        return this.targetElementsByName.get(name);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSourceElements()).basicAdd((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getTargetElements()).basicAdd((Object)otherEnd, msgs);
            }
            case 2: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetRule((TracedRule)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getSourceElements()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getTargetElements()).basicRemove((Object)otherEnd, msgs);
            }
            case 2: {
                return this.basicSetRule(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 2: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 1, TracedRule.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getSourceElements();
            }
            case 1: {
                return this.getTargetElements();
            }
            case 2: {
                return this.getRule();
            }
            case 3: {
                return this.isOverridden();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.getSourceElements().clear();
                this.getSourceElements().addAll((Collection)newValue);
                return;
            }
            case 1: {
                this.getTargetElements().clear();
                this.getTargetElements().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.setRule((TracedRule)newValue);
                return;
            }
            case 3: {
                this.setOverridden((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getSourceElements().clear();
                return;
            }
            case 1: {
                this.getTargetElements().clear();
                return;
            }
            case 2: {
                this.setRule(null);
                return;
            }
            case 3: {
                this.setOverridden(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.sourceElements != null && !this.sourceElements.isEmpty();
            }
            case 1: {
                return this.targetElements != null && !this.targetElements.isEmpty();
            }
            case 2: {
                return this.getRule() != null;
            }
            case 3: {
                return this.overridden;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer("TraceLink [[");
        boolean notFirst = false;
        for (SourceElement se : this.getSourceElements()) {
            if (notFirst) {
                result.append(", ");
            }
            result.append(se.toString());
            notFirst = true;
        }
        result.append("] -> [");
        notFirst = false;
        for (TargetElement te : this.getTargetElements()) {
            if (notFirst) {
                result.append(", ");
            }
            result.append(te.toString());
            notFirst = true;
        }
        result.append("]]");
        return result.toString();
    }

    public boolean eNotificationRequired() {
        return true;
    }

    public void eNotify(Notification notification) {
        block20: {
            super.eNotify(notification);
            block0 : switch (notification.getFeatureID(null)) {
                case 0: {
                    switch (notification.getEventType()) {
                        case 3: {
                            this.sourceElementAdded((SourceElement)notification.getNewValue());
                            break;
                        }
                        case 5: {
                            for (SourceElement se : (Collection)notification.getNewValue()) {
                                this.sourceElementAdded(se);
                            }
                            break block0;
                        }
                        case 4: {
                            this.sourceElementRemoved((SourceElement)notification.getOldValue());
                            break;
                        }
                        case 6: {
                            for (SourceElement se : (Collection)notification.getOldValue()) {
                                this.sourceElementRemoved(se);
                            }
                        }
                    }
                    break;
                }
                case 1: {
                    switch (notification.getEventType()) {
                        case 3: {
                            this.targetElementAdded((TargetElement)notification.getNewValue());
                            break block0;
                        }
                        case 5: {
                            for (TargetElement te : (Collection)notification.getNewValue()) {
                                this.targetElementAdded(te);
                            }
                            break block20;
                        }
                        case 4: {
                            this.targetElementRemoved((TargetElement)notification.getOldValue());
                            break block0;
                        }
                        case 6: {
                            for (TargetElement te : (Collection)notification.getOldValue()) {
                                this.targetElementRemoved(te);
                            }
                        }
                    }
                }
            }
        }
    }

    private void sourceElementAdded(SourceElement se) {
        String seName = se.getName();
        if (this.sourceElementsByName.containsKey(seName)) {
            throw new IllegalArgumentException(String.format("Trace link %s already contains a source element named %s", this, seName));
        }
        this.sourceElementsByName.put(seName, se);
    }

    private void sourceElementRemoved(SourceElement se) {
        this.sourceElementsByName.remove(se.getName());
    }

    private void targetElementAdded(TargetElement te) {
        String teName = te.getName();
        if (this.targetElementsByName.containsKey(teName)) {
            throw new IllegalArgumentException(String.format("Trace link %s already contains a target element named %s", this, teName));
        }
        this.targetElementsByName.put(teName, te);
    }

    private void targetElementRemoved(TargetElement te) {
        this.targetElementsByName.remove(te.getName());
    }
}

