/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.parts;

import javafx.scene.Node;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.StrokeType;
import org.eclipse.gef.common.collections.ObservableSetMultimap;
import org.eclipse.gef.fx.internal.nodes.IBendableCurve;
import org.eclipse.gef.fx.nodes.Connection;
import org.eclipse.gef.mvc.fx.parts.AbstractSegmentHandlePart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;

public class CircleSegmentHandlePart
extends AbstractSegmentHandlePart<Circle> {
    protected static final double DEFAULT_SIZE = 5.0;

    @Override
    protected Circle doCreateVisual() {
        Circle circle = new Circle(2.5);
        circle.setStroke((Paint)this.getStroke());
        circle.setFill((Paint)this.getMoveFill());
        circle.setStrokeWidth(1.0);
        circle.setStrokeType(StrokeType.OUTSIDE);
        return circle;
    }

    @Override
    public void doRefreshVisual(Circle visual) {
        super.doRefreshVisual(visual);
        this.updateColor();
    }

    protected void updateColor() {
        ObservableSetMultimap<IVisualPart<Node>, String> anchorages = this.getAnchoragesUnmodifiable();
        if (this.getRoot() == null || anchorages.keySet().size() != 1) {
            return;
        }
        Circle visual = (Circle)this.getVisual();
        if (!visual.isVisible()) {
            return;
        }
        if (this.getSegmentParameter() != 0.0 && this.getSegmentParameter() != 1.0) {
            visual.setFill((Paint)this.getInsertFill());
            visual.setRadius(2.0);
        } else {
            visual.setRadius(2.5);
            boolean connected = false;
            IVisualPart targetPart = (IVisualPart)anchorages.keySet().iterator().next();
            Object targetVisual = targetPart.getVisual();
            if (targetVisual instanceof Connection || targetPart.getVisual() instanceof IBendableCurve) {
                if ((double)this.getSegmentIndex() + this.getSegmentParameter() == 0.0) {
                    connected = targetVisual instanceof Connection ? ((Connection)targetVisual).isStartConnected() : ((IBendableCurve)targetVisual).isStartConnected();
                } else if (this.getSegmentParameter() + (double)this.getSegmentIndex() == (double)this.getSegmentsInScene().length) {
                    boolean bl = connected = targetVisual instanceof Connection ? ((Connection)targetVisual).isEndConnected() : ((IBendableCurve)targetVisual).isEndConnected();
                }
            }
            if (connected) {
                visual.setFill((Paint)this.getConnectedFill());
            } else {
                visual.setFill((Paint)this.getMoveFill());
            }
        }
    }
}

