/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.egit.core.UnitOfWork;
import org.eclipse.egit.ui.Activator;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public abstract class RepositoryStateCache {
    private static final Object NOTHING = new Object();
    private final Map<File, Map<RepositoryItem, Object>> cache = new ConcurrentHashMap<File, Map<RepositoryItem, Object>>();

    public abstract void initialize();

    public void dispose() {
        this.clear();
    }

    public void clear() {
        this.cache.clear();
    }

    public void clear(Repository repository) {
        this.cache.remove(repository.getDirectory());
    }

    private Map<RepositoryItem, Object> getItems(Repository repository) {
        return this.cache.computeIfAbsent(repository.getDirectory(), gitDir -> new ConcurrentHashMap());
    }

    public StoredConfig getConfig(Repository repository) {
        Object value = this.getItems(repository).computeIfAbsent(RepositoryItem.CONFIG, key -> repository.getConfig());
        return (StoredConfig)value;
    }

    private ObjectId getHead(Repository repository, String[] fullName, Ref[] ref) {
        return (ObjectId)UnitOfWork.get((Repository)repository, () -> {
            ObjectId head = ObjectId.zeroId();
            String name = null;
            Ref r = null;
            try {
                r = repository.exactRef("HEAD");
            }
            catch (IOException e) {
                Activator.logError(e.getLocalizedMessage(), e);
            }
            refArray[0] = r;
            if (r != null) {
                if (r.isSymbolic()) {
                    name = r.getTarget().getName();
                }
                if ((head = r.getObjectId()) != null) {
                    if (name == null) {
                        name = head.name();
                    }
                } else {
                    head = ObjectId.zeroId();
                }
            }
            stringArray[0] = name != null ? name : "";
            return head;
        });
    }

    public ObjectId getHead(Repository repository) {
        ObjectId head;
        if (repository == null) {
            return null;
        }
        Map<RepositoryItem, Object> items = this.getItems(repository);
        Object value = items.get((Object)RepositoryItem.HEAD);
        if (value == null) {
            String[] fullName = new String[1];
            Ref[] headRef = new Ref[1];
            value = items.computeIfAbsent(RepositoryItem.HEAD, key -> this.getHead(repository, fullName, headRef));
            items.computeIfAbsent(RepositoryItem.FULL_BRANCH_NAME, key -> fullName[0]);
            items.computeIfAbsent(RepositoryItem.HEAD_REF, key -> headRef[0] == null ? NOTHING : headRef[0]);
        }
        if ((head = (ObjectId)value) == null || head.equals((AnyObjectId)ObjectId.zeroId())) {
            return null;
        }
        return head;
    }

    public Ref getHeadRef(Repository repository) {
        if (repository == null) {
            return null;
        }
        Map<RepositoryItem, Object> items = this.getItems(repository);
        Object value = items.get((Object)RepositoryItem.HEAD_REF);
        if (value == null) {
            String[] fullName = new String[1];
            Ref[] headRef = new Ref[1];
            items.computeIfAbsent(RepositoryItem.HEAD, key -> this.getHead(repository, fullName, headRef));
            items.computeIfAbsent(RepositoryItem.FULL_BRANCH_NAME, key -> fullName[0]);
            value = items.computeIfAbsent(RepositoryItem.HEAD_REF, key -> headRef[0] == null ? NOTHING : headRef[0]);
        }
        if (value == null || value == NOTHING) {
            return null;
        }
        return (Ref)value;
    }

    public RevCommit getHeadCommit(Repository repository) {
        if (repository == null) {
            return null;
        }
        Map<RepositoryItem, Object> items = this.getItems(repository);
        Object value = items.get((Object)RepositoryItem.HEAD_COMMIT);
        if (value == null) {
            ObjectId headId = this.getHead(repository);
            if (headId != null) {
                try {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (RevWalk w = new RevWalk(repository);){
                        RevCommit commit = w.parseCommit((AnyObjectId)headId);
                        items.put(RepositoryItem.HEAD_COMMIT, commit);
                        return commit;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            items.put(RepositoryItem.HEAD_COMMIT, NOTHING);
            return null;
        }
        if (value == NOTHING) {
            return null;
        }
        return (RevCommit)value;
    }

    public String getFullBranchName(Repository repository) {
        String name;
        if (repository == null) {
            return null;
        }
        Map<RepositoryItem, Object> items = this.getItems(repository);
        Object fullBranchName = items.get((Object)RepositoryItem.FULL_BRANCH_NAME);
        if (fullBranchName == null) {
            String[] fullName = new String[1];
            Ref[] headRef = new Ref[1];
            items.computeIfAbsent(RepositoryItem.HEAD, key -> this.getHead(repository, fullName, headRef));
            fullBranchName = items.computeIfAbsent(RepositoryItem.FULL_BRANCH_NAME, key -> fullName[0]);
            items.computeIfAbsent(RepositoryItem.HEAD_REF, key -> headRef[0] == null ? NOTHING : headRef[0]);
        }
        if ((name = (String)fullBranchName) == null || name.isEmpty()) {
            return null;
        }
        return name;
    }

    @NonNull
    public RepositoryState getRepositoryState(Repository repository) {
        RepositoryState state = (RepositoryState)UnitOfWork.get((Repository)repository, () -> {
            Object value = this.getItems(repository).computeIfAbsent(RepositoryItem.STATE, key -> repository.getRepositoryState());
            return (RepositoryState)value;
        });
        assert (state != null);
        return state;
    }

    private static enum RepositoryItem {
        CONFIG,
        HEAD,
        HEAD_REF,
        HEAD_COMMIT,
        FULL_BRANCH_NAME,
        STATE;

    }
}

