/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.tools.internal.assist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.bindings.Trigger;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.sirius.editor.properties.sections.description.ereferencecustomization.EReferenceCustomizationReferenceNamePropertySection;
import org.eclipse.sirius.editor.tools.internal.assist.EStructuralFeatureContentProposal;
import org.eclipse.sirius.viewpoint.description.EReferenceCustomization;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.keys.IBindingService;

public class EReferenceCustomizationReferenceNameContentProposalProvider
implements IContentProposalProvider {
    private EReferenceCustomization eReferenceCustomization;

    public EReferenceCustomizationReferenceNameContentProposalProvider(EReferenceCustomization eReferenceCustomization) {
        this.eReferenceCustomization = eReferenceCustomization;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList<EStructuralFeatureContentProposal> proposals = new ArrayList<EStructuralFeatureContentProposal>();
        String incompleteText = contents.substring(0, position);
        EList appliedOn = this.eReferenceCustomization.getAppliedOn();
        ArrayList<EObject> styleDescriptionsToCustomize = new ArrayList<EObject>();
        for (EObject eObject : appliedOn) {
            if (!(eObject instanceof StyleDescription) && !(eObject.eContainer() instanceof StyleDescription)) continue;
            styleDescriptionsToCustomize.add(eObject);
        }
        Set<EReference> commonEReferences = this.getCommonEReferenceNames(styleDescriptionsToCustomize);
        for (EReference commonEReference : commonEReferences) {
            if (commonEReference.getName() == null || !commonEReference.getName().startsWith(incompleteText)) continue;
            proposals.add(new EStructuralFeatureContentProposal((EStructuralFeature)commonEReference, position));
        }
        return proposals.toArray(new IContentProposal[0]);
    }

    private Set<EReference> getCommonEReferenceNames(List<EObject> styleDescriptionsToCustomize) {
        LinkedHashSet<EReference> commonEReferences = new LinkedHashSet<EReference>();
        Iterator<EObject> iterator = styleDescriptionsToCustomize.iterator();
        if (iterator.hasNext()) {
            EObject styleDescription = iterator.next();
            commonEReferences.addAll((Collection<EReference>)styleDescription.eClass().getEAllReferences());
            while (iterator.hasNext()) {
                styleDescription = iterator.next();
                Iterator commonEReferencesIterator = commonEReferences.iterator();
                while (commonEReferencesIterator.hasNext()) {
                    EReference eReference = (EReference)commonEReferencesIterator.next();
                    if (this.containsEReferenceOrAnotherWithSameName((List<EReference>)styleDescription.eClass().getEAllReferences(), eReference)) continue;
                    commonEReferencesIterator.remove();
                }
            }
        }
        return commonEReferences;
    }

    private boolean containsEReferenceOrAnotherWithSameName(List<EReference> eAllAttributes, EReference eAttribute) {
        boolean containsEAttributeOrAnotherWithSameName = eAllAttributes.contains(eAttribute);
        if (!containsEAttributeOrAnotherWithSameName) {
            for (EReference currentEAttribute : eAllAttributes) {
                if (!currentEAttribute.getName().equals(eAttribute.getName()) || !this.haveTypeInCommon(currentEAttribute, eAttribute)) continue;
                containsEAttributeOrAnotherWithSameName = true;
                break;
            }
        }
        return containsEAttributeOrAnotherWithSameName;
    }

    private boolean haveTypeInCommon(EReference currentEReference, EReference eReference) {
        boolean haveTypeInCommon = currentEReference.getEType().equals(eReference.getEType()) || currentEReference.getEType() instanceof EClass && eReference.getEType() instanceof EClass && this.haveSuperTypeInCommon((EClass)currentEReference.getEType(), (EClass)eReference.getEType());
        return haveTypeInCommon;
    }

    private boolean haveSuperTypeInCommon(EClass currentEReferenceType, EClass eReferenceType) {
        boolean haveSuperTypeInCommon = currentEReferenceType.getEAllSuperTypes().contains((Object)eReferenceType) || eReferenceType.getEAllSuperTypes().contains((Object)currentEReferenceType);
        return haveSuperTypeInCommon;
    }

    public static void bindCompletionProcessor(final EReferenceCustomizationReferenceNamePropertySection section, Text text) {
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        TriggerSequence[] contentAssistBindings = bindingService.getActiveBindingsFor("org.eclipse.ui.edit.text.contentAssist.proposals");
        if (contentAssistBindings != null && contentAssistBindings.length > 0) {
            KeyStroke keyStroke = EReferenceCustomizationReferenceNameContentProposalProvider.getKeyStroke(contentAssistBindings[0]);
            ContentProposalAdapter adapter = new ContentProposalAdapter((Control)text, (IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new EReferenceCustomizationReferenceNameContentProposalProvider(section.getEReferenceCustomization()), keyStroke, null);
            adapter.addContentProposalListener(new IContentProposalListener2(){

                public void proposalPopupClosed(ContentProposalAdapter arg0) {
                    if (section != null) {
                        section.enableModelUpdating();
                    }
                }

                public void proposalPopupOpened(ContentProposalAdapter arg0) {
                    if (section != null) {
                        section.disableModelUpdating();
                    }
                }
            });
        }
    }

    private static KeyStroke getKeyStroke(TriggerSequence sequence) {
        Trigger[] triggerArray = sequence.getTriggers();
        int n = triggerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Trigger trigger = triggerArray[n2];
            if (trigger instanceof KeyStroke) {
                return (KeyStroke)trigger;
            }
            ++n2;
        }
        return null;
    }
}

