/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.oda.ecore.impl;

import java.util.Map;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.oda.ecore.impl.DataTypes;
import org.eclipse.emf.oda.ecore.impl.Query;

public class ParameterMetaData
implements IParameterMetaData {
    public static final String TARGET_PARAMETER_NAME = "@target";
    public static final String DEFAULT_PARAMETER_VALUE = "<unset>";
    protected final Query query;

    protected ParameterMetaData(Query query) {
        this.query = query;
    }

    public int getParameterCount() throws OdaException {
        return this.query.getSpecification().getParameterValues().size();
    }

    public int getParameterMode(int param) throws OdaException {
        return 1;
    }

    public String getParameterName(int param) throws OdaException {
        if (param < 1 || param > this.getParameterCount()) {
            throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(param)));
        }
        for (Map.Entry entry : this.query.getSpecification().getParameterValues().entrySet()) {
            QuerySpecification.ParameterIdentifier identifier = (QuerySpecification.ParameterIdentifier)entry.getKey();
            if (!identifier.hasId() || !identifier.getParameterId().equals(param)) continue;
            return identifier.getParameterName();
        }
        throw new OdaException((Throwable)new IllegalArgumentException(String.valueOf(param)));
    }

    public Object getParameterDefaultValue(String name) throws OdaException {
        Object defaultValue = this.getParameterClassifier(name).getDefaultValue();
        return defaultValue == null ? DEFAULT_PARAMETER_VALUE : String.valueOf(defaultValue);
    }

    protected EClassifier getParameterClassifier(String name) throws OdaException {
        EClassifier classifier;
        if (TARGET_PARAMETER_NAME.equals(name)) {
            return EcorePackage.Literals.EOBJECT;
        }
        Map<String, EClassifier> variables = this.query.getVariables();
        if (!variables.isEmpty() && (classifier = variables.get(name)) != null) {
            return classifier;
        }
        return EcorePackage.Literals.EJAVA_OBJECT;
    }

    protected EClassifier getParameterClassifier(int param) throws OdaException {
        return this.getParameterClassifier(this.getParameterName(param));
    }

    public int getParameterType(int param) throws OdaException {
        return DataTypes.getType(this.getParameterClassifier(param));
    }

    public String getParameterTypeName(int param) throws OdaException {
        return DataTypes.getTypeName(this.getParameterClassifier(param));
    }

    public int getPrecision(int param) throws OdaException {
        return DataTypes.getPrecision(this.getParameterClassifier(param));
    }

    public int getScale(int param) throws OdaException {
        return DataTypes.getScale(this.getParameterClassifier(param));
    }

    public int isNullable(int param) throws OdaException {
        switch (DataTypes.isNullable(this.getParameterClassifier(param))) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }
}

