/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.factory.bag.primitive.MutableFloatBagFactory;
import org.eclipse.collections.impl.bag.mutable.primitive.FloatHashBag;
import org.eclipse.collections.impl.factory.primitive.FloatBags;
import org.eclipse.collections.impl.utility.Iterate;

public enum MutableFloatBagFactoryImpl implements MutableFloatBagFactory
{
    INSTANCE;


    public MutableFloatBag empty() {
        return new FloatHashBag();
    }

    public MutableFloatBag of() {
        return this.empty();
    }

    public MutableFloatBag with() {
        return this.empty();
    }

    public MutableFloatBag of(float ... items) {
        return this.with(items);
    }

    public MutableFloatBag with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        return FloatHashBag.newBagWith(items);
    }

    public MutableFloatBag ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    public MutableFloatBag withAll(FloatIterable items) {
        return FloatHashBag.newBag(items);
    }

    public MutableFloatBag ofAll(Iterable<Float> iterable) {
        return this.withAll(iterable);
    }

    public MutableFloatBag withAll(Iterable<Float> iterable) {
        return Iterate.collectFloat(iterable, Float::floatValue, FloatBags.mutable.empty());
    }
}

