/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql.ir.util.transform;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrCollection;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.transform.BaseTransform;

public final class ApplyCollectionsTransform
extends BaseTransform {
    private ApplyCollectionsTransform() {
    }

    public static IrBGP apply(IrBGP bgp) {
        if (bgp == null) {
            return null;
        }
        LinkedHashMap<String, Object> firstByS = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> restByS = new LinkedHashMap<String, Object>();
        for (IrNode n : bgp.getLines()) {
            if (!(n instanceof IrStatementPattern)) continue;
            IrStatementPattern sp = (IrStatementPattern)n;
            Var s = sp.getSubject();
            Var p = sp.getPredicate();
            if (s == null || p == null || s.getName() == null || !p.hasValue() || !(p.getValue() instanceof IRI)) continue;
            IRI pred = (IRI)p.getValue();
            if (RDF.FIRST.equals((Object)pred)) {
                firstByS.put(s.getName(), sp);
                continue;
            }
            if (!RDF.REST.equals((Object)pred)) continue;
            restByS.put(s.getName(), sp);
        }
        LinkedHashMap<String, IrCollection> collections = new LinkedHashMap<String, IrCollection>();
        LinkedHashSet<IrStatementPattern> consumed = new LinkedHashSet<IrStatementPattern>();
        for (String head : firstByS.keySet()) {
            boolean ok;
            ArrayList<Var> items;
            block24: {
                Var ro;
                if (head == null || !head.startsWith("_anon_collection_") && !restByS.containsKey(head)) continue;
                items = new ArrayList<Var>();
                LinkedHashSet<String> spine = new LinkedHashSet<String>();
                String cur = head;
                int guard = 0;
                ok = true;
                do {
                    if (++guard > 10000) {
                        ok = false;
                    } else {
                        IrStatementPattern f = (IrStatementPattern)firstByS.get(cur);
                        IrStatementPattern rSp = (IrStatementPattern)restByS.get(cur);
                        if (f == null || rSp == null) {
                            ok = false;
                        } else {
                            spine.add(cur);
                            Var o = f.getObject();
                            if (o != null) {
                                items.add(o);
                            }
                            consumed.add(f);
                            consumed.add(rSp);
                            ro = rSp.getObject();
                            if (ro == null) {
                                ok = false;
                            } else {
                                if (!ro.hasValue()) continue;
                                if (!(ro.getValue() instanceof IRI) || !RDF.NIL.equals((Object)ro.getValue())) {
                                    ok = false;
                                }
                            }
                        }
                    }
                    break block24;
                } while ((cur = ro.getName()) != null && !cur.isEmpty() && !spine.contains(cur));
                ok = false;
            }
            if (!ok || items.isEmpty()) continue;
            IrCollection col = new IrCollection(false);
            for (Var v : items) {
                col.addItem(v);
            }
            collections.put(head, col);
        }
        ArrayList<IrNode> out = new ArrayList<IrNode>();
        for (IrNode n : bgp.getLines()) {
            IrCollection col;
            Var obj;
            IrCollection col2;
            Var subj;
            if (consumed.contains(n)) continue;
            if (n instanceof IrStatementPattern) {
                IrStatementPattern sp = (IrStatementPattern)n;
                subj = sp.getSubject();
                if (subj != null && !subj.hasValue() && subj.getName() != null && collections.containsKey(subj.getName())) {
                    col2 = (IrCollection)collections.get(subj.getName());
                    sp.setSubjectOverride(col2);
                }
                if ((obj = sp.getObject()) != null && !obj.hasValue() && obj.getName() != null && collections.containsKey(obj.getName())) {
                    col = (IrCollection)collections.get(obj.getName());
                    sp.setObjectOverride(col);
                    out.add(sp);
                    continue;
                }
            } else if (n instanceof IrPathTriple) {
                IrPathTriple pt = (IrPathTriple)n;
                subj = pt.getSubject();
                if (subj != null && !subj.hasValue() && subj.getName() != null && collections.containsKey(subj.getName())) {
                    col2 = (IrCollection)collections.get(subj.getName());
                    pt.setSubjectOverride(col2);
                }
                if ((obj = pt.getObject()) != null && !obj.hasValue() && obj.getName() != null && collections.containsKey(obj.getName())) {
                    col = (IrCollection)collections.get(obj.getName());
                    pt.setObjectOverride(col);
                }
            } else if (n instanceof IrBGP || n instanceof IrGraph || n instanceof IrOptional || n instanceof IrUnion || n instanceof IrMinus || n instanceof IrService || n instanceof IrSubSelect) {
                n = n.transformChildren(child -> {
                    if (child instanceof IrBGP) {
                        return ApplyCollectionsTransform.apply((IrBGP)child);
                    }
                    return child;
                });
            }
            out.add(n);
        }
        return BaseTransform.bgpWithLines(bgp, out);
    }
}

