/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.AggregateOperator;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.Avg;
import org.eclipse.rdf4j.query.algebra.BNodeGenerator;
import org.eclipse.rdf4j.query.algebra.BindingSetAssignment;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Coalesce;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Count;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Group;
import org.eclipse.rdf4j.query.algebra.GroupConcat;
import org.eclipse.rdf4j.query.algebra.GroupElem;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.ListMemberOperator;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.Max;
import org.eclipse.rdf4j.query.algebra.Min;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.Sample;
import org.eclipse.rdf4j.query.algebra.Service;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.Sum;
import org.eclipse.rdf4j.query.algebra.TripleRef;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.ZeroLengthPath;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.queryrender.sparql.PrefixIndex;
import org.eclipse.rdf4j.queryrender.sparql.TupleExprIRRenderer;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBGP;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrBind;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrExists;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrFilter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGraph;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrGroupByElem;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrInlineTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrMinus;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNode;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrNot;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOptional;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrOrderSpec;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPathTriple;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrPrinter;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrProjectionItem;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrService;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrStatementPattern;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrSubSelect;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrText;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrUnion;
import org.eclipse.rdf4j.queryrender.sparql.ir.IrValues;
import org.eclipse.rdf4j.queryrender.sparql.ir.util.IrTransforms;
import org.eclipse.rdf4j.queryrender.sparql.util.ExprTextUtils;
import org.eclipse.rdf4j.queryrender.sparql.util.TermRenderer;
import org.eclipse.rdf4j.queryrender.sparql.util.TextEscapes;
import org.eclipse.rdf4j.queryrender.sparql.util.VarUtils;

@Experimental
public class TupleExprToIrConverter {
    private static final int PREC_ALT = 1;
    private static final int PREC_SEQ = 2;
    private static final int PREC_ATOM = 3;
    private final TupleExprIRRenderer r;
    private final TupleExprIRRenderer.Config cfg;
    private final PrefixIndex prefixIndex;
    private static final String FN_NS = "http://www.w3.org/2005/xpath-functions#";
    private static final Map<String, String> BUILTIN;

    private String convertIRIToString(IRI iri) {
        Objects.requireNonNull(this.cfg);
        return TermRenderer.convertIRIToString(iri, this.prefixIndex, true);
    }

    private String convertValueToString(Value val) {
        Objects.requireNonNull(this.cfg);
        return TermRenderer.convertValueToString(val, this.prefixIndex, true);
    }

    private String renderVarOrValue(Var v) {
        if (v == null) {
            return "?_";
        }
        if (v.hasValue()) {
            return this.convertValueToString(v.getValue());
        }
        if (v.isAnonymous() && !v.isConstant()) {
            return "_:" + v.getName();
        }
        return "?" + v.getName();
    }

    private static String mathOp(MathExpr.MathOp op) {
        if (op == MathExpr.MathOp.PLUS) {
            return "+";
        }
        if (op == MathExpr.MathOp.MINUS) {
            return "-";
        }
        try {
            if (op.name().equals("MULTIPLY") || op.name().equals("TIMES")) {
                return "*";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (op == MathExpr.MathOp.DIVIDE) {
            return "/";
        }
        return "?";
    }

    private static String op(Compare.CompareOp op) {
        switch (op) {
            case EQ: {
                return "=";
            }
            case NE: {
                return "!=";
            }
            case LT: {
                return "<";
            }
            case LE: {
                return "<=";
            }
            case GT: {
                return ">";
            }
            case GE: {
                return ">=";
            }
        }
        return "/*?*/";
    }

    private static String asConstraint(String s) {
        String head;
        if (s == null) {
            return "()";
        }
        String t = s.trim();
        if (t.isEmpty()) {
            return "()";
        }
        if (t.charAt(0) == '(' && t.charAt(t.length() - 1) == ')') {
            int depth = 0;
            for (int i = 0; i < t.length(); ++i) {
                char ch = t.charAt(i);
                if (ch == '(') {
                    ++depth;
                } else if (ch == ')') {
                    --depth;
                }
                if (depth == 0 && i < t.length() - 1) break;
                if (i != t.length() - 1 || depth != 0) continue;
                return t;
            }
        }
        if (t.startsWith("EXISTS ") || t.startsWith("NOT EXISTS ")) {
            return t;
        }
        int lpar = t.indexOf(40);
        if (lpar > 0 && t.endsWith(")") && !(head = t.substring(0, lpar).trim()).isEmpty() && head.indexOf(32) < 0) {
            return t;
        }
        return "(" + t + ")";
    }

    private String renderExists(Exists ex) {
        IRBuilder inner = new IRBuilder();
        IrBGP where = inner.build(ex.getSubQuery());
        IrSelect tmp = new IrSelect(false);
        tmp.setWhere(where);
        IrSelect transformed = IrTransforms.transformUsingChildren(tmp, this.r);
        where = transformed.getWhere();
        StringBuilder sb = new StringBuilder(64);
        InlinePrinter p = new InlinePrinter(sb);
        where.print(p);
        String group = sb.toString().replace('\n', ' ').replaceAll("\\s+", " ").trim();
        return "EXISTS " + group;
    }

    private String renderIn(ListMemberOperator in, boolean negate) {
        List<ValueExpr> args = in.getArguments();
        if (args == null || args.isEmpty()) {
            return "/* invalid IN */";
        }
        String left = this.renderExpr(args.get(0));
        String rest = args.stream().skip(1L).map(this::renderExpr).collect(Collectors.joining(", "));
        return "(" + left + (negate ? " NOT IN (" : " IN (") + rest + "))";
    }

    private String renderAggregate(AggregateOperator op) {
        if (op instanceof Count) {
            Count c = (Count)op;
            String inner = c.getArg() == null ? "*" : this.renderExpr(c.getArg());
            return "COUNT(" + (c.isDistinct() && c.getArg() != null ? "DISTINCT " : "") + inner + ")";
        }
        if (op instanceof Sum) {
            Sum a = (Sum)op;
            return "SUM(" + (a.isDistinct() ? "DISTINCT " : "") + this.renderExpr(a.getArg()) + ")";
        }
        if (op instanceof Avg) {
            Avg a = (Avg)op;
            return "AVG(" + (a.isDistinct() ? "DISTINCT " : "") + this.renderExpr(a.getArg()) + ")";
        }
        if (op instanceof Min) {
            Min a = (Min)op;
            return "MIN(" + (a.isDistinct() ? "DISTINCT " : "") + this.renderExpr(a.getArg()) + ")";
        }
        if (op instanceof Max) {
            Max a = (Max)op;
            return "MAX(" + (a.isDistinct() ? "DISTINCT " : "") + this.renderExpr(a.getArg()) + ")";
        }
        if (op instanceof Sample) {
            Sample a = (Sample)op;
            return "SAMPLE(" + (a.isDistinct() ? "DISTINCT " : "") + this.renderExpr(a.getArg()) + ")";
        }
        if (op instanceof GroupConcat) {
            GroupConcat a = (GroupConcat)op;
            StringBuilder sb = new StringBuilder();
            sb.append("GROUP_CONCAT(");
            if (a.isDistinct()) {
                sb.append("DISTINCT ");
            }
            sb.append(this.renderExpr(a.getArg()));
            ValueExpr sepExpr = a.getSeparator();
            String sepLex = this.extractSeparatorLiteral(sepExpr);
            if (sepLex != null) {
                sb.append("; SEPARATOR=").append('\"').append(TextEscapes.escapeLiteral(sepLex)).append('\"');
            }
            sb.append(")");
            return sb.toString();
        }
        return "/* unsupported aggregate */";
    }

    private String extractSeparatorLiteral(ValueExpr expr) {
        Literal lit;
        IRI dt;
        Var var;
        if (expr == null) {
            return null;
        }
        if (expr instanceof ValueConstant) {
            Literal lit2;
            IRI dt2;
            Value v = ((ValueConstant)expr).getValue();
            if (v instanceof Literal && ((dt2 = (lit2 = (Literal)v).getDatatype()) == null || XSD.STRING.equals(dt2))) {
                return lit2.getLabel();
            }
            return null;
        }
        if (expr instanceof Var && (var = (Var)expr).hasValue() && var.getValue() instanceof Literal && ((dt = (lit = (Literal)var.getValue()).getDatatype()) == null || XSD.STRING.equals(dt))) {
            return lit.getLabel();
        }
        return null;
    }

    private String renderExpr(ValueExpr e) {
        if (e == null) {
            return "()";
        }
        if (e instanceof AggregateOperator) {
            return this.renderAggregate((AggregateOperator)e);
        }
        if (e instanceof Not) {
            ValueExpr a = ((Not)e).getArg();
            if (a instanceof Exists) {
                return "NOT " + this.renderExists((Exists)a);
            }
            if (a instanceof ListMemberOperator) {
                return this.renderIn((ListMemberOperator)a, true);
            }
            String inner = ExprTextUtils.stripRedundantOuterParens(this.renderExpr(a));
            return "!" + ExprTextUtils.parenthesizeIfNeededExpr(inner);
        }
        if (e instanceof Var) {
            Var v = (Var)e;
            return v.hasValue() ? this.convertValueToString(v.getValue()) : "?" + v.getName();
        }
        if (e instanceof ValueConstant) {
            return this.convertValueToString(((ValueConstant)e).getValue());
        }
        if (e instanceof If) {
            If iff = (If)e;
            return "IF(" + this.renderExpr(iff.getCondition()) + ", " + this.renderExpr(iff.getResult()) + ", " + this.renderExpr(iff.getAlternative()) + ")";
        }
        if (e instanceof Coalesce) {
            List<ValueExpr> args = ((Coalesce)e).getArguments();
            String s = args.stream().map(this::renderExpr).collect(Collectors.joining(", "));
            return "COALESCE(" + s + ")";
        }
        if (e instanceof IRIFunction) {
            return "IRI(" + this.renderExpr(((IRIFunction)e).getArg()) + ")";
        }
        if (e instanceof IsNumeric) {
            return "isNumeric(" + this.renderExpr(((IsNumeric)e).getArg()) + ")";
        }
        if (e instanceof Exists) {
            return this.renderExists((Exists)e);
        }
        if (e instanceof ListMemberOperator) {
            return this.renderIn((ListMemberOperator)e, false);
        }
        if (e instanceof Str) {
            return "STR(" + this.renderExpr(((Str)e).getArg()) + ")";
        }
        if (e instanceof Datatype) {
            return "DATATYPE(" + this.renderExpr(((Datatype)e).getArg()) + ")";
        }
        if (e instanceof Lang) {
            return "LANG(" + this.renderExpr(((Lang)e).getArg()) + ")";
        }
        if (e instanceof Bound) {
            return "BOUND(" + this.renderExpr(((Bound)e).getArg()) + ")";
        }
        if (e instanceof IsURI) {
            return "isIRI(" + this.renderExpr(((IsURI)e).getArg()) + ")";
        }
        if (e instanceof IsLiteral) {
            return "isLiteral(" + this.renderExpr(((IsLiteral)e).getArg()) + ")";
        }
        if (e instanceof IsBNode) {
            return "isBlank(" + this.renderExpr(((IsBNode)e).getArg()) + ")";
        }
        if (e instanceof MathExpr) {
            Literal l;
            MathExpr me = (MathExpr)e;
            if (me.getOperator() == MathExpr.MathOp.MINUS && me.getLeftArg() instanceof ValueConstant && ((ValueConstant)me.getLeftArg()).getValue() instanceof Literal && "0".equals((l = (Literal)((ValueConstant)me.getLeftArg()).getValue()).getLabel())) {
                return "(-" + this.renderExpr(me.getRightArg()) + ")";
            }
            return "(" + this.renderExpr(me.getLeftArg()) + " " + TupleExprToIrConverter.mathOp(me.getOperator()) + " " + this.renderExpr(me.getRightArg()) + ")";
        }
        if (e instanceof And) {
            And a = (And)e;
            return "(" + this.renderExpr(a.getLeftArg()) + " && " + this.renderExpr(a.getRightArg()) + ")";
        }
        if (e instanceof Or) {
            Or o = (Or)e;
            return "(" + this.renderExpr(o.getLeftArg()) + " || " + this.renderExpr(o.getRightArg()) + ")";
        }
        if (e instanceof Compare) {
            Compare c = (Compare)e;
            return "(" + this.renderExpr(c.getLeftArg()) + " " + TupleExprToIrConverter.op(c.getOperator()) + " " + this.renderExpr(c.getRightArg()) + ")";
        }
        if (e instanceof SameTerm) {
            SameTerm st = (SameTerm)e;
            return "sameTerm(" + this.renderExpr(st.getLeftArg()) + ", " + this.renderExpr(st.getRightArg()) + ")";
        }
        if (e instanceof LangMatches) {
            LangMatches lm = (LangMatches)e;
            return "LANGMATCHES(" + this.renderExpr(lm.getLeftArg()) + ", " + this.renderExpr(lm.getRightArg()) + ")";
        }
        if (e instanceof Regex) {
            Regex rr = (Regex)e;
            String term = this.renderExpr(rr.getArg());
            String patt = this.renderExpr(rr.getPatternArg());
            if (rr.getFlagsArg() != null) {
                return "REGEX(" + term + ", " + patt + ", " + this.renderExpr(rr.getFlagsArg()) + ")";
            }
            return "REGEX(" + term + ", " + patt + ")";
        }
        if (e instanceof FunctionCall) {
            FunctionCall f = (FunctionCall)e;
            String args = f.getArgs().stream().map(this::renderExpr).collect(Collectors.joining(", "));
            String uri = f.getURI();
            String builtin = BUILTIN.get(uri);
            if (builtin == null && uri != null) {
                builtin = BUILTIN.get(uri.toUpperCase(Locale.ROOT));
            }
            if (builtin != null) {
                if ("URI".equals(builtin)) {
                    return "IRI(" + args + ")";
                }
                return builtin + "(" + args + ")";
            }
            if (uri != null) {
                try {
                    IRI iri = SimpleValueFactory.getInstance().createIRI(uri);
                    return this.convertIRIToString(iri) + "(" + args + ")";
                }
                catch (IllegalArgumentException ignore) {
                    return "<" + uri + ">(" + args + ")";
                }
            }
            return "()";
        }
        if (e instanceof BNodeGenerator) {
            BNodeGenerator bg = (BNodeGenerator)e;
            ValueExpr id = bg.getNodeIdExpr();
            if (id == null) {
                return "BNODE()";
            }
            return "BNODE(" + this.renderExpr(id) + ")";
        }
        return "/* unsupported expr: " + e.getClass().getSimpleName() + " */";
    }

    private static boolean isConstIriVar(Var v) {
        return v != null && v.hasValue() && v.getValue() instanceof IRI;
    }

    private static IRI asIri(Var v) {
        return v != null && v.hasValue() && v.getValue() instanceof IRI ? (IRI)v.getValue() : null;
    }

    public TupleExprToIrConverter(TupleExprIRRenderer renderer) {
        this.r = renderer;
        this.cfg = renderer.getConfig();
        this.prefixIndex = new PrefixIndex(this.cfg.prefixes);
    }

    public static IrSelect toIRSelectRaw(TupleExpr tupleExpr, TupleExprIRRenderer r) {
        return TupleExprToIrConverter.toIRSelectRaw(tupleExpr, r, true);
    }

    public static IrSelect toIRSelectRaw(TupleExpr tupleExpr, TupleExprIRRenderer r, boolean applyTransforms) {
        TupleExprToIrConverter conv = new TupleExprToIrConverter(r);
        Normalized n = TupleExprToIrConverter.normalize(tupleExpr, true);
        TupleExprToIrConverter.applyAggregateHoisting(n);
        IrSelect ir = new IrSelect(false);
        ir.setDistinct(n.distinct);
        ir.setReduced(n.reduced && !n.distinct);
        ir.setLimit(n.limit);
        ir.setOffset(n.offset);
        if (n.projection != null && n.projection.getProjectionElemList() != null && !n.projection.getProjectionElemList().getElements().isEmpty()) {
            for (ProjectionElem projectionElem : n.projection.getProjectionElemList().getElements()) {
                String alias = projectionElem.getProjectionAlias().orElse(projectionElem.getName());
                ValueExpr expr = n.selectAssignments.get(alias);
                if (expr != null) {
                    ir.getProjection().add(new IrProjectionItem(conv.renderExpr(expr), alias));
                    continue;
                }
                ir.getProjection().add(new IrProjectionItem(null, alias));
            }
        } else if (!n.selectAssignments.isEmpty()) {
            if (!n.groupByTerms.isEmpty()) {
                for (GroupByTerm groupByTerm : n.groupByTerms) {
                    ir.getProjection().add(new IrProjectionItem(null, groupByTerm.var));
                }
            } else {
                for (String string : n.syntheticProjectVars) {
                    ir.getProjection().add(new IrProjectionItem(null, string));
                }
            }
            for (Map.Entry entry : n.selectAssignments.entrySet()) {
                ir.getProjection().add(new IrProjectionItem(conv.renderExpr((ValueExpr)entry.getValue()), (String)entry.getKey()));
            }
        }
        IRBuilder builder = new TupleExprToIrConverter(r).new IRBuilder();
        ir.setWhere(builder.build(n.where));
        if (applyTransforms) {
            IrNode only;
            IrSelect irSelect = IrTransforms.transformUsingChildren(ir, r);
            ir.setWhere(irSelect.getWhere());
            if (ir.getWhere() != null && ir.getWhere().getLines() != null && ir.getWhere().getLines().size() == 1 && TupleExprToIrConverter.rootHasExplicitScope(n.where) && ((only = ir.getWhere().getLines().get(0)) instanceof IrStatementPattern || only instanceof IrPathTriple || only instanceof IrGraph || only instanceof IrSubSelect)) {
                ir.getWhere().setNewScope(true);
            }
        }
        if (!n.extensionAssignments.isEmpty() && ir.getWhere() != null) {
            IrBGP irBGP = ir.getWhere();
            LinkedHashMap<String, ValueExpr> groupAliasExprByVar = new LinkedHashMap<String, ValueExpr>();
            for (GroupByTerm t : n.groupByTerms) {
                if (t.expr == null) continue;
                groupAliasExprByVar.put(t.var, t.expr);
            }
            ArrayList<IrBind> prefixConst = new ArrayList<IrBind>();
            ArrayList<IrBind> suffixDependent = new ArrayList<IrBind>();
            for (Map.Entry<String, ValueExpr> e : n.extensionAssignments.entrySet()) {
                ValueExpr expr = e.getValue();
                if (expr instanceof AggregateOperator || groupAliasExprByVar.containsKey(e.getKey()) && ((ValueExpr)groupAliasExprByVar.get(e.getKey())).equals(expr)) continue;
                Set<String> deps = TupleExprToIrConverter.freeVars(expr);
                IrBind bind = new IrBind(conv.renderExpr(expr), e.getKey(), false);
                if (deps.isEmpty()) {
                    prefixConst.add(bind);
                    continue;
                }
                suffixDependent.add(bind);
            }
            if (!prefixConst.isEmpty() || !suffixDependent.isEmpty()) {
                IrBGP combined = new IrBGP(irBGP.isNewScope());
                combined.getLines().addAll(prefixConst);
                if (irBGP.getLines() != null) {
                    combined.getLines().addAll(irBGP.getLines());
                }
                combined.getLines().addAll(suffixDependent);
                ir.setWhere(combined);
            }
        }
        for (GroupByTerm t : n.groupByTerms) {
            ir.getGroupBy().add(new IrGroupByElem(t.expr == null ? null : conv.renderExpr(t.expr), t.var));
        }
        for (ValueExpr cond : n.havingConditions) {
            ir.getHaving().add(ExprTextUtils.stripRedundantOuterParens(conv.renderExprForHaving(cond, n)));
        }
        for (OrderElem oe : n.orderBy) {
            ir.getOrderBy().add(new IrOrderSpec(conv.renderExpr(oe.getExpr()), oe.isAscending()));
        }
        return ir;
    }

    private static Normalized normalize(TupleExpr root, boolean peelScopedWrappers) {
        boolean changed;
        Normalized n = new Normalized();
        TupleExpr cur = root;
        do {
            changed = false;
            if (cur instanceof QueryRoot) {
                cur = ((QueryRoot)cur).getArg();
                changed = true;
                continue;
            }
            if (cur instanceof Slice) {
                Slice s = (Slice)cur;
                if (s.isVariableScopeChange() && !peelScopedWrappers) break;
                n.limit = s.getLimit();
                n.offset = s.getOffset();
                cur = s.getArg();
                changed = true;
                continue;
            }
            if (cur instanceof Distinct) {
                Distinct d = (Distinct)cur;
                if (d.isVariableScopeChange() && !peelScopedWrappers) break;
                n.distinct = true;
                cur = d.getArg();
                changed = true;
                continue;
            }
            if (cur instanceof Reduced) {
                Reduced r = (Reduced)cur;
                if (r.isVariableScopeChange() && !peelScopedWrappers) break;
                n.reduced = true;
                cur = r.getArg();
                changed = true;
                continue;
            }
            if (cur instanceof Order) {
                Order o = (Order)cur;
                if (o.isVariableScopeChange() && !peelScopedWrappers) break;
                n.orderBy.addAll(o.getElements());
                cur = o.getArg();
                changed = true;
                continue;
            }
            if (cur instanceof Filter) {
                Filter f = (Filter)cur;
                TupleExpr arg = f.getArg();
                Set<String> fv = TupleExprToIrConverter.freeVars(f.getCondition());
                boolean hasHavingMarker = false;
                for (String vn : fv) {
                    if (!TupleExprToIrConverter.isAnonHavingName(vn)) continue;
                    hasHavingMarker = true;
                    break;
                }
                if (hasHavingMarker) {
                    n.havingConditions.add(f.getCondition());
                    cur = f.getArg();
                    changed = true;
                    continue;
                }
                if (arg instanceof Group) {
                    Group g = (Group)arg;
                    n.hadExplicitGroup = true;
                    n.groupByVarNames.clear();
                    n.groupByVarNames.addAll(new LinkedHashSet<String>(g.getGroupBindingNames()));
                    TupleExpr afterGroup = g.getArg();
                    LinkedHashMap groupAliases = new LinkedHashMap();
                    while (afterGroup instanceof Extension) {
                        Iterator<GroupElem> ext = (Extension)afterGroup;
                        for (ExtensionElem ee : ((Extension)((Object)ext)).getElements()) {
                            if (n.groupByVarNames.contains(ee.getName())) {
                                groupAliases.put(ee.getName(), ee.getExpr());
                            }
                            n.extensionAssignments.putIfAbsent(ee.getName(), ee.getExpr());
                            n.extensionOutputNames.add(ee.getName());
                        }
                        afterGroup = ((UnaryTupleOperator)((Object)ext)).getArg();
                    }
                    n.groupByTerms.clear();
                    for (String nm : n.groupByVarNames) {
                        n.groupByTerms.add(new GroupByTerm(nm, groupAliases.getOrDefault(nm, null)));
                    }
                    for (GroupElem ge : g.getGroupElements()) {
                        n.selectAssignments.putIfAbsent(ge.getName(), ge.getOperator());
                        n.aggregateOutputNames.add(ge.getName());
                    }
                    ValueExpr cond = f.getCondition();
                    if (TupleExprToIrConverter.containsAggregate(cond) || TupleExprToIrConverter.isHavingCandidate(cond, n.groupByVarNames, n.aggregateOutputNames)) {
                        n.havingConditions.add(cond);
                        cur = afterGroup;
                        changed = true;
                        continue;
                    }
                    cur = new Filter(afterGroup, cond);
                    changed = true;
                    continue;
                }
                if (TupleExprToIrConverter.containsAggregate(f.getCondition())) {
                    n.havingConditions.add(f.getCondition());
                    cur = f.getArg();
                    changed = true;
                    continue;
                }
            }
            if (cur instanceof Projection) {
                if (n.projection != null) break;
                n.projection = (Projection)cur;
                cur = n.projection.getArg();
                changed = true;
                continue;
            }
            if (cur instanceof Extension) {
                if (((Extension)cur).getArg() instanceof Extension) break;
                Extension ext = (Extension)cur;
                for (ExtensionElem ee : ext.getElements()) {
                    n.selectAssignments.put(ee.getName(), ee.getExpr());
                    n.extensionOutputNames.add(ee.getName());
                    n.extensionAssignments.putIfAbsent(ee.getName(), ee.getExpr());
                }
                cur = ext.getArg();
                changed = true;
                continue;
            }
            if (!(cur instanceof Group)) continue;
            Group g = (Group)cur;
            n.hadExplicitGroup = true;
            n.groupByVarNames.clear();
            n.groupByVarNames.addAll(new LinkedHashSet<String>(g.getGroupBindingNames()));
            TupleExpr afterGroup = g.getArg();
            LinkedHashMap<String, ValueExpr> groupAliases = new LinkedHashMap<String, ValueExpr>();
            while (afterGroup instanceof Extension) {
                Extension ext = (Extension)afterGroup;
                for (ExtensionElem ee : ext.getElements()) {
                    if (n.groupByVarNames.contains(ee.getName())) {
                        groupAliases.put(ee.getName(), ee.getExpr());
                    }
                    n.extensionAssignments.putIfAbsent(ee.getName(), ee.getExpr());
                    n.extensionOutputNames.add(ee.getName());
                }
                afterGroup = ext.getArg();
            }
            n.groupByTerms.clear();
            for (String nm : n.groupByVarNames) {
                n.groupByTerms.add(new GroupByTerm(nm, groupAliases.getOrDefault(nm, null)));
            }
            for (GroupElem ge : g.getGroupElements()) {
                n.selectAssignments.putIfAbsent(ge.getName(), ge.getOperator());
                n.aggregateOutputNames.add(ge.getName());
            }
            cur = afterGroup;
            changed = true;
        } while (changed);
        n.where = cur;
        return n;
    }

    private static boolean isHavingCandidate(ValueExpr cond, Set<String> groupVars, Set<String> aggregateAliasVars) {
        Set<String> free = TupleExprToIrConverter.freeVars(cond);
        if (free.isEmpty()) {
            return true;
        }
        for (String v : free) {
            if (groupVars.contains(v) || aggregateAliasVars.contains(v)) continue;
            return false;
        }
        return true;
    }

    private static boolean containsExtension(TupleExpr e) {
        if (e == null) {
            return false;
        }
        class Flag
        extends AbstractQueryModelVisitor<RuntimeException> {
            boolean found = false;

            Flag() {
            }

            @Override
            public void meet(Extension node) {
                this.found = true;
            }

            @Override
            protected void meetNode(QueryModelNode node) {
                if (!this.found) {
                    super.meetNode(node);
                }
            }
        }
        Flag f = new Flag();
        e.visit(f);
        return f.found;
    }

    private static boolean containsExtensionShallow(TupleExpr e) {
        if (e == null) {
            return false;
        }
        class Flag
        extends AbstractQueryModelVisitor<RuntimeException> {
            boolean found = false;

            Flag() {
            }

            @Override
            public void meet(Extension node) {
                this.found = true;
            }

            @Override
            public void meet(Projection node) {
            }

            @Override
            protected void meetNode(QueryModelNode node) {
                if (!this.found) {
                    super.meetNode(node);
                }
            }
        }
        Flag f = new Flag();
        e.visit(f);
        return f.found;
    }

    private static void applyAggregateHoisting(Normalized n) {
        AggregateScan scan = new AggregateScan();
        if (n.where != null) {
            n.where.visit(scan);
        }
        if (!scan.hoisted.isEmpty()) {
            for (Map.Entry<String, ValueExpr> entry : scan.hoisted.entrySet()) {
                n.selectAssignments.putIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        boolean hasAggregates = !scan.hoisted.isEmpty();
        for (Map.Entry<String, ValueExpr> entry : n.selectAssignments.entrySet()) {
            if (!(entry.getValue() instanceof AggregateOperator)) continue;
            hasAggregates = true;
            scan.aggregateOutputNames.add(entry.getKey());
            TupleExprToIrConverter.collectVarNames(entry.getValue(), scan.aggregateArgVars);
        }
        if (!hasAggregates) {
            return;
        }
        if (n.hadExplicitGroup) {
            return;
        }
        if (n.groupByTerms.isEmpty() && n.projection != null && n.projection.getProjectionElemList() != null) {
            ArrayList<GroupByTerm> arrayList = new ArrayList<GroupByTerm>();
            for (ProjectionElem pe : n.projection.getProjectionElemList().getElements()) {
                String name = pe.getProjectionAlias().orElse(pe.getName());
                if (name == null || name.isEmpty() || n.selectAssignments.containsKey(name)) continue;
                arrayList.add(new GroupByTerm(name, null));
            }
            if (!arrayList.isEmpty()) {
                n.groupByTerms.addAll(arrayList);
                return;
            }
        }
        if (n.groupByTerms.isEmpty()) {
            List chosen;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(scan.varCounts.keySet());
            linkedHashSet.removeAll(scan.aggregateOutputNames);
            linkedHashSet.removeAll(scan.aggregateArgVars);
            List list = linkedHashSet.stream().filter(v -> scan.varCounts.getOrDefault(v, 0) > 1).collect(Collectors.toList());
            if (!list.isEmpty()) {
                chosen = list;
            } else {
                chosen = new ArrayList(1);
                if (!linkedHashSet.isEmpty()) {
                    linkedHashSet.stream().min((a, b) -> {
                        int bp;
                        int bo;
                        int bs;
                        int as = scan.subjCounts.getOrDefault(a, 0);
                        if (as != (bs = scan.subjCounts.getOrDefault(b, 0).intValue())) {
                            return Integer.compare(bs, as);
                        }
                        int ao = scan.objCounts.getOrDefault(a, 0);
                        if (ao != (bo = scan.objCounts.getOrDefault(b, 0).intValue())) {
                            return Integer.compare(bo, ao);
                        }
                        int ap = scan.predCounts.getOrDefault(a, 0);
                        if (ap != (bp = scan.predCounts.getOrDefault(b, 0).intValue())) {
                            return Integer.compare(bp, ap);
                        }
                        return a.compareTo((String)b);
                    }).ifPresent(chosen::add);
                }
            }
            n.syntheticProjectVars.clear();
            n.syntheticProjectVars.addAll(chosen);
            if (n.projection == null || n.projection.getProjectionElemList().getElements().isEmpty()) {
                n.groupByTerms.clear();
                for (String v2 : n.syntheticProjectVars) {
                    n.groupByTerms.add(new GroupByTerm(v2, null));
                }
            }
        }
    }

    private static boolean containsAggregate(ValueExpr e) {
        if (e == null) {
            return false;
        }
        if (e instanceof AggregateOperator) {
            return true;
        }
        if (e instanceof Not) {
            return TupleExprToIrConverter.containsAggregate(((Not)e).getArg());
        }
        if (e instanceof Bound) {
            return TupleExprToIrConverter.containsAggregate(((Bound)e).getArg());
        }
        if (e instanceof Str) {
            return TupleExprToIrConverter.containsAggregate(((Str)e).getArg());
        }
        if (e instanceof Datatype) {
            return TupleExprToIrConverter.containsAggregate(((Datatype)e).getArg());
        }
        if (e instanceof Lang) {
            return TupleExprToIrConverter.containsAggregate(((Lang)e).getArg());
        }
        if (e instanceof IRIFunction) {
            return TupleExprToIrConverter.containsAggregate(((IRIFunction)e).getArg());
        }
        if (e instanceof If) {
            If iff = (If)e;
            return TupleExprToIrConverter.containsAggregate(iff.getCondition()) || TupleExprToIrConverter.containsAggregate(iff.getResult()) || TupleExprToIrConverter.containsAggregate(iff.getAlternative());
        }
        if (e instanceof Coalesce) {
            for (ValueExpr a : ((Coalesce)e).getArguments()) {
                if (!TupleExprToIrConverter.containsAggregate(a)) continue;
                return true;
            }
            return false;
        }
        if (e instanceof FunctionCall) {
            for (ValueExpr a : ((FunctionCall)e).getArgs()) {
                if (!TupleExprToIrConverter.containsAggregate(a)) continue;
                return true;
            }
            return false;
        }
        if (e instanceof And) {
            return TupleExprToIrConverter.containsAggregate(((And)e).getLeftArg()) || TupleExprToIrConverter.containsAggregate(((And)e).getRightArg());
        }
        if (e instanceof Or) {
            return TupleExprToIrConverter.containsAggregate(((Or)e).getLeftArg()) || TupleExprToIrConverter.containsAggregate(((Or)e).getRightArg());
        }
        if (e instanceof Compare) {
            return TupleExprToIrConverter.containsAggregate(((Compare)e).getLeftArg()) || TupleExprToIrConverter.containsAggregate(((Compare)e).getRightArg());
        }
        if (e instanceof SameTerm) {
            return TupleExprToIrConverter.containsAggregate(((SameTerm)e).getLeftArg()) || TupleExprToIrConverter.containsAggregate(((SameTerm)e).getRightArg());
        }
        if (e instanceof LangMatches) {
            return TupleExprToIrConverter.containsAggregate(((LangMatches)e).getLeftArg()) || TupleExprToIrConverter.containsAggregate(((LangMatches)e).getRightArg());
        }
        if (e instanceof Regex) {
            Regex r = (Regex)e;
            return TupleExprToIrConverter.containsAggregate(r.getArg()) || TupleExprToIrConverter.containsAggregate(r.getPatternArg()) || r.getFlagsArg() != null && TupleExprToIrConverter.containsAggregate(r.getFlagsArg());
        }
        if (e instanceof ListMemberOperator) {
            for (ValueExpr a : ((ListMemberOperator)e).getArguments()) {
                if (!TupleExprToIrConverter.containsAggregate(a)) continue;
                return true;
            }
            return false;
        }
        if (e instanceof MathExpr) {
            return TupleExprToIrConverter.containsAggregate(((MathExpr)e).getLeftArg()) || TupleExprToIrConverter.containsAggregate(((MathExpr)e).getRightArg());
        }
        return false;
    }

    private static Set<String> freeVars(ValueExpr e) {
        LinkedHashSet<String> out = new LinkedHashSet<String>();
        TupleExprToIrConverter.collectVarNames(e, out);
        return out;
    }

    private static void collectVarNames(ValueExpr e, Set<String> acc) {
        List<ValueExpr> args;
        if (e == null) {
            return;
        }
        if (e instanceof Var) {
            Var v = (Var)e;
            if (!v.hasValue() && v.getName() != null && !v.getName().isEmpty()) {
                acc.add(v.getName());
            }
            return;
        }
        if (e instanceof ValueConstant) {
            return;
        }
        if (e instanceof Not) {
            TupleExprToIrConverter.collectVarNames(((Not)e).getArg(), acc);
            return;
        }
        if (e instanceof Bound) {
            TupleExprToIrConverter.collectVarNames(((Bound)e).getArg(), acc);
            return;
        }
        if (e instanceof Str) {
            TupleExprToIrConverter.collectVarNames(((Str)e).getArg(), acc);
            return;
        }
        if (e instanceof Datatype) {
            TupleExprToIrConverter.collectVarNames(((Datatype)e).getArg(), acc);
            return;
        }
        if (e instanceof Lang) {
            TupleExprToIrConverter.collectVarNames(((Lang)e).getArg(), acc);
            return;
        }
        if (e instanceof IsURI) {
            TupleExprToIrConverter.collectVarNames(((IsURI)e).getArg(), acc);
            return;
        }
        if (e instanceof IsLiteral) {
            TupleExprToIrConverter.collectVarNames(((IsLiteral)e).getArg(), acc);
            return;
        }
        if (e instanceof IsBNode) {
            TupleExprToIrConverter.collectVarNames(((IsBNode)e).getArg(), acc);
            return;
        }
        if (e instanceof IsNumeric) {
            TupleExprToIrConverter.collectVarNames(((IsNumeric)e).getArg(), acc);
            return;
        }
        if (e instanceof IRIFunction) {
            TupleExprToIrConverter.collectVarNames(((IRIFunction)e).getArg(), acc);
            return;
        }
        if (e instanceof And) {
            TupleExprToIrConverter.collectVarNames(((And)e).getLeftArg(), acc);
            TupleExprToIrConverter.collectVarNames(((And)e).getRightArg(), acc);
            return;
        }
        if (e instanceof Or) {
            TupleExprToIrConverter.collectVarNames(((Or)e).getLeftArg(), acc);
            TupleExprToIrConverter.collectVarNames(((Or)e).getRightArg(), acc);
            return;
        }
        if (e instanceof Compare) {
            TupleExprToIrConverter.collectVarNames(((Compare)e).getLeftArg(), acc);
            TupleExprToIrConverter.collectVarNames(((Compare)e).getRightArg(), acc);
            return;
        }
        if (e instanceof SameTerm) {
            TupleExprToIrConverter.collectVarNames(((SameTerm)e).getLeftArg(), acc);
            TupleExprToIrConverter.collectVarNames(((SameTerm)e).getRightArg(), acc);
            return;
        }
        if (e instanceof LangMatches) {
            TupleExprToIrConverter.collectVarNames(((LangMatches)e).getLeftArg(), acc);
            TupleExprToIrConverter.collectVarNames(((LangMatches)e).getRightArg(), acc);
            return;
        }
        if (e instanceof Regex) {
            Regex rx = (Regex)e;
            TupleExprToIrConverter.collectVarNames(rx.getArg(), acc);
            TupleExprToIrConverter.collectVarNames(rx.getPatternArg(), acc);
            if (rx.getFlagsArg() != null) {
                TupleExprToIrConverter.collectVarNames(rx.getFlagsArg(), acc);
            }
            return;
        }
        if (e instanceof FunctionCall) {
            for (ValueExpr valueExpr : ((FunctionCall)e).getArgs()) {
                TupleExprToIrConverter.collectVarNames(valueExpr, acc);
            }
            return;
        }
        if (e instanceof ListMemberOperator && (args = ((ListMemberOperator)e).getArguments()) != null) {
            for (ValueExpr a : args) {
                TupleExprToIrConverter.collectVarNames(a, acc);
            }
        }
        if (e instanceof MathExpr) {
            TupleExprToIrConverter.collectVarNames(((MathExpr)e).getLeftArg(), acc);
            TupleExprToIrConverter.collectVarNames(((MathExpr)e).getRightArg(), acc);
        }
        if (e instanceof If) {
            If iff = (If)e;
            TupleExprToIrConverter.collectVarNames(iff.getCondition(), acc);
            TupleExprToIrConverter.collectVarNames(iff.getResult(), acc);
            TupleExprToIrConverter.collectVarNames(iff.getAlternative(), acc);
        }
        if (e instanceof Coalesce) {
            for (ValueExpr valueExpr : ((Coalesce)e).getArguments()) {
                TupleExprToIrConverter.collectVarNames(valueExpr, acc);
            }
        }
    }

    private static void flattenJoin(TupleExpr expr, List<TupleExpr> out) {
        if (expr instanceof Join) {
            Join j = (Join)expr;
            TupleExprToIrConverter.flattenJoin(j.getLeftArg(), out);
            TupleExprToIrConverter.flattenJoin(j.getRightArg(), out);
        } else {
            out.add(expr);
        }
    }

    private static void flattenUnion(TupleExpr e, List<TupleExpr> out) {
        if (e instanceof Union) {
            Union u = (Union)e;
            if (u.isVariableScopeChange()) {
                if (u.getLeftArg() instanceof Union && ((Union)u.getLeftArg()).isVariableScopeChange()) {
                    out.add(u.getLeftArg());
                } else if (u.getLeftArg() instanceof Union && !((Union)u.getLeftArg()).isVariableScopeChange()) {
                    out.add(u.getLeftArg());
                } else {
                    TupleExprToIrConverter.flattenUnion(u.getLeftArg(), out);
                }
                if (u.getRightArg() instanceof Union && ((Union)u.getRightArg()).isVariableScopeChange()) {
                    out.add(u.getRightArg());
                } else if (u.getRightArg() instanceof Union && !((Union)u.getRightArg()).isVariableScopeChange()) {
                    out.add(u.getRightArg());
                } else {
                    TupleExprToIrConverter.flattenUnion(u.getRightArg(), out);
                }
            } else {
                TupleExprToIrConverter.flattenUnion(u.getLeftArg(), out);
                TupleExprToIrConverter.flattenUnion(u.getRightArg(), out);
            }
        } else {
            out.add(e);
        }
    }

    private static boolean sameVar(Var a, Var b) {
        return VarUtils.sameVar(a, b);
    }

    private static String freeVarName(Var v) {
        if (v == null || v.hasValue()) {
            return null;
        }
        String n = v.getName();
        return n == null || n.isEmpty() ? null : n;
    }

    private static Var getContextVarSafe(StatementPattern sp) {
        try {
            Method m = StatementPattern.class.getMethod("getContextVar", new Class[0]);
            Object ctx = m.invoke((Object)sp, new Object[0]);
            if (ctx instanceof Var) {
                return (Var)ctx;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static Var getContextVarSafe(Object node) {
        if (node instanceof StatementPattern) {
            return TupleExprToIrConverter.getContextVarSafe((StatementPattern)node);
        }
        try {
            Method m = node.getClass().getMethod("getContextVar", new Class[0]);
            Object ctx = m.invoke(node, new Object[0]);
            if (ctx instanceof Var) {
                return (Var)ctx;
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static String quantifier(long min, long max) {
        boolean unbounded;
        boolean bl = unbounded = max < 0L || max == Integer.MAX_VALUE;
        if (min == 0L && unbounded) {
            return "*";
        }
        if (min == 1L && unbounded) {
            return "+";
        }
        if (min == 0L && max == 1L) {
            return "?";
        }
        if (unbounded) {
            return "{" + min + ",}";
        }
        if (min == max) {
            return "{" + min + "}";
        }
        return "{" + min + "," + max + "}";
    }

    private static boolean isAnonPathVar(Var v) {
        return VarUtils.isAnonPathVar(v);
    }

    private static boolean isAnonHavingName(String name) {
        return name != null && name.startsWith("_anon_having_");
    }

    private String renderExprForHaving(ValueExpr e, Normalized n) {
        return this.renderExprWithSubstitution(e, n == null ? null : n.selectAssignments);
    }

    private String renderExprWithSubstitution(ValueExpr e, Map<String, ValueExpr> subs) {
        if (e == null) {
            return "()";
        }
        if (e instanceof Var) {
            ValueExpr repl;
            Var v = (Var)e;
            if (!v.hasValue() && v.getName() != null && TupleExprToIrConverter.isAnonHavingName(v.getName()) && subs != null && (repl = subs.get(v.getName())) != null) {
                return this.renderExpr(repl);
            }
            return v.hasValue() ? this.convertValueToString(v.getValue()) : "?" + v.getName();
        }
        if (e instanceof Not) {
            String inner = ExprTextUtils.stripRedundantOuterParens(this.renderExprWithSubstitution(((Not)e).getArg(), subs));
            return "!" + ExprTextUtils.parenthesizeIfNeededSimple(inner);
        }
        if (e instanceof And) {
            And a = (And)e;
            return "(" + this.renderExprWithSubstitution(a.getLeftArg(), subs) + " && " + this.renderExprWithSubstitution(a.getRightArg(), subs) + ")";
        }
        if (e instanceof Or) {
            Or o = (Or)e;
            return "(" + this.renderExprWithSubstitution(o.getLeftArg(), subs) + " || " + this.renderExprWithSubstitution(o.getRightArg(), subs) + ")";
        }
        if (e instanceof Compare) {
            Compare c = (Compare)e;
            return "(" + this.renderExprWithSubstitution(c.getLeftArg(), subs) + " " + TupleExprToIrConverter.op(c.getOperator()) + " " + this.renderExprWithSubstitution(c.getRightArg(), subs) + ")";
        }
        if (e instanceof SameTerm) {
            SameTerm st = (SameTerm)e;
            return "sameTerm(" + this.renderExprWithSubstitution(st.getLeftArg(), subs) + ", " + this.renderExprWithSubstitution(st.getRightArg(), subs) + ")";
        }
        return this.renderExpr(e);
    }

    private String buildPathExprForArbitraryLengthPath(ArbitraryLengthPath p) {
        PathNode inner = this.parseAPathInner(p.getPathExpression(), p.getSubjectVar(), p.getObjectVar());
        if (inner == null) {
            throw new IllegalStateException("Failed to parse ArbitraryLengthPath inner expression: " + String.valueOf(p.getPathExpression()));
        }
        long min = p.getMinLength();
        long max = -1L;
        PathQuant q = new PathQuant(inner, min, -1L);
        return q.prec() < 2 ? "(" + q.render() + ")" : q.render();
    }

    private static void collectFreeVars(TupleExpr e, final Set<String> out) {
        if (e == null) {
            return;
        }
        e.visit(new AbstractQueryModelVisitor<RuntimeException>(){

            private void add(Var v) {
                String n = TupleExprToIrConverter.freeVarName(v);
                if (n != null) {
                    out.add(n);
                }
            }

            @Override
            public void meet(StatementPattern sp) {
                this.add(sp.getSubjectVar());
                this.add(sp.getPredicateVar());
                this.add(sp.getObjectVar());
                this.add(TupleExprToIrConverter.getContextVarSafe(sp));
            }

            @Override
            public void meet(Filter f) {
                if (f.getCondition() != null) {
                    TupleExprToIrConverter.collectVarNames(f.getCondition(), out);
                }
                f.getArg().visit(this);
            }

            @Override
            public void meet(LeftJoin lj) {
                lj.getLeftArg().visit(this);
                lj.getRightArg().visit(this);
                if (lj.getCondition() != null) {
                    TupleExprToIrConverter.collectVarNames(lj.getCondition(), out);
                }
            }

            @Override
            public void meet(Join j) {
                j.getLeftArg().visit(this);
                j.getRightArg().visit(this);
            }

            @Override
            public void meet(Union u) {
                u.getLeftArg().visit(this);
                u.getRightArg().visit(this);
            }

            @Override
            public void meet(Extension ext) {
                for (ExtensionElem ee : ext.getElements()) {
                    TupleExprToIrConverter.collectVarNames(ee.getExpr(), out);
                }
                ext.getArg().visit(this);
            }

            @Override
            public void meet(ArbitraryLengthPath p) {
                this.add(p.getSubjectVar());
                this.add(p.getObjectVar());
                this.add(TupleExprToIrConverter.getContextVarSafe(p));
            }
        });
    }

    public IrSelect toIRSelect(TupleExpr tupleExpr) {
        Normalized n = TupleExprToIrConverter.normalize(tupleExpr, false);
        TupleExprToIrConverter.applyAggregateHoisting(n);
        boolean whereHasExtensions = TupleExprToIrConverter.containsExtensionShallow(n.where);
        IrSelect ir = new IrSelect(false);
        ir.setDistinct(n.distinct);
        ir.setReduced(n.reduced && !n.distinct);
        ir.setLimit(n.limit);
        ir.setOffset(n.offset);
        if (n.projection != null && n.projection.getProjectionElemList() != null && !n.projection.getProjectionElemList().getElements().isEmpty()) {
            for (ProjectionElem projectionElem : n.projection.getProjectionElemList().getElements()) {
                String alias = projectionElem.getProjectionAlias().orElse(projectionElem.getName());
                ExtensionElem src = projectionElem.getSourceExpression();
                ValueExpr expr = src != null ? src.getExpr() : n.selectAssignments.get(alias);
                boolean renderExprText = expr != null;
                ir.getProjection().add(new IrProjectionItem(renderExprText ? this.renderExpr(expr) : null, alias));
            }
        } else if (!n.selectAssignments.isEmpty()) {
            if (!n.groupByTerms.isEmpty()) {
                for (GroupByTerm groupByTerm : n.groupByTerms) {
                    ir.getProjection().add(new IrProjectionItem(null, groupByTerm.var));
                }
            } else {
                for (String string : n.syntheticProjectVars) {
                    ir.getProjection().add(new IrProjectionItem(null, string));
                }
            }
            for (Map.Entry entry : n.selectAssignments.entrySet()) {
                ir.getProjection().add(new IrProjectionItem(this.renderExpr((ValueExpr)entry.getValue()), (String)entry.getKey()));
            }
        }
        IRBuilder builder = new IRBuilder();
        ir.setWhere(builder.build(n.where));
        if (!n.extensionAssignments.isEmpty() && ir.getWhere() != null) {
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            ir.getProjection().forEach(p -> {
                if (p.getExprText() != null && p.getVarName() != null) {
                    alreadyRendered.add(p.getVarName());
                }
            });
            LinkedHashMap<String, ValueExpr> groupAliasExprByVar = new LinkedHashMap<String, ValueExpr>();
            for (GroupByTerm t : n.groupByTerms) {
                if (t.expr == null) continue;
                groupAliasExprByVar.put(t.var, t.expr);
            }
            ArrayList<IrBind> prefixConst = new ArrayList<IrBind>();
            ArrayList<IrBind> suffixDependent = new ArrayList<IrBind>();
            for (Map.Entry<String, ValueExpr> e : n.extensionAssignments.entrySet()) {
                ValueExpr expr = e.getValue();
                if (expr instanceof AggregateOperator || linkedHashSet.contains(e.getKey()) || groupAliasExprByVar.containsKey(e.getKey()) && ((ValueExpr)groupAliasExprByVar.get(e.getKey())).equals(expr)) continue;
                Set<String> deps = TupleExprToIrConverter.freeVars(expr);
                IrBind bind = new IrBind(this.renderExpr(expr), e.getKey(), false);
                if (deps.isEmpty()) {
                    prefixConst.add(bind);
                    continue;
                }
                suffixDependent.add(bind);
            }
            if (!prefixConst.isEmpty() || !suffixDependent.isEmpty()) {
                IrBGP whereBgp = ir.getWhere();
                IrBGP combined = new IrBGP(whereBgp.isNewScope());
                combined.getLines().addAll(prefixConst);
                if (whereBgp.getLines() != null) {
                    combined.getLines().addAll(whereBgp.getLines());
                }
                combined.getLines().addAll(suffixDependent);
                ir.setWhere(combined);
            }
        }
        for (GroupByTerm t : n.groupByTerms) {
            ir.getGroupBy().add(new IrGroupByElem(t.expr == null ? null : this.renderExpr(t.expr), t.var));
        }
        for (ValueExpr cond : n.havingConditions) {
            ir.getHaving().add(ExprTextUtils.stripRedundantOuterParens(this.renderExprForHaving(cond, n)));
        }
        for (OrderElem oe : n.orderBy) {
            ir.getOrderBy().add(new IrOrderSpec(this.renderExpr(oe.getExpr()), oe.isAscending()));
        }
        return ir;
    }

    private PathNode parseAPathInner(TupleExpr innerExpr, Var subj, Var obj) {
        PathNode seq;
        PathNode n;
        if (innerExpr instanceof StatementPattern && (n = this.parseAtomicFromStatement((StatementPattern)innerExpr, subj, obj)) != null) {
            return n;
        }
        if (innerExpr instanceof Union) {
            PathNode nps = this.tryParseNegatedPropertySetFromUnion(innerExpr, subj, obj);
            if (nps != null) {
                return nps;
            }
            ArrayList<TupleExpr> branches = new ArrayList<TupleExpr>();
            TupleExprToIrConverter.flattenUnion(innerExpr, branches);
            ArrayList<PathNode> alts = new ArrayList<PathNode>(branches.size());
            for (TupleExpr b : branches) {
                if (!(b instanceof StatementPattern)) {
                    return null;
                }
                PathNode n2 = this.parseAtomicFromStatement((StatementPattern)b, subj, obj);
                if (n2 == null) {
                    return null;
                }
                alts.add(n2);
            }
            return new PathAlt(alts);
        }
        if (innerExpr instanceof Join) {
            seq = this.tryParseJoinOfUnionAndZeroOrOne(innerExpr, subj);
            if (seq != null) {
                return seq;
            }
            seq = this.buildPathSequenceFromJoinAllowingUnions(innerExpr, subj, obj);
            if (seq != null) {
                return seq;
            }
        }
        seq = this.buildPathSequenceFromChain(innerExpr, subj, obj);
        return seq;
    }

    private PathNode buildPathSequenceFromJoinAllowingUnions(TupleExpr expr, Var subj, Var obj) {
        ArrayList<TupleExpr> parts = new ArrayList<TupleExpr>();
        TupleExprToIrConverter.flattenJoin(expr, parts);
        if (parts.isEmpty()) {
            return null;
        }
        Var cur = subj;
        ArrayList<PathNode> steps = new ArrayList<PathNode>();
        for (int i = 0; i < parts.size(); ++i) {
            boolean last;
            TupleExpr part = (TupleExpr)parts.get(i);
            boolean bl = last = i == parts.size() - 1;
            if (part instanceof StatementPattern) {
                StatementPattern sp = (StatementPattern)part;
                Var pv = sp.getPredicateVar();
                if (!TupleExprToIrConverter.isConstIriVar(pv)) {
                    return null;
                }
                Var ss = sp.getSubjectVar();
                Var oo = sp.getObjectVar();
                if (TupleExprToIrConverter.sameVar(cur, ss) && (TupleExprToIrConverter.isAnonPathVar(oo) || last && TupleExprToIrConverter.sameVar(oo, obj))) {
                    steps.add(new PathAtom(TupleExprToIrConverter.asIri(pv), false));
                    cur = oo;
                    continue;
                }
                if (TupleExprToIrConverter.sameVar(cur, oo) && (TupleExprToIrConverter.isAnonPathVar(ss) || last && TupleExprToIrConverter.sameVar(ss, obj))) {
                    steps.add(new PathAtom(TupleExprToIrConverter.asIri(pv), true));
                    cur = ss;
                    continue;
                }
                return null;
            }
            if (part instanceof Union) {
                ArrayList<TupleExpr> unions = new ArrayList<TupleExpr>();
                TupleExprToIrConverter.flattenUnion(part, unions);
                Var next = null;
                ArrayList<PathNode> alts = new ArrayList<PathNode>();
                for (TupleExpr u : unions) {
                    Var mid;
                    boolean inv;
                    if (!(u instanceof StatementPattern)) {
                        return null;
                    }
                    StatementPattern sp = (StatementPattern)u;
                    Var pv = sp.getPredicateVar();
                    if (!TupleExprToIrConverter.isConstIriVar(pv)) {
                        return null;
                    }
                    Var ss = sp.getSubjectVar();
                    Var oo = sp.getObjectVar();
                    if (TupleExprToIrConverter.sameVar(cur, ss) && TupleExprToIrConverter.isAnonPathVar(oo)) {
                        inv = false;
                        mid = oo;
                    } else if (TupleExprToIrConverter.sameVar(cur, oo) && TupleExprToIrConverter.isAnonPathVar(ss)) {
                        inv = true;
                        mid = ss;
                    } else if (last && TupleExprToIrConverter.sameVar(ss, obj) && TupleExprToIrConverter.sameVar(cur, oo)) {
                        inv = true;
                        mid = ss;
                    } else if (last && TupleExprToIrConverter.sameVar(oo, obj) && TupleExprToIrConverter.sameVar(cur, ss)) {
                        inv = false;
                        mid = oo;
                    } else {
                        return null;
                    }
                    if (next == null) {
                        next = mid;
                    } else if (!TupleExprToIrConverter.sameVar(next, mid)) {
                        return null;
                    }
                    alts.add(new PathAtom((IRI)pv.getValue(), inv));
                }
                if (next == null) {
                    return null;
                }
                cur = next;
                steps.add(alts.size() == 1 ? (PathNode)alts.get(0) : new PathAlt(alts));
                continue;
            }
            return null;
        }
        if (!TupleExprToIrConverter.sameVar(cur, obj) && !TupleExprToIrConverter.isAnonPathVar(cur)) {
            return null;
        }
        return steps.size() == 1 ? (PathNode)steps.get(0) : new PathSeq(steps);
    }

    private PathNode tryParseNegatedPropertySetFromUnion(TupleExpr expr, Var subj, Var obj) {
        ArrayList<TupleExpr> leaves = new ArrayList<TupleExpr>();
        TupleExprToIrConverter.flattenUnion(expr, leaves);
        if (leaves.isEmpty()) {
            return null;
        }
        ArrayList<PathNode> members = new ArrayList<PathNode>();
        for (TupleExpr leaf : leaves) {
            boolean inverse;
            IRI bad;
            Var pv;
            if (!(leaf instanceof Filter)) {
                return null;
            }
            Filter f = (Filter)leaf;
            if (!(f.getArg() instanceof StatementPattern)) {
                return null;
            }
            StatementPattern sp = (StatementPattern)f.getArg();
            if (!(f.getCondition() instanceof Compare)) {
                return null;
            }
            Compare cmp = (Compare)f.getCondition();
            if (cmp.getOperator() != Compare.CompareOp.NE) {
                return null;
            }
            if (cmp.getLeftArg() instanceof Var && cmp.getRightArg() instanceof ValueConstant && ((ValueConstant)cmp.getRightArg()).getValue() instanceof IRI) {
                pv = (Var)cmp.getLeftArg();
                bad = (IRI)((ValueConstant)cmp.getRightArg()).getValue();
            } else if (cmp.getRightArg() instanceof Var && cmp.getLeftArg() instanceof ValueConstant && ((ValueConstant)cmp.getLeftArg()).getValue() instanceof IRI) {
                pv = (Var)cmp.getRightArg();
                bad = (IRI)((ValueConstant)cmp.getLeftArg()).getValue();
            } else {
                return null;
            }
            if (!TupleExprToIrConverter.sameVar(sp.getPredicateVar(), pv)) {
                return null;
            }
            boolean forward = TupleExprToIrConverter.sameVar(sp.getSubjectVar(), subj) && TupleExprToIrConverter.sameVar(sp.getObjectVar(), obj);
            boolean bl = inverse = TupleExprToIrConverter.sameVar(sp.getSubjectVar(), obj) && TupleExprToIrConverter.sameVar(sp.getObjectVar(), subj);
            if (!forward && !inverse) {
                return null;
            }
            members.add(new PathAtom(bad, inverse));
        }
        PathNode inner = members.size() == 1 ? (PathNode)members.get(0) : new PathAlt(members);
        return new PathNeg(inner);
    }

    private PathNode tryParseJoinOfUnionAndZeroOrOne(TupleExpr expr, Var subj) {
        ArrayList<TupleExpr> parts = new ArrayList<TupleExpr>();
        TupleExprToIrConverter.flattenJoin(expr, parts);
        if (parts.size() != 2 || !(parts.get(0) instanceof Union)) {
            return null;
        }
        Union u = (Union)parts.get(0);
        TupleExpr tailExpr = (TupleExpr)parts.get(1);
        FirstStepUnion first = this.parseFirstStepUnion(u, subj);
        if (first == null) {
            return null;
        }
        ZeroOrOneNode tail = this.parseZeroOrOneProjectionNode(tailExpr);
        if (tail == null) {
            return null;
        }
        if (!TupleExprToIrConverter.sameVar(first.mid, tail.s)) {
            return null;
        }
        ArrayList<PathNode> seqParts = new ArrayList<PathNode>();
        seqParts.add(first.node);
        seqParts.add(tail.node);
        return new PathSeq(seqParts);
    }

    private FirstStepUnion parseFirstStepUnion(TupleExpr expr, Var subj) {
        ArrayList<TupleExpr> branches = new ArrayList<TupleExpr>();
        TupleExprToIrConverter.flattenUnion(expr, branches);
        Var mid = null;
        ArrayList<PathNode> alts = new ArrayList<PathNode>();
        for (TupleExpr b : branches) {
            Var m;
            boolean inv;
            if (!(b instanceof StatementPattern)) {
                return null;
            }
            StatementPattern sp = (StatementPattern)b;
            Var ss = sp.getSubjectVar();
            Var oo = sp.getObjectVar();
            Var pv = sp.getPredicateVar();
            if (!TupleExprToIrConverter.isConstIriVar(pv)) {
                return null;
            }
            if (TupleExprToIrConverter.sameVar(subj, ss) && TupleExprToIrConverter.isAnonPathVar(oo)) {
                inv = false;
                m = oo;
            } else if (TupleExprToIrConverter.sameVar(subj, oo) && TupleExprToIrConverter.isAnonPathVar(ss)) {
                inv = true;
                m = ss;
            } else {
                return null;
            }
            if (mid == null) {
                mid = m;
            } else if (!TupleExprToIrConverter.sameVar(mid, m)) {
                return null;
            }
            alts.add(new PathAtom((IRI)pv.getValue(), inv));
        }
        if (mid == null) {
            return null;
        }
        PathNode n = alts.size() == 1 ? (PathNode)alts.get(0) : new PathAlt(alts);
        return new FirstStepUnion(mid, n);
    }

    private ZeroOrOneNode parseZeroOrOneProjectionNode(TupleExpr projOrDistinct) {
        TupleExpr cur = projOrDistinct;
        if (cur instanceof Distinct) {
            cur = ((Distinct)cur).getArg();
        }
        if (!(cur instanceof Projection)) {
            return null;
        }
        Projection proj = (Projection)cur;
        TupleExpr arg = proj.getArg();
        if (!(arg instanceof Union)) {
            return null;
        }
        ArrayList<TupleExpr> branches = new ArrayList<TupleExpr>();
        TupleExprToIrConverter.flattenUnion(arg, branches);
        Var s = null;
        Var o = null;
        for (TupleExpr tupleExpr : branches) {
            Filter f;
            if (tupleExpr instanceof ZeroLengthPath) {
                ZeroLengthPath z = (ZeroLengthPath)tupleExpr;
                if (s == null && o == null) {
                    s = z.getSubjectVar();
                    o = z.getObjectVar();
                    continue;
                }
                if (TupleExprToIrConverter.sameVar(s, z.getSubjectVar()) && TupleExprToIrConverter.sameVar(o, z.getObjectVar())) continue;
                return null;
            }
            if (!(tupleExpr instanceof Filter) || !((f = (Filter)tupleExpr).getCondition() instanceof SameTerm)) continue;
            SameTerm st = (SameTerm)f.getCondition();
            if (st.getLeftArg() instanceof Var && st.getRightArg() instanceof Var) {
                Var ls = (Var)st.getLeftArg();
                Var rs = (Var)st.getRightArg();
                if (s == null && o == null) {
                    s = ls;
                    o = rs;
                    continue;
                }
                if (TupleExprToIrConverter.sameVar(s, ls) && TupleExprToIrConverter.sameVar(o, rs)) continue;
                return null;
            }
            return null;
        }
        if (s == null || o == null) {
            return null;
        }
        ArrayList<PathNode> seqs = new ArrayList<PathNode>();
        for (TupleExpr branch : branches) {
            if (branch instanceof ZeroLengthPath || branch instanceof Filter && ((Filter)branch).getCondition() instanceof SameTerm) continue;
            PathNode seq = this.buildPathSequenceFromChain(branch, s, o);
            if (seq == null) {
                return null;
            }
            seqs.add(seq);
        }
        PathNode pathNode = seqs.size() == 1 ? (PathNode)seqs.get(0) : new PathAlt(seqs);
        PathQuant q = new PathQuant(pathNode, 0L, 1L);
        return new ZeroOrOneNode(s, q);
    }

    private PathNode parseAtomicFromStatement(StatementPattern sp, Var subj, Var obj) {
        Var ss = sp.getSubjectVar();
        Var oo = sp.getObjectVar();
        Var pv = sp.getPredicateVar();
        if (!TupleExprToIrConverter.isConstIriVar(pv)) {
            return null;
        }
        if (TupleExprToIrConverter.sameVar(subj, ss) && TupleExprToIrConverter.sameVar(oo, obj)) {
            return new PathAtom((IRI)pv.getValue(), false);
        }
        if (TupleExprToIrConverter.sameVar(subj, oo) && TupleExprToIrConverter.sameVar(ss, obj)) {
            return new PathAtom((IRI)pv.getValue(), true);
        }
        return null;
    }

    private PathNode buildPathSequenceFromChain(TupleExpr chain, Var s, Var o) {
        ArrayList<TupleExpr> flat = new ArrayList<TupleExpr>();
        TupleExprToIrConverter.flattenJoin(chain, flat);
        ArrayList<StatementPattern> sps = new ArrayList<StatementPattern>();
        for (TupleExpr t : flat) {
            if (t instanceof StatementPattern) {
                sps.add((StatementPattern)t);
                continue;
            }
            return null;
        }
        if (sps.isEmpty()) {
            return null;
        }
        ArrayList<PathAtom> steps = new ArrayList<PathAtom>();
        Var cur = s;
        LinkedHashSet<StatementPattern> used = new LinkedHashSet<StatementPattern>();
        int guard = 0;
        while (!TupleExprToIrConverter.sameVar(cur, o)) {
            if (++guard > 10000) {
                return null;
            }
            boolean advanced = false;
            for (StatementPattern sp : sps) {
                Var pv;
                if (used.contains(sp) || !TupleExprToIrConverter.isConstIriVar(pv = sp.getPredicateVar())) continue;
                Var ss = sp.getSubjectVar();
                Var oo = sp.getObjectVar();
                if (TupleExprToIrConverter.sameVar(cur, ss) && (TupleExprToIrConverter.isAnonPathVar(oo) || TupleExprToIrConverter.sameVar(oo, o))) {
                    steps.add(new PathAtom(TupleExprToIrConverter.asIri(pv), false));
                    cur = oo;
                    used.add(sp);
                    advanced = true;
                    break;
                }
                if (!TupleExprToIrConverter.sameVar(cur, oo) || !TupleExprToIrConverter.isAnonPathVar(ss) && !TupleExprToIrConverter.sameVar(ss, o)) continue;
                steps.add(new PathAtom(TupleExprToIrConverter.asIri(pv), true));
                cur = ss;
                used.add(sp);
                advanced = true;
                break;
            }
            if (advanced) continue;
            return null;
        }
        if (used.size() != sps.size()) {
            return null;
        }
        if (steps.isEmpty()) {
            return null;
        }
        return steps.size() == 1 ? (PathNode)steps.get(0) : new PathSeq(new ArrayList<PathNode>(steps));
    }

    private static boolean rootHasExplicitScope(TupleExpr e) {
        if (e == null) {
            return false;
        }
        if (e instanceof Service || e instanceof Union || e instanceof Projection || e instanceof Slice || e instanceof Distinct || e instanceof Group) {
            return false;
        }
        if (e instanceof AbstractQueryModelNode) {
            return ((AbstractQueryModelNode)((Object)e)).isVariableScopeChange();
        }
        return false;
    }

    public static boolean hasExplicitRootScope(TupleExpr root) {
        Normalized n = TupleExprToIrConverter.normalize(root, false);
        return TupleExprToIrConverter.rootHasExplicitScope(n.where);
    }

    static {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("http://www.w3.org/2005/xpath-functions#string-length", "STRLEN");
        m.put("http://www.w3.org/2005/xpath-functions#lower-case", "LCASE");
        m.put("http://www.w3.org/2005/xpath-functions#upper-case", "UCASE");
        m.put("http://www.w3.org/2005/xpath-functions#substring", "SUBSTR");
        m.put("http://www.w3.org/2005/xpath-functions#contains", "CONTAINS");
        m.put("http://www.w3.org/2005/xpath-functions#concat", "CONCAT");
        m.put("http://www.w3.org/2005/xpath-functions#replace", "REPLACE");
        m.put("http://www.w3.org/2005/xpath-functions#encode-for-uri", "ENCODE_FOR_URI");
        m.put("http://www.w3.org/2005/xpath-functions#starts-with", "STRSTARTS");
        m.put("http://www.w3.org/2005/xpath-functions#ends-with", "STRENDS");
        m.put("http://www.w3.org/2005/xpath-functions#numeric-abs", "ABS");
        m.put("http://www.w3.org/2005/xpath-functions#numeric-ceil", "CEIL");
        m.put("http://www.w3.org/2005/xpath-functions#numeric-floor", "FLOOR");
        m.put("http://www.w3.org/2005/xpath-functions#numeric-round", "ROUND");
        m.put("http://www.w3.org/2005/xpath-functions#year-from-dateTime", "YEAR");
        m.put("http://www.w3.org/2005/xpath-functions#month-from-dateTime", "MONTH");
        m.put("http://www.w3.org/2005/xpath-functions#day-from-dateTime", "DAY");
        m.put("http://www.w3.org/2005/xpath-functions#hours-from-dateTime", "HOURS");
        m.put("http://www.w3.org/2005/xpath-functions#minutes-from-dateTime", "MINUTES");
        m.put("http://www.w3.org/2005/xpath-functions#seconds-from-dateTime", "SECONDS");
        m.put("http://www.w3.org/2005/xpath-functions#timezone-from-dateTime", "TIMEZONE");
        for (String k : new String[]{"RAND", "NOW", "ABS", "CEIL", "FLOOR", "ROUND", "YEAR", "MONTH", "DAY", "HOURS", "MINUTES", "SECONDS", "TZ", "TIMEZONE", "MD5", "SHA1", "SHA224", "SHA256", "SHA384", "SHA512", "UCASE", "LCASE", "SUBSTR", "STRLEN", "CONTAINS", "CONCAT", "REPLACE", "ENCODE_FOR_URI", "STRSTARTS", "STRENDS", "STRBEFORE", "STRAFTER", "REGEX", "UUID", "STRUUID", "STRDT", "STRLANG", "BNODE", "URI"}) {
            m.put(k, k);
        }
        BUILTIN = Collections.unmodifiableMap(m);
    }

    final class IRBuilder
    extends AbstractQueryModelVisitor<RuntimeException> {
        private final IrBGP where = new IrBGP(false);
        private final Map<String, IrInlineTriple> inlineTriples;

        IRBuilder() {
            this.inlineTriples = new LinkedHashMap<String, IrInlineTriple>();
        }

        IRBuilder(Map<String, IrInlineTriple> shared) {
            this.inlineTriples = shared;
        }

        IrBGP build(TupleExpr t) {
            if (t == null) {
                return this.where;
            }
            t.visit(this);
            return this.where;
        }

        private IRBuilder childBuilder() {
            return new IRBuilder(this.inlineTriples);
        }

        private IrFilter buildFilterFromCondition(ValueExpr condExpr) {
            if (condExpr == null) {
                return new IrFilter((String)null, false);
            }
            if (condExpr instanceof Not && ((Not)condExpr).getArg() instanceof Exists) {
                Exists ex = (Exists)((Not)condExpr).getArg();
                IRBuilder inner = this.childBuilder();
                IrBGP bgp = inner.build(ex.getSubQuery());
                return new IrFilter(new IrNot(new IrExists(bgp, ex.isVariableScopeChange()), false), false);
            }
            if (condExpr instanceof Exists) {
                Exists ex = (Exists)condExpr;
                TupleExpr sub = ex.getSubQuery();
                IRBuilder inner = this.childBuilder();
                IrBGP bgp = inner.build(sub);
                if (TupleExprToIrConverter.rootHasExplicitScope(sub)) {
                    bgp.setNewScope(true);
                }
                IrExists exNode = new IrExists(bgp, false);
                return new IrFilter(exNode, false);
            }
            String cond = ExprTextUtils.stripRedundantOuterParens(TupleExprToIrConverter.this.renderExpr(condExpr));
            return new IrFilter(cond, false);
        }

        @Override
        public void meet(StatementPattern sp) {
            IrInlineTriple inline;
            Var ctx = TupleExprToIrConverter.getContextVarSafe(sp);
            IrStatementPattern node = new IrStatementPattern(sp.getSubjectVar(), sp.getPredicateVar(), sp.getObjectVar(), false);
            if (sp.getSubjectVar() != null && (inline = this.inlineTriples.get(sp.getSubjectVar().getName())) != null) {
                node.setSubjectOverride(inline);
            }
            if (sp.getObjectVar() != null && (inline = this.inlineTriples.get(sp.getObjectVar().getName())) != null) {
                node.setObjectOverride(inline);
            }
            if (ctx != null && (ctx.hasValue() || ctx.getName() != null && !ctx.getName().isEmpty())) {
                IrBGP inner = new IrBGP(false);
                inner.add(node);
                this.where.add(new IrGraph(ctx, inner, false));
            } else {
                this.where.add(node);
            }
        }

        @Override
        public void meet(TripleRef tr) {
            Var exprVar = tr.getExprVar();
            if (exprVar != null && exprVar.getName() != null) {
                this.inlineTriples.put(exprVar.getName(), new IrInlineTriple(tr.getSubjectVar(), tr.getPredicateVar(), tr.getObjectVar()));
            }
        }

        @Override
        public void meet(Join join) {
            Object sub;
            IRBuilder left = this.childBuilder();
            IrBGP wl = left.build(join.getLeftArg());
            IRBuilder right = this.childBuilder();
            IrBGP wr = right.build(join.getRightArg());
            boolean wrapLeft = TupleExprToIrConverter.rootHasExplicitScope(join.getLeftArg());
            boolean wrapRight = TupleExprToIrConverter.rootHasExplicitScope(join.getRightArg());
            if (join.isVariableScopeChange()) {
                IrBGP grp = new IrBGP(false);
                if (wrapLeft && !wl.getLines().isEmpty()) {
                    IrBGP irBGP = new IrBGP(false);
                    for (IrNode ln : wl.getLines()) {
                        irBGP.add(ln);
                    }
                    grp.add(irBGP);
                } else {
                    for (IrNode irNode : wl.getLines()) {
                        grp.add(irNode);
                    }
                }
                if (wrapRight && !wr.getLines().isEmpty()) {
                    IrBGP irBGP = new IrBGP(false);
                    for (IrNode ln : wr.getLines()) {
                        irBGP.add(ln);
                    }
                    grp.add(irBGP);
                } else {
                    for (IrNode irNode : wr.getLines()) {
                        grp.add(irNode);
                    }
                }
                this.where.add(grp);
                return;
            }
            if (wrapLeft && !wl.getLines().isEmpty()) {
                sub = new IrBGP(false);
                for (IrNode irNode : wl.getLines()) {
                    ((IrBGP)sub).add(irNode);
                }
                this.where.add((IrNode)sub);
            } else {
                for (IrNode irNode : wl.getLines()) {
                    this.where.add(irNode);
                }
            }
            if (wrapRight && !wr.getLines().isEmpty()) {
                sub = new IrBGP(false);
                for (IrNode irNode : wr.getLines()) {
                    ((IrBGP)sub).add(irNode);
                }
                this.where.add((IrNode)sub);
            } else {
                for (IrNode irNode : wr.getLines()) {
                    this.where.add(irNode);
                }
            }
        }

        @Override
        public void meet(LeftJoin lj) {
            if (lj.isVariableScopeChange()) {
                IRBuilder left = this.childBuilder();
                IrBGP wl = left.build(lj.getLeftArg());
                IRBuilder rightBuilder = this.childBuilder();
                IrBGP wr = rightBuilder.build(lj.getRightArg());
                if (lj.getCondition() != null) {
                    wr.add(this.buildFilterFromCondition(lj.getCondition()));
                }
                IrBGP grp = new IrBGP(false);
                for (IrNode ln : wl.getLines()) {
                    grp.add(ln);
                }
                IrOptional opt = new IrOptional(wr, TupleExprToIrConverter.rootHasExplicitScope(lj.getRightArg()));
                grp.add(opt);
                this.where.add(grp);
                return;
            }
            lj.getLeftArg().visit(this);
            IRBuilder rightBuilder = this.childBuilder();
            IrBGP right = rightBuilder.build(lj.getRightArg());
            if (lj.getCondition() != null) {
                right.add(this.buildFilterFromCondition(lj.getCondition()));
            }
            this.where.add(new IrOptional(right, false));
        }

        @Override
        public void meet(Filter f) {
            if (f.isVariableScopeChange() && f.getArg() instanceof SingletonSet) {
                IrBGP group = new IrBGP(false);
                group.add(this.buildFilterFromCondition(f.getCondition()));
                this.where.add(group);
                return;
            }
            TupleExpr arg = f.getArg();
            Projection trailingProj = null;
            ArrayList<TupleExpr> head = null;
            if (arg instanceof Join) {
                ArrayList<TupleExpr> flat = new ArrayList<TupleExpr>();
                TupleExprToIrConverter.flattenJoin(arg, flat);
                if (!flat.isEmpty()) {
                    TupleExpr last = (TupleExpr)flat.get(flat.size() - 1);
                    if (last instanceof Projection) {
                        trailingProj = (Projection)last;
                    } else if (last instanceof Distinct && ((Distinct)last).getArg() instanceof Projection) {
                        trailingProj = (Projection)((Distinct)last).getArg();
                    }
                    if (trailingProj != null) {
                        head = new ArrayList<TupleExpr>(flat);
                        head.remove(head.size() - 1);
                    }
                }
            }
            if (trailingProj != null) {
                LinkedHashSet<String> headVars = new LinkedHashSet<String>();
                for (TupleExpr tupleExpr : head) {
                    TupleExprToIrConverter.collectFreeVars(tupleExpr, headVars);
                }
                Set<String> condVars = TupleExprToIrConverter.freeVars(f.getCondition());
                if (headVars.containsAll(condVars)) {
                    for (TupleExpr n : head) {
                        n.visit(this);
                    }
                    this.where.add(this.buildFilterFromCondition(f.getCondition()));
                    trailingProj.visit(this);
                    return;
                }
            }
            if (f.isVariableScopeChange()) {
                IRBuilder inner = this.childBuilder();
                IrBGP innerWhere = inner.build(arg);
                IrFilter irFilter = this.buildFilterFromCondition(f.getCondition());
                innerWhere.add(irFilter);
                this.where.add(innerWhere);
                return;
            }
            arg.visit(this);
            IrFilter irF = this.buildFilterFromCondition(f.getCondition());
            this.where.add(irF);
        }

        @Override
        public void meet(SingletonSet s) {
        }

        @Override
        public void meet(Union u) {
            boolean leftIsU = u.getLeftArg() instanceof Union;
            boolean rightIsU = u.getRightArg() instanceof Union;
            if (leftIsU && rightIsU) {
                IrUnion irU = new IrUnion(u.isVariableScopeChange());
                irU.setNewScope(u.isVariableScopeChange());
                IRBuilder left = this.childBuilder();
                IrBGP wl = left.build(u.getLeftArg());
                if (TupleExprToIrConverter.rootHasExplicitScope(u.getLeftArg()) && !wl.getLines().isEmpty()) {
                    IrBGP sub = new IrBGP(true);
                    for (IrNode ln : wl.getLines()) {
                        sub.add(ln);
                    }
                    irU.addBranch(sub);
                } else {
                    irU.addBranch(wl);
                }
                IRBuilder right = this.childBuilder();
                IrBGP wr = right.build(u.getRightArg());
                if (TupleExprToIrConverter.rootHasExplicitScope(u.getRightArg()) && !wr.getLines().isEmpty()) {
                    IrBGP sub = new IrBGP(false);
                    for (IrNode ln : wr.getLines()) {
                        sub.add(ln);
                    }
                    irU.addBranch(sub);
                } else {
                    irU.addBranch(wr);
                }
                this.where.add(irU);
                return;
            }
            ArrayList<TupleExpr> branches = new ArrayList<TupleExpr>();
            TupleExprToIrConverter.flattenUnion(u, branches);
            IrUnion irU = new IrUnion(u.isVariableScopeChange());
            irU.setNewScope(u.isVariableScopeChange());
            for (TupleExpr b : branches) {
                IRBuilder bld = this.childBuilder();
                IrBGP wb = bld.build(b);
                if (TupleExprToIrConverter.rootHasExplicitScope(b) && !wb.getLines().isEmpty()) {
                    IrBGP sub = new IrBGP(true);
                    for (IrNode ln : wb.getLines()) {
                        sub.add(ln);
                    }
                    irU.addBranch(sub);
                    continue;
                }
                irU.addBranch(wb);
            }
            this.where.add(irU);
        }

        @Override
        public void meet(Service svc) {
            IRBuilder inner = this.childBuilder();
            IrBGP w = inner.build(svc.getArg());
            IrService irSvc = new IrService(TupleExprToIrConverter.this.renderVarOrValue(svc.getServiceRef()), svc.isSilent(), w, false);
            boolean scope = svc.isVariableScopeChange();
            if (scope) {
                IrBGP grp = new IrBGP(false);
                grp.add(irSvc);
                this.where.add(grp);
            } else {
                this.where.add(irSvc);
            }
        }

        @Override
        public void meet(BindingSetAssignment bsa) {
            IrValues v = new IrValues(false);
            ArrayList<String> names = new ArrayList<String>(bsa.getBindingNames());
            if (!TupleExprToIrConverter.this.cfg.valuesPreserveOrder) {
                Collections.sort(names);
            }
            v.getVarNames().addAll(names);
            for (BindingSet bs : bsa.getBindingSets()) {
                ArrayList<String> row = new ArrayList<String>(names.size());
                for (String nm : names) {
                    Value val = bs.getValue(nm);
                    row.add(val == null ? "UNDEF" : TupleExprToIrConverter.this.convertValueToString(val));
                }
                v.getRows().add(row);
            }
            this.where.add(v);
        }

        @Override
        public void meet(Extension ext) {
            ext.getArg().visit(this);
            for (ExtensionElem ee : ext.getElements()) {
                ValueExpr expr = ee.getExpr();
                if (expr instanceof AggregateOperator) continue;
                this.where.add(new IrBind(TupleExprToIrConverter.this.renderExpr(expr), ee.getName(), false));
            }
        }

        @Override
        public void meet(Projection p) {
            IrSelect sub = TupleExprToIrConverter.toIRSelectRaw(p, TupleExprToIrConverter.this.r);
            boolean wrap = false;
            wrap |= !this.where.getLines().isEmpty();
            if (p.isVariableScopeChange()) {
                wrap = true;
            }
            IrSubSelect node = new IrSubSelect(sub, wrap);
            this.where.add(node);
        }

        @Override
        public void meet(Slice s) {
            if (s.isVariableScopeChange()) {
                IrSelect sub = TupleExprToIrConverter.toIRSelectRaw(s, TupleExprToIrConverter.this.r);
                IrSubSelect node = new IrSubSelect(sub, true);
                this.where.add(node);
                return;
            }
            s.getArg().visit(this);
        }

        @Override
        public void meet(Distinct d) {
            if (d.isVariableScopeChange()) {
                IrSelect sub = TupleExprToIrConverter.toIRSelectRaw(d, TupleExprToIrConverter.this.r);
                IrSubSelect node = new IrSubSelect(sub, true);
                this.where.add(node);
                return;
            }
            d.getArg().visit(this);
        }

        @Override
        public void meet(Difference diff) {
            IRBuilder left = this.childBuilder();
            IrBGP leftWhere = left.build(diff.getLeftArg());
            IRBuilder right = this.childBuilder();
            IrBGP rightWhere = right.build(diff.getRightArg());
            if (diff.isVariableScopeChange()) {
                IrBGP group = new IrBGP(false);
                for (IrNode ln : leftWhere.getLines()) {
                    group.add(ln);
                }
                group.add(new IrMinus(rightWhere, false));
                this.where.add(group);
            } else {
                for (IrNode ln : leftWhere.getLines()) {
                    this.where.add(ln);
                }
                this.where.add(new IrMinus(rightWhere, false));
            }
        }

        @Override
        public void meet(ArbitraryLengthPath p) {
            Var subj = p.getSubjectVar();
            Var obj = p.getObjectVar();
            String expr = TupleExprToIrConverter.this.buildPathExprForArbitraryLengthPath(p);
            IrPathTriple pt = new IrPathTriple(subj, null, expr, obj, null, Collections.emptySet(), false);
            Var ctx = TupleExprToIrConverter.getContextVarSafe(p);
            if (ctx != null && (ctx.hasValue() || ctx.getName() != null && !ctx.getName().isEmpty())) {
                IrBGP innerBgp = new IrBGP(false);
                innerBgp.add(pt);
                this.where.add(new IrGraph(ctx, innerBgp, false));
            } else {
                this.where.add(pt);
            }
        }

        @Override
        public void meet(ZeroLengthPath p) {
            this.where.add(new IrText("FILTER " + TupleExprToIrConverter.asConstraint("sameTerm(" + TupleExprToIrConverter.this.renderVarOrValue(p.getSubjectVar()) + ", " + TupleExprToIrConverter.this.renderVarOrValue(p.getObjectVar()) + ")"), false));
        }

        @Override
        public void meetOther(QueryModelNode node) {
            this.where.add(new IrText("# unsupported node: " + node.getClass().getSimpleName(), false));
        }
    }

    private final class InlinePrinter
    implements IrPrinter {
        private final StringBuilder out;
        private int level = 0;
        private boolean inlineActive = false;

        InlinePrinter(StringBuilder out) {
            this.out = out;
        }

        private void indent() {
            this.out.append(TupleExprToIrConverter.this.cfg.indent.repeat(Math.max(0, this.level)));
        }

        @Override
        public void startLine() {
            if (!this.inlineActive) {
                this.indent();
                this.inlineActive = true;
            }
        }

        @Override
        public void append(String s) {
            int len;
            if (!(this.inlineActive || (len = this.out.length()) != 0 && this.out.charAt(len - 1) != '\n')) {
                this.indent();
            }
            this.out.append(s);
        }

        @Override
        public void endLine() {
            this.out.append('\n');
            this.inlineActive = false;
        }

        @Override
        public void line(String s) {
            if (this.inlineActive) {
                this.out.append(s).append('\n');
                this.inlineActive = false;
                return;
            }
            this.indent();
            this.out.append(s).append('\n');
        }

        @Override
        public void openBlock() {
            if (!this.inlineActive) {
                this.indent();
            }
            this.out.append('{').append('\n');
            ++this.level;
            this.inlineActive = false;
        }

        @Override
        public void closeBlock() {
            --this.level;
            this.indent();
            this.out.append('}').append('\n');
        }

        @Override
        public void pushIndent() {
            ++this.level;
        }

        @Override
        public void popIndent() {
            --this.level;
        }

        @Override
        public String convertVarToString(Var v) {
            return TupleExprToIrConverter.this.renderVarOrValue(v);
        }

        @Override
        public void printLines(List<IrNode> lines) {
            if (lines == null) {
                return;
            }
            for (IrNode ln : lines) {
                if (ln == null) continue;
                ln.print(this);
            }
        }
    }

    private static final class Normalized {
        final List<OrderElem> orderBy = new ArrayList<OrderElem>();
        final LinkedHashMap<String, ValueExpr> selectAssignments = new LinkedHashMap();
        final LinkedHashMap<String, ValueExpr> extensionAssignments = new LinkedHashMap();
        final Set<String> extensionOutputNames = new LinkedHashSet<String>();
        final List<GroupByTerm> groupByTerms = new ArrayList<GroupByTerm>();
        final List<String> syntheticProjectVars = new ArrayList<String>();
        final List<ValueExpr> havingConditions = new ArrayList<ValueExpr>();
        final Set<String> groupByVarNames = new LinkedHashSet<String>();
        final Set<String> aggregateOutputNames = new LinkedHashSet<String>();
        Projection projection;
        TupleExpr where;
        boolean distinct = false;
        boolean reduced = false;
        long limit = -1L;
        long offset = -1L;
        boolean hadExplicitGroup = false;

        private Normalized() {
        }
    }

    private static final class GroupByTerm {
        final String var;
        final ValueExpr expr;

        GroupByTerm(String var, ValueExpr expr) {
            this.var = var;
            this.expr = expr;
        }
    }

    private static final class AggregateScan
    extends AbstractQueryModelVisitor<RuntimeException> {
        final LinkedHashMap<String, ValueExpr> hoisted = new LinkedHashMap();
        final Map<String, Integer> varCounts = new LinkedHashMap<String, Integer>();
        final Map<String, Integer> subjCounts = new LinkedHashMap<String, Integer>();
        final Map<String, Integer> predCounts = new LinkedHashMap<String, Integer>();
        final Map<String, Integer> objCounts = new LinkedHashMap<String, Integer>();
        final Set<String> aggregateArgVars = new LinkedHashSet<String>();
        final Set<String> aggregateOutputNames = new LinkedHashSet<String>();

        private AggregateScan() {
        }

        @Override
        public void meet(StatementPattern sp) {
            this.count(sp.getSubjectVar(), this.subjCounts);
            this.count(sp.getPredicateVar(), this.predCounts);
            this.count(sp.getObjectVar(), this.objCounts);
        }

        @Override
        public void meet(Projection subqueryProjection) {
        }

        @Override
        public void meet(Extension ext) {
            ext.getArg().visit(this);
            for (ExtensionElem ee : ext.getElements()) {
                ValueExpr expr = ee.getExpr();
                if (!(expr instanceof AggregateOperator)) continue;
                this.hoisted.putIfAbsent(ee.getName(), expr);
                this.aggregateOutputNames.add(ee.getName());
                TupleExprToIrConverter.collectVarNames(expr, this.aggregateArgVars);
            }
        }

        private void count(Var v, Map<String, Integer> roleMap) {
            if (v == null || v.hasValue()) {
                return;
            }
            String name = v.getName();
            if (name == null || name.isEmpty()) {
                return;
            }
            this.varCounts.merge(name, 1, Integer::sum);
            roleMap.merge(name, 1, Integer::sum);
        }
    }

    private static interface PathNode {
        public String render();

        public int prec();
    }

    private static final class PathQuant
    implements PathNode {
        final PathNode inner;
        final long min;
        final long max;

        PathQuant(PathNode inner, long min, long max) {
            this.inner = inner;
            this.min = min;
            this.max = max;
        }

        @Override
        public String render() {
            String q = TupleExprToIrConverter.quantifier(this.min, this.max);
            boolean needParens = this.inner.prec() < 3;
            return (String)(needParens ? "(" + this.inner.render() + ")" : this.inner.render()) + q;
        }

        @Override
        public int prec() {
            return 3;
        }
    }

    private static final class PathAlt
    implements PathNode {
        final List<PathNode> alts;

        PathAlt(List<PathNode> alts) {
            this.alts = alts;
        }

        @Override
        public String render() {
            ArrayList<Object> ss = new ArrayList<Object>(this.alts.size());
            for (PathNode p : this.alts) {
                boolean needParens = p.prec() < 1;
                ss.add(needParens ? "(" + p.render() + ")" : p.render());
            }
            return String.join((CharSequence)"|", ss);
        }

        @Override
        public int prec() {
            return 1;
        }
    }

    private final class PathAtom
    implements PathNode {
        final IRI iri;
        final boolean inverse;

        PathAtom(IRI iri, boolean inverse) {
            this.iri = iri;
            this.inverse = inverse;
        }

        @Override
        public String render() {
            return (this.inverse ? "^" : "") + TupleExprToIrConverter.this.convertIRIToString(this.iri);
        }

        @Override
        public int prec() {
            return 3;
        }
    }

    private static final class PathSeq
    implements PathNode {
        final List<PathNode> parts;

        PathSeq(List<PathNode> parts) {
            this.parts = parts;
        }

        @Override
        public String render() {
            ArrayList<Object> ss = new ArrayList<Object>(this.parts.size());
            for (PathNode p : this.parts) {
                boolean needParens = p.prec() < 2;
                ss.add(needParens ? "(" + p.render() + ")" : p.render());
            }
            return String.join((CharSequence)"/", ss);
        }

        @Override
        public int prec() {
            return 2;
        }
    }

    private static final class PathNeg
    implements PathNode {
        final PathNode inner;

        PathNeg(PathNode inner) {
            this.inner = inner;
        }

        @Override
        public String render() {
            return "!(" + (this.inner == null ? "" : this.inner.render()) + ")";
        }

        @Override
        public int prec() {
            return 3;
        }
    }

    private static final class FirstStepUnion {
        final Var mid;
        final PathNode node;

        FirstStepUnion(Var mid, PathNode node) {
            this.mid = mid;
            this.node = node;
        }
    }

    private static final class ZeroOrOneNode {
        final Var s;
        final PathNode node;

        ZeroOrOneNode(Var s, PathNode node) {
            this.s = s;
            this.node = node;
        }
    }
}

