/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.FileUtils;
import org.junit.Assume;

public class FileUtilities {
    public static String getFileContents(Project project, String fileName) throws IOException {
        return FileUtilities.getFileContents(new File(project.getBaseDir(), fileName));
    }

    public static String getFileContents(File file) throws IOException {
        try (FileReader rdr = new FileReader(file);){
            String string = FileUtils.readFully((Reader)rdr);
            return string;
        }
    }

    public static void rollbackTimestamps(File file, long seconds) {
        if (null == file || !file.exists()) {
            return;
        }
        Assume.assumeTrue((boolean)file.setLastModified(file.lastModified() - seconds * 1000L));
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            if (children == null) {
                return;
            }
            Arrays.stream(children).forEach(child -> FileUtilities.rollbackTimestamps(child, seconds));
        }
    }
}

