/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.navigator;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.rcptt.core.model.IElementChangedListener;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.Q7ElementChangedEvent;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.core.workspace.WorkspaceSynchronizer;
import org.eclipse.rcptt.ui.navigator.ProblemsLabelDecorator;
import org.eclipse.rcptt.ui.utils.ModelUtils;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class Q7LabelProvider
extends LabelProvider
implements IElementChangedListener {
    private ILabelProvider provider = new WorkbenchLabelProvider();
    private ProblemsLabelDecorator decorator;

    public Q7LabelProvider() {
        RcpttCore.addElementChangedListener((IElementChangedListener)this);
        this.decorator = new ProblemsLabelDecorator();
    }

    public void dispose() {
        super.dispose();
        RcpttCore.removeElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(Q7ElementChangedEvent event) {
        IQ7NamedElement[] elements = event.getDelta().getNamedElements();
        if (elements != null) {
            this.refresh(elements);
        }
    }

    public void markerChanged(List<NamedElement> elements) {
        final HashSet<IFile> elementsToRefresh = new HashSet<IFile>();
        for (NamedElement e : elements) {
            IFile file = WorkspaceSynchronizer.getFile((Resource)e.eResource());
            if (file == null) continue;
            while (file.getType() != 8) {
                elementsToRefresh.add(file);
                file = file.getParent();
            }
        }
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                Q7LabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)Q7LabelProvider.this, elementsToRefresh.toArray()));
            }
        });
    }

    private void refresh(final IQ7NamedElement[] elements) {
        WorkbenchUtils.uiRun(new Runnable(){

            @Override
            public void run() {
                HashSet<Object> toRefresh = new HashSet<Object>();
                IQ7NamedElement[] iQ7NamedElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IQ7NamedElement iq7NamedElement = iQ7NamedElementArray[n2];
                    IResource file = iq7NamedElement.getResource();
                    if (file != null) {
                        toRefresh.add(file);
                        IContainer res = file.getParent();
                        while (res != null) {
                            toRefresh.add(res);
                            res = res.getParent();
                            if (res == null || res.getType() == 4) break;
                        }
                    }
                    ++n2;
                }
                if (!toRefresh.isEmpty()) {
                    Q7LabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)Q7LabelProvider.this, toRefresh.toArray()));
                }
            }
        });
    }

    public Image getImage(Object element) {
        IQ7Element namedElement = this.getNamedElement(element);
        Image result = null;
        if (namedElement != null) {
            result = ModelUtils.getImage(namedElement);
        }
        if (result == null) {
            result = this.provider.getImage(element);
        }
        if (result != null) {
            Object el = element;
            if (element instanceof NamedElement) {
                el = WorkspaceSynchronizer.getFile((Resource)((NamedElement)element).eResource());
            }
            return this.decorator.decorateImage(result, el);
        }
        return result;
    }

    public String getText(Object element) {
        IQ7Element namedElement = this.getNamedElement(element);
        if (namedElement != null) {
            return ModelUtils.getText(namedElement);
        }
        return this.provider.getText(element);
    }

    private IQ7Element getNamedElement(Object element) {
        if (element instanceof IFile) {
            IFile file = (IFile)element;
            try {
                return RcpttCore.create((IResource)file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

