/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.comparators;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRef;

public abstract class NumericComparator<T extends Number>
extends FieldComparator<T> {
    private static final int MIN_SKIP_INTERVAL = 32;
    private static final int MAX_SKIP_INTERVAL = 8192;
    protected final T missingValue;
    private final long missingValueAsLong;
    protected final String field;
    protected final boolean reverse;
    private final int bytesCount;
    protected boolean topValueSet;
    protected boolean singleSort;
    protected boolean hitsThresholdReached;
    protected boolean queueFull;
    protected Pruning pruning;

    protected NumericComparator(String field, T missingValue, boolean reverse, Pruning pruning, int bytesCount) {
        this.field = field;
        this.missingValue = missingValue;
        this.missingValueAsLong = this.missingValueAsComparableLong();
        this.reverse = reverse;
        this.pruning = pruning;
        this.bytesCount = bytesCount;
    }

    @Override
    public void setTopValue(T value) {
        this.topValueSet = true;
    }

    @Override
    public void setSingleSort() {
        this.singleSort = true;
    }

    @Override
    public void disableSkipping() {
        this.pruning = Pruning.NONE;
    }

    protected abstract long missingValueAsComparableLong();

    protected abstract long sortableBytesToLong(byte[] var1);

    public abstract class NumericLeafComparator
    implements LeafFieldComparator {
        private final LeafReaderContext context;
        protected final NumericDocValues docValues;
        private final PointValues pointValues;
        private PointValues.PointTree pointTree;
        private final boolean enableSkipping;
        private final int maxDoc;
        private final boolean leafTopSet;
        private long minValueAsLong;
        private long maxValueAsLong;
        private DocIdSetIterator competitiveIterator;
        private long iteratorCost;
        private int maxDocVisited;
        private int updateCounter;
        private int currentSkipInterval;
        private int tryUpdateFailCount;

        public NumericLeafComparator(LeafReaderContext context) throws IOException {
            this.leafTopSet = NumericComparator.this.topValueSet;
            this.minValueAsLong = Long.MIN_VALUE;
            this.maxValueAsLong = Long.MAX_VALUE;
            this.iteratorCost = -1L;
            this.maxDocVisited = -1;
            this.updateCounter = 0;
            this.currentSkipInterval = 32;
            this.tryUpdateFailCount = 0;
            this.context = context;
            this.docValues = this.getNumericDocValues(context, NumericComparator.this.field);
            PointValues pointValues = this.pointValues = NumericComparator.this.pruning != Pruning.NONE ? context.reader().getPointValues(NumericComparator.this.field) : null;
            if (this.pointValues != null) {
                FieldInfo info = context.reader().getFieldInfos().fieldInfo(NumericComparator.this.field);
                if (info == null || info.getPointDimensionCount() == 0) {
                    throw new IllegalStateException("Field " + NumericComparator.this.field + " doesn't index points according to FieldInfos yet returns non-null PointValues");
                }
                if (info.getPointDimensionCount() > 1) {
                    throw new IllegalArgumentException("Field " + NumericComparator.this.field + " is indexed with multiple dimensions, sorting is not supported");
                }
                if (info.getPointNumBytes() != NumericComparator.this.bytesCount) {
                    throw new IllegalArgumentException("Field " + NumericComparator.this.field + " is indexed with " + info.getPointNumBytes() + " bytes per dimension, but " + String.valueOf(NumericComparator.this) + " expected " + NumericComparator.this.bytesCount);
                }
                this.enableSkipping = true;
                this.maxDoc = context.reader().maxDoc();
                this.competitiveIterator = DocIdSetIterator.all(this.maxDoc);
                if (this.leafTopSet) {
                    this.encodeTop();
                }
            } else {
                this.enableSkipping = false;
                this.maxDoc = 0;
            }
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return DocValues.getNumeric(context.reader(), field);
        }

        @Override
        public void setBottom(int slot) throws IOException {
            NumericComparator.this.queueFull = true;
            this.updateCompetitiveIterator();
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.maxDocVisited = doc;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            if (this.iteratorCost == -1L) {
                this.iteratorCost = scorer instanceof Scorer ? ((Scorer)scorer).iterator().cost() : (long)this.maxDoc;
                this.updateCompetitiveIterator();
            }
        }

        @Override
        public void setHitsThresholdReached() throws IOException {
            NumericComparator.this.hitsThresholdReached = true;
            this.updateCompetitiveIterator();
        }

        private void updateCompetitiveIterator() throws IOException {
            if (!this.enableSkipping || !NumericComparator.this.hitsThresholdReached || !this.leafTopSet && !NumericComparator.this.queueFull) {
                return;
            }
            if (this.pointValues.getDocCount() < this.maxDoc && this.isMissingValueCompetitive()) {
                return;
            }
            ++this.updateCounter;
            if (this.updateCounter > 256 && (this.updateCounter & this.currentSkipInterval - 1) != this.currentSkipInterval - 1) {
                return;
            }
            if (NumericComparator.this.queueFull) {
                this.encodeBottom();
            }
            final DocIdSetBuilder result = new DocIdSetBuilder(this.maxDoc);
            PointValues.IntersectVisitor visitor = new PointValues.IntersectVisitor(){
                DocIdSetBuilder.BulkAdder adder;

                @Override
                public void grow(int count) {
                    this.adder = result.grow(count);
                }

                @Override
                public void visit(int docID) {
                    if (docID <= NumericLeafComparator.this.maxDocVisited) {
                        return;
                    }
                    this.adder.add(docID);
                }

                @Override
                public void visit(int docID, byte[] packedValue) {
                    if (docID <= NumericLeafComparator.this.maxDocVisited) {
                        return;
                    }
                    long l = NumericComparator.this.sortableBytesToLong(packedValue);
                    if (l >= NumericLeafComparator.this.minValueAsLong && l <= NumericLeafComparator.this.maxValueAsLong) {
                        this.adder.add(docID);
                    }
                }

                @Override
                public void visit(DocIdSetIterator iterator) throws IOException {
                    if (iterator.advance(NumericLeafComparator.this.maxDocVisited + 1) != Integer.MAX_VALUE) {
                        this.adder.add(iterator.docID());
                        this.adder.add(iterator);
                    }
                }

                @Override
                public void visit(IntsRef ref) {
                    this.adder.add(ref, NumericLeafComparator.this.maxDocVisited + 1);
                }

                @Override
                public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                    long min = NumericComparator.this.sortableBytesToLong(minPackedValue);
                    long max = NumericComparator.this.sortableBytesToLong(maxPackedValue);
                    if (min > NumericLeafComparator.this.maxValueAsLong || max < NumericLeafComparator.this.minValueAsLong) {
                        return PointValues.Relation.CELL_OUTSIDE_QUERY;
                    }
                    if (min < NumericLeafComparator.this.minValueAsLong || max > NumericLeafComparator.this.maxValueAsLong) {
                        return PointValues.Relation.CELL_CROSSES_QUERY;
                    }
                    return PointValues.Relation.CELL_INSIDE_QUERY;
                }
            };
            long threshold = this.iteratorCost >>> 3;
            if (PointValues.isEstimatedPointCountGreaterThanOrEqualTo(visitor, this.getPointTree(), threshold)) {
                this.updateSkipInterval(false);
                if ((long)this.pointValues.getDocCount() < this.iteratorCost) {
                    this.competitiveIterator = this.getNumericDocValues(this.context, NumericComparator.this.field);
                    this.iteratorCost = this.pointValues.getDocCount();
                }
                return;
            }
            this.pointValues.intersect(visitor);
            this.competitiveIterator = result.build().iterator();
            this.iteratorCost = this.competitiveIterator.cost();
            this.updateSkipInterval(true);
        }

        private PointValues.PointTree getPointTree() throws IOException {
            if (this.pointTree == null) {
                this.pointTree = this.pointValues.getPointTree();
            }
            return this.pointTree;
        }

        private void updateSkipInterval(boolean success) {
            if (this.updateCounter > 256) {
                if (success) {
                    this.currentSkipInterval = Math.max(this.currentSkipInterval / 2, 32);
                    this.tryUpdateFailCount = 0;
                } else if (this.tryUpdateFailCount >= 3) {
                    this.currentSkipInterval = Math.min(this.currentSkipInterval * 2, 8192);
                    this.tryUpdateFailCount = 0;
                } else {
                    ++this.tryUpdateFailCount;
                }
            }
        }

        private void encodeBottom() {
            if (!NumericComparator.this.reverse) {
                this.maxValueAsLong = this.bottomAsComparableLong();
                if (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && this.maxValueAsLong != Long.MIN_VALUE) {
                    --this.maxValueAsLong;
                }
            } else {
                this.minValueAsLong = this.bottomAsComparableLong();
                if (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && this.minValueAsLong != Long.MAX_VALUE) {
                    ++this.minValueAsLong;
                }
            }
        }

        private void encodeTop() {
            if (!NumericComparator.this.reverse) {
                this.minValueAsLong = this.topAsComparableLong();
                if (NumericComparator.this.singleSort && NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && NumericComparator.this.queueFull && this.minValueAsLong != Long.MAX_VALUE) {
                    ++this.minValueAsLong;
                }
            } else {
                this.maxValueAsLong = this.topAsComparableLong();
                if (NumericComparator.this.singleSort && NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO && NumericComparator.this.queueFull && this.maxValueAsLong != Long.MIN_VALUE) {
                    --this.maxValueAsLong;
                }
            }
        }

        private boolean isMissingValueCompetitive() {
            int result;
            if (NumericComparator.this.queueFull) {
                boolean competitive;
                result = Long.compare(NumericComparator.this.missingValueAsLong, this.bottomAsComparableLong());
                boolean bl = NumericComparator.this.reverse ? (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO ? result > 0 : result >= 0) : (NumericComparator.this.pruning == Pruning.GREATER_THAN_OR_EQUAL_TO ? result < 0 : (competitive = result <= 0));
                if (!competitive) {
                    return false;
                }
            }
            if (this.leafTopSet) {
                result = Long.compare(NumericComparator.this.missingValueAsLong, this.topAsComparableLong());
                return NumericComparator.this.reverse ? result <= 0 : result >= 0;
            }
            return true;
        }

        @Override
        public DocIdSetIterator competitiveIterator() {
            if (!this.enableSkipping) {
                return null;
            }
            return new DocIdSetIterator(){
                private int docID;
                {
                    this.docID = NumericLeafComparator.this.competitiveIterator.docID();
                }

                @Override
                public int nextDoc() throws IOException {
                    return this.advance(this.docID + 1);
                }

                @Override
                public int docID() {
                    return this.docID;
                }

                @Override
                public long cost() {
                    return NumericLeafComparator.this.competitiveIterator.cost();
                }

                @Override
                public int advance(int target) throws IOException {
                    this.docID = NumericLeafComparator.this.competitiveIterator.advance(target);
                    return this.docID;
                }

                @Override
                public void intoBitSet(int upTo, FixedBitSet bitSet, int offset) throws IOException {
                    if (NumericLeafComparator.this.competitiveIterator.docID() < this.docID) {
                        NumericLeafComparator.this.competitiveIterator.advance(this.docID);
                    }
                    NumericLeafComparator.this.competitiveIterator.intoBitSet(upTo, bitSet, offset);
                    this.docID = NumericLeafComparator.this.competitiveIterator.docID();
                }
            };
        }

        protected abstract long bottomAsComparableLong();

        protected abstract long topAsComparableLong();
    }
}

