/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.core.op.PushOperationSpecification;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.osgi.util.NLS;

public class PushOperation {
    private final Repository localDb;
    private final PushOperationSpecification specification;
    private final boolean dryRun;
    private final String remoteName;
    private final int timeout;
    private OutputStream out;
    private PushOperationResult operationResult;
    private CredentialsProvider credentialsProvider;

    public PushOperation(Repository localDb, PushOperationSpecification specification, boolean dryRun, int timeout) {
        this(localDb, null, specification, dryRun, timeout);
    }

    public PushOperation(Repository localDb, String remoteName, boolean dryRun, int timeout) {
        this(localDb, remoteName, null, dryRun, timeout);
    }

    private PushOperation(Repository localDb, String remoteName, PushOperationSpecification specification, boolean dryRun, int timeout) {
        this.localDb = localDb;
        this.specification = specification;
        this.dryRun = dryRun;
        this.remoteName = remoteName;
        this.timeout = timeout;
    }

    public static RemoteConfig getRemote(String branch, Config config) {
        List allRemotes;
        if (branch == null) {
            return null;
        }
        String defaultPushRemote = config.getString("remote", branch, "pushDefault");
        String remoteName = null;
        if (!ObjectId.isId((String)branch) && (remoteName = config.getString("branch", branch, "pushRemote")) == null) {
            remoteName = defaultPushRemote != null ? defaultPushRemote : config.getString("branch", branch, "remote");
        }
        if (defaultPushRemote == null) {
            defaultPushRemote = "origin";
        }
        try {
            allRemotes = RemoteConfig.getAllRemoteConfigs((Config)config);
        }
        catch (URISyntaxException e) {
            return null;
        }
        RemoteConfig defaultConfig = null;
        for (RemoteConfig cfg : allRemotes) {
            if (remoteName != null && cfg.getName().equals(remoteName)) {
                return cfg;
            }
            if (cfg.getName().equals(defaultPushRemote)) {
                defaultConfig = cfg;
                continue;
            }
            if (defaultConfig != null || !cfg.getName().equals("origin")) continue;
            defaultConfig = cfg;
        }
        return defaultConfig;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public PushOperationResult getOperationResult() {
        if (this.operationResult == null) {
            throw new IllegalStateException(CoreText.OperationNotYetExecuted);
        }
        return this.operationResult;
    }

    public PushOperationSpecification getSpecification() {
        return this.specification;
    }

    /*
     * Unable to fully structure code
     */
    public void run(IProgressMonitor actMonitor) throws InvocationTargetException {
        block93: {
            if (this.operationResult != null) {
                throw new IllegalStateException(CoreText.OperationAlreadyExecuted);
            }
            if (this.specification != null) {
                for (URIish uri : this.specification.getURIs()) {
                    for (RemoteRefUpdate update : this.specification.getRefUpdates(uri)) {
                        if (update.getStatus() == RemoteRefUpdate.Status.NOT_ATTEMPTED) continue;
                        throw new IllegalStateException(CoreText.RemoteRefUpdateCantBeReused);
                    }
                }
            }
            totalWork = this.specification != null ? this.specification.getURIsNumber() : 1;
            taskName = this.dryRun != false ? CoreText.PushOperation_taskNameDryRun : CoreText.PushOperation_taskNameNormalRun;
            progress = SubMonitor.convert((IProgressMonitor)actMonitor, (int)totalWork);
            progress.setTaskName(taskName);
            this.operationResult = new PushOperationResult();
            var5_6 = null;
            var6_8 = null;
            try {
                git = new Git(this.localDb);
                try {
                    hookCharset = SystemReader.getInstance().getDefaultCharset();
                    if (this.specification != null) {
                        allHookOutputs = new StringBuilder();
                        allHookErrors = new StringBuilder();
                        for (URIish uri : this.specification.getURIs()) {
                            if (progress.isCanceled()) {
                                this.operationResult.addOperationResult(uri, CoreText.PushOperation_resultCancelled);
                                progress.worked(1);
                                continue;
                            }
                            refUpdates = this.specification.getRefUpdates(uri);
                            gitSubMonitor = new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(1));
                            try {
                                var15_35 = null;
                                var16_40 = null;
                                try {
                                    transport = Transport.open((Repository)this.localDb, (URIish)uri);
                                    try {
                                        transport.setDryRun(this.dryRun);
                                        transport.setTimeout(this.timeout);
                                        if (this.credentialsProvider != null) {
                                            transport.setCredentialsProvider(this.credentialsProvider);
                                        }
                                        var18_45 = null;
                                        var19_48 = null;
                                        try {
                                            hookOutBytes = new ByteArrayOutputStream();
                                            try {
                                                hookErrBytes = new ByteArrayOutputStream();
                                                try {
                                                    stdout = new PrintStream((OutputStream)hookOutBytes, true, hookCharset);
                                                    try {
                                                        stderr = new PrintStream((OutputStream)hookErrBytes, true, hookCharset);
                                                        try {
                                                            transport.setHookOutputStream(stdout);
                                                            transport.setHookErrorStream(stderr);
                                                            result = transport.push((ProgressMonitor)gitSubMonitor, refUpdates, this.out);
                                                            stdout.flush();
                                                            stderr.flush();
                                                            this.addHookMessage(result.getURI(), hookOutBytes.toString(hookCharset), allHookOutputs);
                                                            this.addHookMessage(result.getURI(), hookErrBytes.toString(hookCharset), allHookErrors);
                                                            this.operationResult.addOperationResult(result.getURI(), result);
                                                            this.specification.addURIRefUpdates(result.getURI(), result.getRemoteUpdates());
                                                        }
                                                        finally {
                                                            if (stderr != null) {
                                                                stderr.close();
                                                            }
                                                        }
                                                        if (stdout != null) {
                                                            stdout.close();
                                                        }
                                                    }
                                                    catch (Throwable var19_49) {
                                                        if (var18_45 == null) {
                                                            var18_45 = var19_49;
                                                        } else if (var18_45 != var19_49) {
                                                            var18_45.addSuppressed(var19_49);
                                                        }
                                                        if (stdout != null) {
                                                            stdout.close();
                                                        }
                                                        throw var18_45;
                                                    }
                                                    ** if (hookErrBytes == null) goto lbl-1000
                                                }
                                                catch (Throwable var19_50) {
                                                    if (var18_45 == null) {
                                                        var18_45 = var19_50;
                                                    } else if (var18_45 != var19_50) {
                                                        var18_45.addSuppressed(var19_50);
                                                    }
                                                    if (hookErrBytes != null) {
                                                        hookErrBytes.close();
                                                    }
                                                    throw var18_45;
                                                }
lbl-1000:
                                                // 1 sources

                                                {
                                                    hookErrBytes.close();
                                                }
lbl-1000:
                                                // 2 sources

                                                {
                                                }
                                                if (hookOutBytes == null) continue;
                                            }
                                            catch (Throwable var19_51) {
                                                if (var18_45 == null) {
                                                    var18_45 = var19_51;
                                                } else if (var18_45 != var19_51) {
                                                    var18_45.addSuppressed(var19_51);
                                                }
                                                if (hookOutBytes != null) {
                                                    hookOutBytes.close();
                                                }
                                                throw var18_45;
                                            }
                                            hookOutBytes.close();
                                        }
                                        catch (Throwable var19_52) {
                                            if (var18_45 == null) {
                                                var18_45 = var19_52;
                                            } else if (var18_45 != var19_52) {
                                                var18_45.addSuppressed(var19_52);
                                            }
                                            throw var18_45;
                                        }
                                    }
                                    finally {
                                        if (transport != null) {
                                            transport.close();
                                        }
                                    }
                                }
                                catch (Throwable var16_41) {
                                    if (var15_35 == null) {
                                        var15_35 = var16_41;
                                    } else if (var15_35 != var16_41) {
                                        var15_35.addSuppressed(var16_41);
                                    }
                                    throw var15_35;
                                }
                            }
                            catch (JGitInternalException e) {
                                errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                                userMessage = NLS.bind((String)CoreText.PushOperation_InternalExceptionOccurredMessage, (Object)errorMessage);
                                this.handleException(uri, (Exception)e, userMessage);
                            }
                            catch (Exception e) {
                                this.handleException(uri, e, e.getMessage());
                            }
                        }
                        this.operationResult.setHookOutput(allHookOutputs.toString(), allHookErrors.toString());
                        break block93;
                    }
                    gitMonitor = new EclipseGitProgressTransformer((IProgressMonitor)progress.newChild(totalWork));
                    try {
                        allHookErrors = null;
                        uri = null;
                        try {
                            hookOutBytes = new ByteArrayOutputStream();
                            try {
                                hookErrBytes = new ByteArrayOutputStream();
                                try {
                                    stdout = new PrintStream((OutputStream)hookOutBytes, true, hookCharset);
                                    try {
                                        stderr = new PrintStream((OutputStream)hookErrBytes, true, hookCharset);
                                        try {
                                            results = ((PushCommand)((PushCommand)git.push().setRemote(this.remoteName).setDryRun(this.dryRun).setTimeout(this.timeout)).setProgressMonitor((ProgressMonitor)gitMonitor).setCredentialsProvider(this.credentialsProvider)).setOutputStream(this.out).setHookOutputStream(stdout).setHookErrorStream(stderr).call();
                                            stdout.flush();
                                            stderr.flush();
                                            this.operationResult.setHookOutput(hookOutBytes.toString(hookCharset), hookErrBytes.toString(hookCharset));
                                            for (PushResult result : results) {
                                                this.operationResult.addOperationResult(result.getURI(), result);
                                            }
                                        }
                                        finally {
                                            if (stderr != null) {
                                                stderr.close();
                                            }
                                        }
                                        if (stdout != null) {
                                            stdout.close();
                                        }
                                    }
                                    catch (Throwable uri) {
                                        if (allHookErrors == null) {
                                            allHookErrors = uri;
                                        } else if (allHookErrors != uri) {
                                            allHookErrors.addSuppressed(uri);
                                        }
                                        if (stdout != null) {
                                            stdout.close();
                                        }
                                        throw allHookErrors;
                                    }
                                    ** if (hookErrBytes == null) goto lbl-1000
                                }
                                catch (Throwable uri) {
                                    if (allHookErrors == null) {
                                        allHookErrors = uri;
                                    } else if (allHookErrors != uri) {
                                        allHookErrors.addSuppressed(uri);
                                    }
                                    if (hookErrBytes != null) {
                                        hookErrBytes.close();
                                    }
                                    throw allHookErrors;
                                }
lbl-1000:
                                // 1 sources

                                {
                                    hookErrBytes.close();
                                }
lbl-1000:
                                // 2 sources

                                {
                                }
                                ** if (hookOutBytes == null) goto lbl-1000
                            }
                            catch (Throwable uri) {
                                if (allHookErrors == null) {
                                    allHookErrors = uri;
                                } else if (allHookErrors != uri) {
                                    allHookErrors.addSuppressed(uri);
                                }
                                if (hookOutBytes != null) {
                                    hookOutBytes.close();
                                }
                                throw allHookErrors;
                            }
lbl-1000:
                            // 1 sources

                            {
                                hookOutBytes.close();
                            }
lbl-1000:
                            // 2 sources

                            {
                            }
                        }
                        catch (Throwable uri) {
                            if (allHookErrors == null) {
                                allHookErrors = uri;
                            } else if (allHookErrors != uri) {
                                allHookErrors.addSuppressed(uri);
                            }
                            throw allHookErrors;
                        }
                    }
                    catch (JGitInternalException e) {
                        errorMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                        userMessage = NLS.bind((String)CoreText.PushOperation_InternalExceptionOccurredMessage, (Object)errorMessage);
                        uri = this.getPushURIForErrorHandling();
                        this.handleException(uri, (Exception)e, userMessage);
                    }
                    catch (Exception e) {
                        uri = this.getPushURIForErrorHandling();
                        this.handleException(uri, e, e.getMessage());
                    }
                }
                finally {
                    if (git != null) {
                        git.close();
                    }
                }
            }
            catch (Throwable var6_9) {
                if (var5_6 == null) {
                    var5_6 = var6_9;
                } else if (var5_6 != var6_9) {
                    var5_6.addSuppressed(var6_9);
                }
                throw var5_6;
            }
        }
    }

    private void addHookMessage(URIish uri, String msg, StringBuilder all) {
        if (!msg.isEmpty()) {
            if (all.length() > 0 && all.charAt(all.length() - 1) != '\n') {
                all.append('\n');
            }
            all.append(MessageFormat.format(CoreText.PushOperation_ForUri, uri));
            all.append('\n');
            all.append(msg);
        }
    }

    private void handleException(URIish uri, Exception e, String userMessage) {
        String uriString;
        if (uri != null) {
            this.operationResult.addOperationResult(uri, userMessage);
            uriString = uri.toString();
        } else {
            uriString = "retrieving URI failed";
        }
        String userMessageForUri = NLS.bind((String)CoreText.PushOperation_ExceptionOccurredDuringPushOnUriMessage, (Object)uriString, (Object)userMessage);
        Activator.logError(userMessageForUri, e);
    }

    private URIish getPushURIForErrorHandling() {
        RemoteConfig rc = null;
        try {
            rc = new RemoteConfig((Config)this.localDb.getConfig(), this.remoteName);
            return rc.getPushURIs().isEmpty() ? (URIish)rc.getURIs().get(0) : (URIish)rc.getPushURIs().get(0);
        }
        catch (URISyntaxException e) {
            Activator.logError("Reading RemoteConfig failed", e);
            return null;
        }
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }
}

