/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testrail;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TestRailStepStatus implements Enumerator
{
    PASSED(1, "passed", "passed"),
    BLOCKED(2, "blocked", "blocked"),
    UNTESTED(3, "untested", "untested"),
    RETEST(4, "retest", "retest"),
    FAILED(5, "failed", "failed");

    public static final int PASSED_VALUE = 1;
    public static final int BLOCKED_VALUE = 2;
    public static final int UNTESTED_VALUE = 3;
    public static final int RETEST_VALUE = 4;
    public static final int FAILED_VALUE = 5;
    private static final TestRailStepStatus[] VALUES_ARRAY;
    public static final List<TestRailStepStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TestRailStepStatus[]{PASSED, BLOCKED, UNTESTED, RETEST, FAILED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TestRailStepStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TestRailStepStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TestRailStepStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TestRailStepStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TestRailStepStatus get(int value) {
        switch (value) {
            case 1: {
                return PASSED;
            }
            case 2: {
                return BLOCKED;
            }
            case 3: {
                return UNTESTED;
            }
            case 4: {
                return RETEST;
            }
            case 5: {
                return FAILED;
            }
        }
        return null;
    }

    private TestRailStepStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

