/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.pde.api.tools.internal.provisional.builder.IBuildContext;

public class BuildContext
implements IBuildContext {
    private static final String[] NO_TYPES = new String[0];
    private StringSet structualChanges = null;
    private StringSet removedTypes = null;
    private StringSet descriptionChanges = null;
    private StringSet descriptionDepedents = null;

    @Override
    public String[] getStructurallyChangedTypes() {
        if (this.structualChanges == null) {
            return NO_TYPES;
        }
        return this.structualChanges.values;
    }

    @Override
    public String[] getDescriptionChangedTypes() {
        if (this.descriptionChanges == null) {
            return NO_TYPES;
        }
        return this.descriptionChanges.values;
    }

    @Override
    public String[] getRemovedTypes() {
        if (this.removedTypes == null) {
            return NO_TYPES;
        }
        return this.removedTypes.values;
    }

    @Override
    public boolean hasStructuralChanges() {
        int count = this.structualChanges == null ? 0 : this.structualChanges.elementSize;
        return (count += this.removedTypes == null ? 0 : this.removedTypes.elementSize) > 0;
    }

    @Override
    public boolean hasDescriptionChanges() {
        return (this.descriptionChanges == null ? 0 : this.descriptionChanges.elementSize) > 0;
    }

    @Override
    public boolean hasDescriptionDependents() {
        return (this.descriptionDepedents == null ? 0 : this.descriptionDepedents.elementSize) > 0;
    }

    @Override
    public boolean hasRemovedTypes() {
        return (this.removedTypes == null ? 0 : this.removedTypes.elementSize) > 0;
    }

    public void recordStructuralChange(String typename) {
        if (typename == null) {
            return;
        }
        if (this.structualChanges == null) {
            this.structualChanges = new StringSet(16);
        }
        this.structualChanges.add(typename.replace('/', '.'));
    }

    public void recordRemovedType(String typename) {
        if (typename == null) {
            return;
        }
        if (this.removedTypes == null) {
            this.removedTypes = new StringSet(16);
        }
        this.removedTypes.add(typename.replace('/', '.'));
    }

    public void recordDescriptionChanged(String typename) {
        if (typename != null) {
            if (this.descriptionChanges == null) {
                this.descriptionChanges = new StringSet(16);
            }
            this.descriptionChanges.add(typename.replace('/', '.'));
        }
    }

    public void recordDescriptionDependent(String typename) {
        if (typename == null) {
            return;
        }
        if (this.descriptionDepedents == null) {
            this.descriptionDepedents = new StringSet(16);
        }
        this.descriptionDepedents.add(typename.replace('/', '.'));
    }

    @Override
    public void dispose() {
        if (this.structualChanges != null) {
            this.structualChanges.clear();
            this.structualChanges = null;
        }
        if (this.removedTypes != null) {
            this.removedTypes.clear();
            this.removedTypes = null;
        }
        if (this.descriptionChanges != null) {
            this.descriptionChanges.clear();
            this.descriptionChanges = null;
        }
        if (this.descriptionDepedents != null) {
            this.descriptionDepedents.clear();
            this.descriptionDepedents = null;
        }
    }

    @Override
    public boolean hasTypes() {
        return this.hasStructuralChanges() || this.hasRemovedTypes() || this.hasDescriptionChanges() || this.hasDescriptionDependents();
    }

    @Override
    public boolean containsStructuralChange(String typename) {
        if (typename == null) {
            return false;
        }
        return this.structualChanges != null && this.structualChanges.includes(typename.replace('/', '.'));
    }

    @Override
    public boolean containsDescriptionChange(String typename) {
        if (typename == null) {
            return false;
        }
        return this.descriptionChanges != null && this.descriptionChanges.includes(typename.replace('/', '.'));
    }

    @Override
    public boolean containsDescriptionDependent(String typename) {
        if (typename == null) {
            return false;
        }
        return this.descriptionDepedents != null && this.descriptionDepedents.includes(typename.replace('/', '.'));
    }

    @Override
    public boolean containsRemovedType(String typename) {
        if (typename == null) {
            return false;
        }
        return this.removedTypes != null && this.removedTypes.includes(typename.replace('/', '.'));
    }

    @Override
    public String[] getDescriptionDependentTypes() {
        if (this.descriptionDepedents == null) {
            return NO_TYPES;
        }
        return this.descriptionDepedents.values;
    }
}

